/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier;

import com.rollbar.api.annotations.Unstable;
import com.rollbar.api.payload.Payload;
import com.rollbar.api.payload.data.Data;
import com.rollbar.api.payload.data.Level;
import com.rollbar.jvmti.ThrowableCache;
import com.rollbar.notifier.config.CommonConfig;
import com.rollbar.notifier.truncation.PayloadTruncator;
import com.rollbar.notifier.util.BodyFactory;
import com.rollbar.notifier.util.ObjectsUtils;
import com.rollbar.notifier.wrapper.RollbarThrowableWrapper;
import com.rollbar.notifier.wrapper.ThrowableWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Unstable
public abstract class RollbarBase<RESULT, C extends CommonConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RollbarBase.class);
    private static final int MAX_PAYLOAD_SIZE_BYTES = 524288;
    protected BodyFactory bodyFactory;
    protected PayloadTruncator payloadTruncator;
    protected C config;
    protected final ReadWriteLock configReadWriteLock = new ReentrantReadWriteLock();
    protected final Lock configReadLock = this.configReadWriteLock.readLock();
    protected final Lock configWriteLock = this.configReadWriteLock.writeLock();
    private final RESULT emptyResult;

    protected RollbarBase(C config, BodyFactory bodyFactory, RESULT emptyResult) {
        this.config = config;
        this.configureTruncation(config);
        this.bodyFactory = bodyFactory;
        this.emptyResult = emptyResult;
    }

    protected void configure(C config) {
        LOGGER.debug("Reloading configuration.");
        this.configWriteLock.lock();
        try {
            this.config = config;
            this.configureTruncation(config);
            this.processAppPackages((CommonConfig)config);
        }
        finally {
            this.configWriteLock.unlock();
        }
    }

    private void configureTruncation(C config) {
        if (config.truncateLargePayloads()) {
            ObjectsUtils.requireNonNull(config.jsonSerializer(), "A JSON serializer is required when performing payload truncation.");
            this.payloadTruncator = new PayloadTruncator(config.jsonSerializer());
        } else {
            this.payloadTruncator = null;
        }
    }

    protected void processAppPackages(CommonConfig config) {
        for (String appPackage : config.appPackages()) {
            ThrowableCache.addAppPackage(appPackage);
        }
    }

    protected Level level(CommonConfig config, Throwable error) {
        if (error == null) {
            return config.defaultMessageLevel();
        }
        if (error instanceof Error) {
            return config.defaultErrorLevel();
        }
        return config.defaultThrowableLevel();
    }

    private Level getOccurrenceLevel(CommonConfig config, ThrowableWrapper error, Level levelOverride) {
        if (levelOverride != null) {
            return levelOverride;
        }
        Throwable throwable = error == null ? null : error.getThrowable();
        return this.level(config, throwable);
    }

    protected Data buildData(CommonConfig config, ThrowableWrapper error, Map<String, Object> custom, String description, Level level, boolean isUncaught) {
        Data.Builder dataBuilder = new Data.Builder().environment(config.environment()).codeVersion(config.codeVersion()).platform(config.platform()).language(config.language()).framework(config.framework()).level(this.getOccurrenceLevel(config, error, level)).body(this.bodyFactory.from(error, description)).isUncaught(isUncaught);
        if (config.context() != null) {
            LOGGER.debug("Gathering context info.");
            dataBuilder.context(config.context().provide());
        }
        if (config.request() != null) {
            LOGGER.debug("Gathering request info.");
            dataBuilder.request(config.request().provide());
        }
        if (config.person() != null) {
            LOGGER.debug("Gathering person info.");
            dataBuilder.person(config.person().provide());
        }
        if (config.server() != null) {
            LOGGER.debug("Gathering server info.");
            dataBuilder.server(config.server().provide());
        }
        if (config.client() != null) {
            LOGGER.debug("Gathering client info.");
            dataBuilder.client(config.client().provide());
        }
        HashMap<String, Object> tmpCustom = new HashMap<String, Object>();
        if (config.custom() != null) {
            LOGGER.debug("Gathering custom info.");
            Map<String, Object> customProvided = config.custom().provide();
            if (customProvided != null) {
                tmpCustom.putAll(customProvided);
            }
        }
        if (custom != null) {
            tmpCustom.putAll(custom);
        }
        if (tmpCustom.size() > 0) {
            dataBuilder.custom(tmpCustom);
        }
        if (config.notifier() != null) {
            LOGGER.debug("Gathering notifier info.");
            dataBuilder.notifier(config.notifier().provide());
        }
        if (config.timestamp() != null) {
            LOGGER.debug("Gathering timestamp info.");
            dataBuilder.timestamp(config.timestamp().provide());
        }
        return dataBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RESULT process(ThrowableWrapper error, Map<String, Object> custom, String description, Level level, boolean isUncaught) {
        C config;
        this.configReadLock.lock();
        try {
            config = this.config;
        }
        finally {
            this.configReadLock.unlock();
        }
        if (!config.isEnabled()) {
            LOGGER.debug("Notifier disabled.");
            return this.emptyResult;
        }
        if (config.filter() != null && config.filter().preProcess(level, error != null ? error.getThrowable() : null, custom, description)) {
            LOGGER.debug("Pre-filtered error: {}", (Object)error);
            return this.emptyResult;
        }
        LOGGER.debug("Gathering information to build the payload.");
        Data data = this.buildData((CommonConfig)config, error, custom, description, level, isUncaught);
        if (config.transformer() != null) {
            LOGGER.debug("Transforming the data.");
            data = config.transformer().transform(data);
        }
        if (config.uuidGenerator() != null || config.fingerPrintGenerator() != null) {
            Data.Builder dataBuilder = new Data.Builder(data);
            if (config.uuidGenerator() != null) {
                LOGGER.debug("Generating UUID.");
                dataBuilder.uuid(config.uuidGenerator().from(data));
            }
            if (config.fingerPrintGenerator() != null) {
                LOGGER.debug("Generating fingerprint.");
                dataBuilder.fingerprint(config.fingerPrintGenerator().from(data));
            }
            data = dataBuilder.build();
        }
        if (config.filter() != null && config.filter().postProcess(data)) {
            LOGGER.debug("Post-filtered error: {}", (Object)error);
            return this.emptyResult;
        }
        Payload payload = new Payload.Builder().accessToken(config.accessToken()).data(data).build();
        LOGGER.debug("Payload built: {}", (Object)payload);
        payload = this.truncateIfNecessary(config, payload);
        return this.sendPayload(config, payload);
    }

    private Payload truncateIfNecessary(C config, Payload payload) {
        boolean doTruncate = config.truncateLargePayloads();
        PayloadTruncator truncator = this.payloadTruncator;
        if (doTruncate && truncator != null) {
            PayloadTruncator.PayloadTruncationResult result = truncator.truncate(payload, 524288);
            payload = result.getPayload();
            if (result.finalSize > 524288) {
                LOGGER.warn("Sending payload with size " + result.finalSize + " bytes, which is over the limit of " + 524288 + " bytes");
            }
        }
        return payload;
    }

    protected RollbarThrowableWrapper wrapThrowable(Throwable error) {
        RollbarThrowableWrapper rollbarThrowableWrapper = null;
        if (error != null) {
            rollbarThrowableWrapper = new RollbarThrowableWrapper(error);
        }
        return rollbarThrowableWrapper;
    }

    protected abstract RESULT sendPayload(C var1, Payload var2);
}

