//   NOTE: This -*- java -*- source code is autogenerated from the AMQP
//         specification!
//
// Copyright (c) 2007-2023 Broadcom. All Rights Reserved. The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
//
// This software, the RabbitMQ Java client library, is triple-licensed under the
// Mozilla Public License 2.0 ("MPL"), the GNU General Public License version 2
// ("GPL") and the Apache License version 2 ("ASL"). For the MPL, please see
// LICENSE-MPL-RabbitMQ. For the GPL, please see LICENSE-GPL2.  For the ASL,
// please see LICENSE-APACHE2.
//
// This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND,
// either express or implied. See the LICENSE file for specific language governing
// rights and limitations of this software.
//
// If you have any questions regarding licensing, please contact us at
// info@rabbitmq.com.
//

package com.rabbitmq.client.impl;

import java.io.IOException;
import java.io.DataInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.LongString;
import com.rabbitmq.client.UnknownClassOrMethodId;
import com.rabbitmq.client.UnexpectedMethodError;

public class AMQImpl implements AMQP {

    public static class Connection {
        public static final int INDEX = 10;

        public static class Start
            extends Method
            implements com.rabbitmq.client.AMQP.Connection.Start
        {
            public static final int INDEX = 10;

            private final int versionMajor;
            private final int versionMinor;
            private final Map<String,Object> serverProperties;
            private final LongString mechanisms;
            private final LongString locales;

            public int getVersionMajor() { return versionMajor; }
            public int getVersionMinor() { return versionMinor; }
            public Map<String,Object> getServerProperties() { return serverProperties; }
            public LongString getMechanisms() { return mechanisms; }
            public LongString getLocales() { return locales; }

            public Start(int versionMajor, int versionMinor, Map<String,Object> serverProperties, LongString mechanisms, LongString locales) {
                if (locales == null)
                    throw new IllegalStateException("Invalid configuration: 'locales' must be non-null.");
                if (mechanisms == null)
                    throw new IllegalStateException("Invalid configuration: 'mechanisms' must be non-null.");
                this.versionMajor = versionMajor;
                this.versionMinor = versionMinor;
                this.serverProperties = serverProperties==null ? null : Collections.unmodifiableMap(new HashMap<String,Object>(serverProperties));
                this.mechanisms = mechanisms;
                this.locales = locales;
            }
            public Start(MethodArgumentReader rdr) throws IOException {
                this(rdr.readOctet(), rdr.readOctet(), rdr.readTable(), rdr.readLongstr(), rdr.readLongstr());
            }

            public int protocolClassId() { return 10; }
            public int protocolMethodId() { return 10; }
            public String protocolMethodName() { return "connection.start";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Start that = (Start) o;
            if (versionMajor != that.versionMajor)
                return false;
            if (versionMinor != that.versionMinor)
                return false;
            if (serverProperties != null ? !serverProperties.equals(that.serverProperties) : that.serverProperties != null)
                return false;
            if (mechanisms != null ? !mechanisms.equals(that.mechanisms) : that.mechanisms != null)
                return false;
            if (locales != null ? !locales.equals(that.locales) : that.locales != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + versionMajor;
            result = 31 * result + versionMinor;
            result = 31 * result + (serverProperties != null ? serverProperties.hashCode() : 0);
            result = 31 * result + (mechanisms != null ? mechanisms.hashCode() : 0);
            result = 31 * result + (locales != null ? locales.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(version-major=")
                   .append(this.versionMajor)
                   .append(", version-minor=")
                   .append(this.versionMinor)
                   .append(", server-properties=")
                   .append(this.serverProperties)
                   .append(", mechanisms=")
                   .append(this.mechanisms)
                   .append(", locales=")
                   .append(this.locales)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeOctet(this.versionMajor);
                writer.writeOctet(this.versionMinor);
                writer.writeTable(this.serverProperties);
                writer.writeLongstr(this.mechanisms);
                writer.writeLongstr(this.locales);
            }
        }

        public static class StartOk
            extends Method
            implements com.rabbitmq.client.AMQP.Connection.StartOk
        {
            public static final int INDEX = 11;

            private final Map<String,Object> clientProperties;
            private final String mechanism;
            private final LongString response;
            private final String locale;

            public Map<String,Object> getClientProperties() { return clientProperties; }
            public String getMechanism() { return mechanism; }
            public LongString getResponse() { return response; }
            public String getLocale() { return locale; }

            public StartOk(Map<String,Object> clientProperties, String mechanism, LongString response, String locale) {
                if (locale == null)
                    throw new IllegalStateException("Invalid configuration: 'locale' must be non-null.");
                if (mechanism == null)
                    throw new IllegalStateException("Invalid configuration: 'mechanism' must be non-null.");
                if (response == null)
                    throw new IllegalStateException("Invalid configuration: 'response' must be non-null.");
                this.clientProperties = clientProperties==null ? null : Collections.unmodifiableMap(new HashMap<String,Object>(clientProperties));
                this.mechanism = mechanism;
                this.response = response;
                this.locale = locale;
            }
            public StartOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readTable(), rdr.readShortstr(), rdr.readLongstr(), rdr.readShortstr());
            }

            public int protocolClassId() { return 10; }
            public int protocolMethodId() { return 11; }
            public String protocolMethodName() { return "connection.start-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            StartOk that = (StartOk) o;
            if (clientProperties != null ? !clientProperties.equals(that.clientProperties) : that.clientProperties != null)
                return false;
            if (mechanism != null ? !mechanism.equals(that.mechanism) : that.mechanism != null)
                return false;
            if (response != null ? !response.equals(that.response) : that.response != null)
                return false;
            if (locale != null ? !locale.equals(that.locale) : that.locale != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (clientProperties != null ? clientProperties.hashCode() : 0);
            result = 31 * result + (mechanism != null ? mechanism.hashCode() : 0);
            result = 31 * result + (response != null ? response.hashCode() : 0);
            result = 31 * result + (locale != null ? locale.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(client-properties=")
                   .append(this.clientProperties)
                   .append(", mechanism=")
                   .append(this.mechanism)
                   .append(", response=")
                   .append(this.response)
                   .append(", locale=")
                   .append(this.locale)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeTable(this.clientProperties);
                writer.writeShortstr(this.mechanism);
                writer.writeLongstr(this.response);
                writer.writeShortstr(this.locale);
            }
        }

        public static class Secure
            extends Method
            implements com.rabbitmq.client.AMQP.Connection.Secure
        {
            public static final int INDEX = 20;

            private final LongString challenge;

            public LongString getChallenge() { return challenge; }

            public Secure(LongString challenge) {
                if (challenge == null)
                    throw new IllegalStateException("Invalid configuration: 'challenge' must be non-null.");
                this.challenge = challenge;
            }
            public Secure(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLongstr());
            }

            public int protocolClassId() { return 10; }
            public int protocolMethodId() { return 20; }
            public String protocolMethodName() { return "connection.secure";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Secure that = (Secure) o;
            if (challenge != null ? !challenge.equals(that.challenge) : that.challenge != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (challenge != null ? challenge.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(challenge=")
                   .append(this.challenge)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeLongstr(this.challenge);
            }
        }

        public static class SecureOk
            extends Method
            implements com.rabbitmq.client.AMQP.Connection.SecureOk
        {
            public static final int INDEX = 21;

            private final LongString response;

            public LongString getResponse() { return response; }

            public SecureOk(LongString response) {
                if (response == null)
                    throw new IllegalStateException("Invalid configuration: 'response' must be non-null.");
                this.response = response;
            }
            public SecureOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLongstr());
            }

            public int protocolClassId() { return 10; }
            public int protocolMethodId() { return 21; }
            public String protocolMethodName() { return "connection.secure-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            SecureOk that = (SecureOk) o;
            if (response != null ? !response.equals(that.response) : that.response != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (response != null ? response.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(response=")
                   .append(this.response)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeLongstr(this.response);
            }
        }

        public static class Tune
            extends Method
            implements com.rabbitmq.client.AMQP.Connection.Tune
        {
            public static final int INDEX = 30;

            private final int channelMax;
            private final int frameMax;
            private final int heartbeat;

            public int getChannelMax() { return channelMax; }
            public int getFrameMax() { return frameMax; }
            public int getHeartbeat() { return heartbeat; }

            public Tune(int channelMax, int frameMax, int heartbeat) {
                this.channelMax = channelMax;
                this.frameMax = frameMax;
                this.heartbeat = heartbeat;
            }
            public Tune(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readLong(), rdr.readShort());
            }

            public int protocolClassId() { return 10; }
            public int protocolMethodId() { return 30; }
            public String protocolMethodName() { return "connection.tune";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Tune that = (Tune) o;
            if (channelMax != that.channelMax)
                return false;
            if (frameMax != that.frameMax)
                return false;
            if (heartbeat != that.heartbeat)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + channelMax;
            result = 31 * result + frameMax;
            result = 31 * result + heartbeat;
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(channel-max=")
                   .append(this.channelMax)
                   .append(", frame-max=")
                   .append(this.frameMax)
                   .append(", heartbeat=")
                   .append(this.heartbeat)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShort(this.channelMax);
                writer.writeLong(this.frameMax);
                writer.writeShort(this.heartbeat);
            }
        }

        public static class TuneOk
            extends Method
            implements com.rabbitmq.client.AMQP.Connection.TuneOk
        {
            public static final int INDEX = 31;

            private final int channelMax;
            private final int frameMax;
            private final int heartbeat;

            public int getChannelMax() { return channelMax; }
            public int getFrameMax() { return frameMax; }
            public int getHeartbeat() { return heartbeat; }

            public TuneOk(int channelMax, int frameMax, int heartbeat) {
                this.channelMax = channelMax;
                this.frameMax = frameMax;
                this.heartbeat = heartbeat;
            }
            public TuneOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readLong(), rdr.readShort());
            }

            public int protocolClassId() { return 10; }
            public int protocolMethodId() { return 31; }
            public String protocolMethodName() { return "connection.tune-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            TuneOk that = (TuneOk) o;
            if (channelMax != that.channelMax)
                return false;
            if (frameMax != that.frameMax)
                return false;
            if (heartbeat != that.heartbeat)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + channelMax;
            result = 31 * result + frameMax;
            result = 31 * result + heartbeat;
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(channel-max=")
                   .append(this.channelMax)
                   .append(", frame-max=")
                   .append(this.frameMax)
                   .append(", heartbeat=")
                   .append(this.heartbeat)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShort(this.channelMax);
                writer.writeLong(this.frameMax);
                writer.writeShort(this.heartbeat);
            }
        }

        public static class Open
            extends Method
            implements com.rabbitmq.client.AMQP.Connection.Open
        {
            public static final int INDEX = 40;

            private final String virtualHost;
            private final String capabilities;
            private final boolean insist;

            public String getVirtualHost() { return virtualHost; }
            public String getCapabilities() { return capabilities; }
            public boolean getInsist() { return insist; }

            public Open(String virtualHost, String capabilities, boolean insist) {
                if (capabilities == null)
                    throw new IllegalStateException("Invalid configuration: 'capabilities' must be non-null.");
                if (virtualHost == null)
                    throw new IllegalStateException("Invalid configuration: 'virtualHost' must be non-null.");
                this.virtualHost = virtualHost;
                this.capabilities = capabilities;
                this.insist = insist;
            }
            public Open(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr(), rdr.readShortstr(), rdr.readBit());
            }

            public int protocolClassId() { return 10; }
            public int protocolMethodId() { return 40; }
            public String protocolMethodName() { return "connection.open";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Open that = (Open) o;
            if (virtualHost != null ? !virtualHost.equals(that.virtualHost) : that.virtualHost != null)
                return false;
            if (capabilities != null ? !capabilities.equals(that.capabilities) : that.capabilities != null)
                return false;
            if (insist != that.insist)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (virtualHost != null ? virtualHost.hashCode() : 0);
            result = 31 * result + (capabilities != null ? capabilities.hashCode() : 0);
            result = 31 * result + (insist ? 1 : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(virtual-host=")
                   .append(this.virtualHost)
                   .append(", capabilities=")
                   .append(this.capabilities)
                   .append(", insist=")
                   .append(this.insist)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShortstr(this.virtualHost);
                writer.writeShortstr(this.capabilities);
                writer.writeBit(this.insist);
            }
        }

        public static class OpenOk
            extends Method
            implements com.rabbitmq.client.AMQP.Connection.OpenOk
        {
            public static final int INDEX = 41;

            private final String knownHosts;

            public String getKnownHosts() { return knownHosts; }

            public OpenOk(String knownHosts) {
                if (knownHosts == null)
                    throw new IllegalStateException("Invalid configuration: 'knownHosts' must be non-null.");
                this.knownHosts = knownHosts;
            }
            public OpenOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr());
            }

            public int protocolClassId() { return 10; }
            public int protocolMethodId() { return 41; }
            public String protocolMethodName() { return "connection.open-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            OpenOk that = (OpenOk) o;
            if (knownHosts != null ? !knownHosts.equals(that.knownHosts) : that.knownHosts != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (knownHosts != null ? knownHosts.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(known-hosts=")
                   .append(this.knownHosts)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShortstr(this.knownHosts);
            }
        }

        public static class Close
            extends Method
            implements com.rabbitmq.client.AMQP.Connection.Close
        {
            public static final int INDEX = 50;

            private final int replyCode;
            private final String replyText;
            private final int classId;
            private final int methodId;

            public int getReplyCode() { return replyCode; }
            public String getReplyText() { return replyText; }
            public int getClassId() { return classId; }
            public int getMethodId() { return methodId; }

            public Close(int replyCode, String replyText, int classId, int methodId) {
                if (replyText == null)
                    throw new IllegalStateException("Invalid configuration: 'replyText' must be non-null.");
                this.replyCode = replyCode;
                this.replyText = replyText;
                this.classId = classId;
                this.methodId = methodId;
            }
            public Close(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readShort(), rdr.readShort());
            }

            public int protocolClassId() { return 10; }
            public int protocolMethodId() { return 50; }
            public String protocolMethodName() { return "connection.close";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Close that = (Close) o;
            if (replyCode != that.replyCode)
                return false;
            if (replyText != null ? !replyText.equals(that.replyText) : that.replyText != null)
                return false;
            if (classId != that.classId)
                return false;
            if (methodId != that.methodId)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + replyCode;
            result = 31 * result + (replyText != null ? replyText.hashCode() : 0);
            result = 31 * result + classId;
            result = 31 * result + methodId;
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(reply-code=")
                   .append(this.replyCode)
                   .append(", reply-text=")
                   .append(this.replyText)
                   .append(", class-id=")
                   .append(this.classId)
                   .append(", method-id=")
                   .append(this.methodId)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShort(this.replyCode);
                writer.writeShortstr(this.replyText);
                writer.writeShort(this.classId);
                writer.writeShort(this.methodId);
            }
        }

        public static class CloseOk
            extends Method
            implements com.rabbitmq.client.AMQP.Connection.CloseOk
        {
            public static final int INDEX = 51;


            public CloseOk() {
            }
            public CloseOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() { return 10; }
            public int protocolMethodId() { return 51; }
            public String protocolMethodName() { return "connection.close-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
            }
        }

        public static class Blocked
            extends Method
            implements com.rabbitmq.client.AMQP.Connection.Blocked
        {
            public static final int INDEX = 60;

            private final String reason;

            public String getReason() { return reason; }

            public Blocked(String reason) {
                if (reason == null)
                    throw new IllegalStateException("Invalid configuration: 'reason' must be non-null.");
                this.reason = reason;
            }
            public Blocked(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr());
            }

            public int protocolClassId() { return 10; }
            public int protocolMethodId() { return 60; }
            public String protocolMethodName() { return "connection.blocked";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Blocked that = (Blocked) o;
            if (reason != null ? !reason.equals(that.reason) : that.reason != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (reason != null ? reason.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(reason=")
                   .append(this.reason)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShortstr(this.reason);
            }
        }

        public static class Unblocked
            extends Method
            implements com.rabbitmq.client.AMQP.Connection.Unblocked
        {
            public static final int INDEX = 61;


            public Unblocked() {
            }
            public Unblocked(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() { return 10; }
            public int protocolMethodId() { return 61; }
            public String protocolMethodName() { return "connection.unblocked";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
            }
        }

        public static class UpdateSecret
            extends Method
            implements com.rabbitmq.client.AMQP.Connection.UpdateSecret
        {
            public static final int INDEX = 70;

            private final LongString newSecret;
            private final String reason;

            public LongString getNewSecret() { return newSecret; }
            public String getReason() { return reason; }

            public UpdateSecret(LongString newSecret, String reason) {
                if (newSecret == null)
                    throw new IllegalStateException("Invalid configuration: 'newSecret' must be non-null.");
                if (reason == null)
                    throw new IllegalStateException("Invalid configuration: 'reason' must be non-null.");
                this.newSecret = newSecret;
                this.reason = reason;
            }
            public UpdateSecret(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLongstr(), rdr.readShortstr());
            }

            public int protocolClassId() { return 10; }
            public int protocolMethodId() { return 70; }
            public String protocolMethodName() { return "connection.update-secret";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            UpdateSecret that = (UpdateSecret) o;
            if (newSecret != null ? !newSecret.equals(that.newSecret) : that.newSecret != null)
                return false;
            if (reason != null ? !reason.equals(that.reason) : that.reason != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (newSecret != null ? newSecret.hashCode() : 0);
            result = 31 * result + (reason != null ? reason.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(new-secret=")
                   .append(this.newSecret)
                   .append(", reason=")
                   .append(this.reason)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeLongstr(this.newSecret);
                writer.writeShortstr(this.reason);
            }
        }

        public static class UpdateSecretOk
            extends Method
            implements com.rabbitmq.client.AMQP.Connection.UpdateSecretOk
        {
            public static final int INDEX = 71;


            public UpdateSecretOk() {
            }
            public UpdateSecretOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() { return 10; }
            public int protocolMethodId() { return 71; }
            public String protocolMethodName() { return "connection.update-secret-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
            }
        }
    }

    public static class Channel {
        public static final int INDEX = 20;

        public static class Open
            extends Method
            implements com.rabbitmq.client.AMQP.Channel.Open
        {
            public static final int INDEX = 10;

            private final String outOfBand;

            public String getOutOfBand() { return outOfBand; }

            public Open(String outOfBand) {
                if (outOfBand == null)
                    throw new IllegalStateException("Invalid configuration: 'outOfBand' must be non-null.");
                this.outOfBand = outOfBand;
            }
            public Open(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr());
            }

            public int protocolClassId() { return 20; }
            public int protocolMethodId() { return 10; }
            public String protocolMethodName() { return "channel.open";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Open that = (Open) o;
            if (outOfBand != null ? !outOfBand.equals(that.outOfBand) : that.outOfBand != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (outOfBand != null ? outOfBand.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(out-of-band=")
                   .append(this.outOfBand)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShortstr(this.outOfBand);
            }
        }

        public static class OpenOk
            extends Method
            implements com.rabbitmq.client.AMQP.Channel.OpenOk
        {
            public static final int INDEX = 11;

            private final LongString channelId;

            public LongString getChannelId() { return channelId; }

            public OpenOk(LongString channelId) {
                if (channelId == null)
                    throw new IllegalStateException("Invalid configuration: 'channelId' must be non-null.");
                this.channelId = channelId;
            }
            public OpenOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLongstr());
            }

            public int protocolClassId() { return 20; }
            public int protocolMethodId() { return 11; }
            public String protocolMethodName() { return "channel.open-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            OpenOk that = (OpenOk) o;
            if (channelId != null ? !channelId.equals(that.channelId) : that.channelId != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (channelId != null ? channelId.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(channel-id=")
                   .append(this.channelId)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeLongstr(this.channelId);
            }
        }

        public static class Flow
            extends Method
            implements com.rabbitmq.client.AMQP.Channel.Flow
        {
            public static final int INDEX = 20;

            private final boolean active;

            public boolean getActive() { return active; }

            public Flow(boolean active) {
                this.active = active;
            }
            public Flow(MethodArgumentReader rdr) throws IOException {
                this(rdr.readBit());
            }

            public int protocolClassId() { return 20; }
            public int protocolMethodId() { return 20; }
            public String protocolMethodName() { return "channel.flow";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Flow that = (Flow) o;
            if (active != that.active)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (active ? 1 : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(active=")
                   .append(this.active)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeBit(this.active);
            }
        }

        public static class FlowOk
            extends Method
            implements com.rabbitmq.client.AMQP.Channel.FlowOk
        {
            public static final int INDEX = 21;

            private final boolean active;

            public boolean getActive() { return active; }

            public FlowOk(boolean active) {
                this.active = active;
            }
            public FlowOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readBit());
            }

            public int protocolClassId() { return 20; }
            public int protocolMethodId() { return 21; }
            public String protocolMethodName() { return "channel.flow-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            FlowOk that = (FlowOk) o;
            if (active != that.active)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (active ? 1 : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(active=")
                   .append(this.active)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeBit(this.active);
            }
        }

        public static class Close
            extends Method
            implements com.rabbitmq.client.AMQP.Channel.Close
        {
            public static final int INDEX = 40;

            private final int replyCode;
            private final String replyText;
            private final int classId;
            private final int methodId;

            public int getReplyCode() { return replyCode; }
            public String getReplyText() { return replyText; }
            public int getClassId() { return classId; }
            public int getMethodId() { return methodId; }

            public Close(int replyCode, String replyText, int classId, int methodId) {
                if (replyText == null)
                    throw new IllegalStateException("Invalid configuration: 'replyText' must be non-null.");
                this.replyCode = replyCode;
                this.replyText = replyText;
                this.classId = classId;
                this.methodId = methodId;
            }
            public Close(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readShort(), rdr.readShort());
            }

            public int protocolClassId() { return 20; }
            public int protocolMethodId() { return 40; }
            public String protocolMethodName() { return "channel.close";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Close that = (Close) o;
            if (replyCode != that.replyCode)
                return false;
            if (replyText != null ? !replyText.equals(that.replyText) : that.replyText != null)
                return false;
            if (classId != that.classId)
                return false;
            if (methodId != that.methodId)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + replyCode;
            result = 31 * result + (replyText != null ? replyText.hashCode() : 0);
            result = 31 * result + classId;
            result = 31 * result + methodId;
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(reply-code=")
                   .append(this.replyCode)
                   .append(", reply-text=")
                   .append(this.replyText)
                   .append(", class-id=")
                   .append(this.classId)
                   .append(", method-id=")
                   .append(this.methodId)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShort(this.replyCode);
                writer.writeShortstr(this.replyText);
                writer.writeShort(this.classId);
                writer.writeShort(this.methodId);
            }
        }

        public static class CloseOk
            extends Method
            implements com.rabbitmq.client.AMQP.Channel.CloseOk
        {
            public static final int INDEX = 41;


            public CloseOk() {
            }
            public CloseOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() { return 20; }
            public int protocolMethodId() { return 41; }
            public String protocolMethodName() { return "channel.close-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
            }
        }
    }

    public static class Access {
        public static final int INDEX = 30;

        public static class Request
            extends Method
            implements com.rabbitmq.client.AMQP.Access.Request
        {
            public static final int INDEX = 10;

            private final String realm;
            private final boolean exclusive;
            private final boolean passive;
            private final boolean active;
            private final boolean write;
            private final boolean read;

            public String getRealm() { return realm; }
            public boolean getExclusive() { return exclusive; }
            public boolean getPassive() { return passive; }
            public boolean getActive() { return active; }
            public boolean getWrite() { return write; }
            public boolean getRead() { return read; }

            public Request(String realm, boolean exclusive, boolean passive, boolean active, boolean write, boolean read) {
                if (realm == null)
                    throw new IllegalStateException("Invalid configuration: 'realm' must be non-null.");
                this.realm = realm;
                this.exclusive = exclusive;
                this.passive = passive;
                this.active = active;
                this.write = write;
                this.read = read;
            }
            public Request(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr(), rdr.readBit(), rdr.readBit(), rdr.readBit(), rdr.readBit(), rdr.readBit());
            }

            public int protocolClassId() { return 30; }
            public int protocolMethodId() { return 10; }
            public String protocolMethodName() { return "access.request";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Request that = (Request) o;
            if (realm != null ? !realm.equals(that.realm) : that.realm != null)
                return false;
            if (exclusive != that.exclusive)
                return false;
            if (passive != that.passive)
                return false;
            if (active != that.active)
                return false;
            if (write != that.write)
                return false;
            if (read != that.read)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (realm != null ? realm.hashCode() : 0);
            result = 31 * result + (exclusive ? 1 : 0);
            result = 31 * result + (passive ? 1 : 0);
            result = 31 * result + (active ? 1 : 0);
            result = 31 * result + (write ? 1 : 0);
            result = 31 * result + (read ? 1 : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(realm=")
                   .append(this.realm)
                   .append(", exclusive=")
                   .append(this.exclusive)
                   .append(", passive=")
                   .append(this.passive)
                   .append(", active=")
                   .append(this.active)
                   .append(", write=")
                   .append(this.write)
                   .append(", read=")
                   .append(this.read)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShortstr(this.realm);
                writer.writeBit(this.exclusive);
                writer.writeBit(this.passive);
                writer.writeBit(this.active);
                writer.writeBit(this.write);
                writer.writeBit(this.read);
            }
        }

        public static class RequestOk
            extends Method
            implements com.rabbitmq.client.AMQP.Access.RequestOk
        {
            public static final int INDEX = 11;

            private final int ticket;

            public int getTicket() { return ticket; }

            public RequestOk(int ticket) {
                this.ticket = ticket;
            }
            public RequestOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort());
            }

            public int protocolClassId() { return 30; }
            public int protocolMethodId() { return 11; }
            public String protocolMethodName() { return "access.request-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            RequestOk that = (RequestOk) o;
            if (ticket != that.ticket)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + ticket;
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=")
                   .append(this.ticket)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShort(this.ticket);
            }
        }
    }

    public static class Exchange {
        public static final int INDEX = 40;

        public static class Declare
            extends Method
            implements com.rabbitmq.client.AMQP.Exchange.Declare
        {
            public static final int INDEX = 10;

            private final int ticket;
            private final String exchange;
            private final String type;
            private final boolean passive;
            private final boolean durable;
            private final boolean autoDelete;
            private final boolean internal;
            private final boolean nowait;
            private final Map<String,Object> arguments;

            public int getTicket() { return ticket; }
            public String getExchange() { return exchange; }
            public String getType() { return type; }
            public boolean getPassive() { return passive; }
            public boolean getDurable() { return durable; }
            public boolean getAutoDelete() { return autoDelete; }
            public boolean getInternal() { return internal; }
            public boolean getNowait() { return nowait; }
            public Map<String,Object> getArguments() { return arguments; }

            public Declare(int ticket, String exchange, String type, boolean passive, boolean durable, boolean autoDelete, boolean internal, boolean nowait, Map<String,Object> arguments) {
                if (exchange == null)
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                if (type == null)
                    throw new IllegalStateException("Invalid configuration: 'type' must be non-null.");
                this.ticket = ticket;
                this.exchange = exchange;
                this.type = type;
                this.passive = passive;
                this.durable = durable;
                this.autoDelete = autoDelete;
                this.internal = internal;
                this.nowait = nowait;
                this.arguments = arguments==null ? null : Collections.unmodifiableMap(new HashMap<String,Object>(arguments));
            }
            public Declare(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readShortstr(), rdr.readBit(), rdr.readBit(), rdr.readBit(), rdr.readBit(), rdr.readBit(), rdr.readTable());
            }

            public int protocolClassId() { return 40; }
            public int protocolMethodId() { return 10; }
            public String protocolMethodName() { return "exchange.declare";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Declare that = (Declare) o;
            if (ticket != that.ticket)
                return false;
            if (exchange != null ? !exchange.equals(that.exchange) : that.exchange != null)
                return false;
            if (type != null ? !type.equals(that.type) : that.type != null)
                return false;
            if (passive != that.passive)
                return false;
            if (durable != that.durable)
                return false;
            if (autoDelete != that.autoDelete)
                return false;
            if (internal != that.internal)
                return false;
            if (nowait != that.nowait)
                return false;
            if (arguments != null ? !arguments.equals(that.arguments) : that.arguments != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + ticket;
            result = 31 * result + (exchange != null ? exchange.hashCode() : 0);
            result = 31 * result + (type != null ? type.hashCode() : 0);
            result = 31 * result + (passive ? 1 : 0);
            result = 31 * result + (durable ? 1 : 0);
            result = 31 * result + (autoDelete ? 1 : 0);
            result = 31 * result + (internal ? 1 : 0);
            result = 31 * result + (nowait ? 1 : 0);
            result = 31 * result + (arguments != null ? arguments.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=")
                   .append(this.ticket)
                   .append(", exchange=")
                   .append(this.exchange)
                   .append(", type=")
                   .append(this.type)
                   .append(", passive=")
                   .append(this.passive)
                   .append(", durable=")
                   .append(this.durable)
                   .append(", auto-delete=")
                   .append(this.autoDelete)
                   .append(", internal=")
                   .append(this.internal)
                   .append(", nowait=")
                   .append(this.nowait)
                   .append(", arguments=")
                   .append(this.arguments)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.type);
                writer.writeBit(this.passive);
                writer.writeBit(this.durable);
                writer.writeBit(this.autoDelete);
                writer.writeBit(this.internal);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }

        public static class DeclareOk
            extends Method
            implements com.rabbitmq.client.AMQP.Exchange.DeclareOk
        {
            public static final int INDEX = 11;


            public DeclareOk() {
            }
            public DeclareOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() { return 40; }
            public int protocolMethodId() { return 11; }
            public String protocolMethodName() { return "exchange.declare-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
            }
        }

        public static class Delete
            extends Method
            implements com.rabbitmq.client.AMQP.Exchange.Delete
        {
            public static final int INDEX = 20;

            private final int ticket;
            private final String exchange;
            private final boolean ifUnused;
            private final boolean nowait;

            public int getTicket() { return ticket; }
            public String getExchange() { return exchange; }
            public boolean getIfUnused() { return ifUnused; }
            public boolean getNowait() { return nowait; }

            public Delete(int ticket, String exchange, boolean ifUnused, boolean nowait) {
                if (exchange == null)
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                this.ticket = ticket;
                this.exchange = exchange;
                this.ifUnused = ifUnused;
                this.nowait = nowait;
            }
            public Delete(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readBit(), rdr.readBit());
            }

            public int protocolClassId() { return 40; }
            public int protocolMethodId() { return 20; }
            public String protocolMethodName() { return "exchange.delete";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Delete that = (Delete) o;
            if (ticket != that.ticket)
                return false;
            if (exchange != null ? !exchange.equals(that.exchange) : that.exchange != null)
                return false;
            if (ifUnused != that.ifUnused)
                return false;
            if (nowait != that.nowait)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + ticket;
            result = 31 * result + (exchange != null ? exchange.hashCode() : 0);
            result = 31 * result + (ifUnused ? 1 : 0);
            result = 31 * result + (nowait ? 1 : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=")
                   .append(this.ticket)
                   .append(", exchange=")
                   .append(this.exchange)
                   .append(", if-unused=")
                   .append(this.ifUnused)
                   .append(", nowait=")
                   .append(this.nowait)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.exchange);
                writer.writeBit(this.ifUnused);
                writer.writeBit(this.nowait);
            }
        }

        public static class DeleteOk
            extends Method
            implements com.rabbitmq.client.AMQP.Exchange.DeleteOk
        {
            public static final int INDEX = 21;


            public DeleteOk() {
            }
            public DeleteOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() { return 40; }
            public int protocolMethodId() { return 21; }
            public String protocolMethodName() { return "exchange.delete-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
            }
        }

        public static class Bind
            extends Method
            implements com.rabbitmq.client.AMQP.Exchange.Bind
        {
            public static final int INDEX = 30;

            private final int ticket;
            private final String destination;
            private final String source;
            private final String routingKey;
            private final boolean nowait;
            private final Map<String,Object> arguments;

            public int getTicket() { return ticket; }
            public String getDestination() { return destination; }
            public String getSource() { return source; }
            public String getRoutingKey() { return routingKey; }
            public boolean getNowait() { return nowait; }
            public Map<String,Object> getArguments() { return arguments; }

            public Bind(int ticket, String destination, String source, String routingKey, boolean nowait, Map<String,Object> arguments) {
                if (destination == null)
                    throw new IllegalStateException("Invalid configuration: 'destination' must be non-null.");
                if (routingKey == null)
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                if (source == null)
                    throw new IllegalStateException("Invalid configuration: 'source' must be non-null.");
                this.ticket = ticket;
                this.destination = destination;
                this.source = source;
                this.routingKey = routingKey;
                this.nowait = nowait;
                this.arguments = arguments==null ? null : Collections.unmodifiableMap(new HashMap<String,Object>(arguments));
            }
            public Bind(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readShortstr(), rdr.readShortstr(), rdr.readBit(), rdr.readTable());
            }

            public int protocolClassId() { return 40; }
            public int protocolMethodId() { return 30; }
            public String protocolMethodName() { return "exchange.bind";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Bind that = (Bind) o;
            if (ticket != that.ticket)
                return false;
            if (destination != null ? !destination.equals(that.destination) : that.destination != null)
                return false;
            if (source != null ? !source.equals(that.source) : that.source != null)
                return false;
            if (routingKey != null ? !routingKey.equals(that.routingKey) : that.routingKey != null)
                return false;
            if (nowait != that.nowait)
                return false;
            if (arguments != null ? !arguments.equals(that.arguments) : that.arguments != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + ticket;
            result = 31 * result + (destination != null ? destination.hashCode() : 0);
            result = 31 * result + (source != null ? source.hashCode() : 0);
            result = 31 * result + (routingKey != null ? routingKey.hashCode() : 0);
            result = 31 * result + (nowait ? 1 : 0);
            result = 31 * result + (arguments != null ? arguments.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=")
                   .append(this.ticket)
                   .append(", destination=")
                   .append(this.destination)
                   .append(", source=")
                   .append(this.source)
                   .append(", routing-key=")
                   .append(this.routingKey)
                   .append(", nowait=")
                   .append(this.nowait)
                   .append(", arguments=")
                   .append(this.arguments)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.destination);
                writer.writeShortstr(this.source);
                writer.writeShortstr(this.routingKey);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }

        public static class BindOk
            extends Method
            implements com.rabbitmq.client.AMQP.Exchange.BindOk
        {
            public static final int INDEX = 31;


            public BindOk() {
            }
            public BindOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() { return 40; }
            public int protocolMethodId() { return 31; }
            public String protocolMethodName() { return "exchange.bind-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
            }
        }

        public static class Unbind
            extends Method
            implements com.rabbitmq.client.AMQP.Exchange.Unbind
        {
            public static final int INDEX = 40;

            private final int ticket;
            private final String destination;
            private final String source;
            private final String routingKey;
            private final boolean nowait;
            private final Map<String,Object> arguments;

            public int getTicket() { return ticket; }
            public String getDestination() { return destination; }
            public String getSource() { return source; }
            public String getRoutingKey() { return routingKey; }
            public boolean getNowait() { return nowait; }
            public Map<String,Object> getArguments() { return arguments; }

            public Unbind(int ticket, String destination, String source, String routingKey, boolean nowait, Map<String,Object> arguments) {
                if (destination == null)
                    throw new IllegalStateException("Invalid configuration: 'destination' must be non-null.");
                if (routingKey == null)
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                if (source == null)
                    throw new IllegalStateException("Invalid configuration: 'source' must be non-null.");
                this.ticket = ticket;
                this.destination = destination;
                this.source = source;
                this.routingKey = routingKey;
                this.nowait = nowait;
                this.arguments = arguments==null ? null : Collections.unmodifiableMap(new HashMap<String,Object>(arguments));
            }
            public Unbind(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readShortstr(), rdr.readShortstr(), rdr.readBit(), rdr.readTable());
            }

            public int protocolClassId() { return 40; }
            public int protocolMethodId() { return 40; }
            public String protocolMethodName() { return "exchange.unbind";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Unbind that = (Unbind) o;
            if (ticket != that.ticket)
                return false;
            if (destination != null ? !destination.equals(that.destination) : that.destination != null)
                return false;
            if (source != null ? !source.equals(that.source) : that.source != null)
                return false;
            if (routingKey != null ? !routingKey.equals(that.routingKey) : that.routingKey != null)
                return false;
            if (nowait != that.nowait)
                return false;
            if (arguments != null ? !arguments.equals(that.arguments) : that.arguments != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + ticket;
            result = 31 * result + (destination != null ? destination.hashCode() : 0);
            result = 31 * result + (source != null ? source.hashCode() : 0);
            result = 31 * result + (routingKey != null ? routingKey.hashCode() : 0);
            result = 31 * result + (nowait ? 1 : 0);
            result = 31 * result + (arguments != null ? arguments.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=")
                   .append(this.ticket)
                   .append(", destination=")
                   .append(this.destination)
                   .append(", source=")
                   .append(this.source)
                   .append(", routing-key=")
                   .append(this.routingKey)
                   .append(", nowait=")
                   .append(this.nowait)
                   .append(", arguments=")
                   .append(this.arguments)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.destination);
                writer.writeShortstr(this.source);
                writer.writeShortstr(this.routingKey);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }

        public static class UnbindOk
            extends Method
            implements com.rabbitmq.client.AMQP.Exchange.UnbindOk
        {
            public static final int INDEX = 51;


            public UnbindOk() {
            }
            public UnbindOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() { return 40; }
            public int protocolMethodId() { return 51; }
            public String protocolMethodName() { return "exchange.unbind-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
            }
        }
    }

    public static class Queue {
        public static final int INDEX = 50;

        public static class Declare
            extends Method
            implements com.rabbitmq.client.AMQP.Queue.Declare
        {
            public static final int INDEX = 10;

            private final int ticket;
            private final String queue;
            private final boolean passive;
            private final boolean durable;
            private final boolean exclusive;
            private final boolean autoDelete;
            private final boolean nowait;
            private final Map<String,Object> arguments;

            public int getTicket() { return ticket; }
            public String getQueue() { return queue; }
            public boolean getPassive() { return passive; }
            public boolean getDurable() { return durable; }
            public boolean getExclusive() { return exclusive; }
            public boolean getAutoDelete() { return autoDelete; }
            public boolean getNowait() { return nowait; }
            public Map<String,Object> getArguments() { return arguments; }

            public Declare(int ticket, String queue, boolean passive, boolean durable, boolean exclusive, boolean autoDelete, boolean nowait, Map<String,Object> arguments) {
                if (queue == null)
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                this.ticket = ticket;
                this.queue = queue;
                this.passive = passive;
                this.durable = durable;
                this.exclusive = exclusive;
                this.autoDelete = autoDelete;
                this.nowait = nowait;
                this.arguments = arguments==null ? null : Collections.unmodifiableMap(new HashMap<String,Object>(arguments));
            }
            public Declare(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readBit(), rdr.readBit(), rdr.readBit(), rdr.readBit(), rdr.readBit(), rdr.readTable());
            }

            public int protocolClassId() { return 50; }
            public int protocolMethodId() { return 10; }
            public String protocolMethodName() { return "queue.declare";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Declare that = (Declare) o;
            if (ticket != that.ticket)
                return false;
            if (queue != null ? !queue.equals(that.queue) : that.queue != null)
                return false;
            if (passive != that.passive)
                return false;
            if (durable != that.durable)
                return false;
            if (exclusive != that.exclusive)
                return false;
            if (autoDelete != that.autoDelete)
                return false;
            if (nowait != that.nowait)
                return false;
            if (arguments != null ? !arguments.equals(that.arguments) : that.arguments != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + ticket;
            result = 31 * result + (queue != null ? queue.hashCode() : 0);
            result = 31 * result + (passive ? 1 : 0);
            result = 31 * result + (durable ? 1 : 0);
            result = 31 * result + (exclusive ? 1 : 0);
            result = 31 * result + (autoDelete ? 1 : 0);
            result = 31 * result + (nowait ? 1 : 0);
            result = 31 * result + (arguments != null ? arguments.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=")
                   .append(this.ticket)
                   .append(", queue=")
                   .append(this.queue)
                   .append(", passive=")
                   .append(this.passive)
                   .append(", durable=")
                   .append(this.durable)
                   .append(", exclusive=")
                   .append(this.exclusive)
                   .append(", auto-delete=")
                   .append(this.autoDelete)
                   .append(", nowait=")
                   .append(this.nowait)
                   .append(", arguments=")
                   .append(this.arguments)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeBit(this.passive);
                writer.writeBit(this.durable);
                writer.writeBit(this.exclusive);
                writer.writeBit(this.autoDelete);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }

        public static class DeclareOk
            extends Method
            implements com.rabbitmq.client.AMQP.Queue.DeclareOk
        {
            public static final int INDEX = 11;

            private final String queue;
            private final int messageCount;
            private final int consumerCount;

            public String getQueue() { return queue; }
            public int getMessageCount() { return messageCount; }
            public int getConsumerCount() { return consumerCount; }

            public DeclareOk(String queue, int messageCount, int consumerCount) {
                if (queue == null)
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                this.queue = queue;
                this.messageCount = messageCount;
                this.consumerCount = consumerCount;
            }
            public DeclareOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr(), rdr.readLong(), rdr.readLong());
            }

            public int protocolClassId() { return 50; }
            public int protocolMethodId() { return 11; }
            public String protocolMethodName() { return "queue.declare-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            DeclareOk that = (DeclareOk) o;
            if (queue != null ? !queue.equals(that.queue) : that.queue != null)
                return false;
            if (messageCount != that.messageCount)
                return false;
            if (consumerCount != that.consumerCount)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (queue != null ? queue.hashCode() : 0);
            result = 31 * result + messageCount;
            result = 31 * result + consumerCount;
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(queue=")
                   .append(this.queue)
                   .append(", message-count=")
                   .append(this.messageCount)
                   .append(", consumer-count=")
                   .append(this.consumerCount)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShortstr(this.queue);
                writer.writeLong(this.messageCount);
                writer.writeLong(this.consumerCount);
            }
        }

        public static class Bind
            extends Method
            implements com.rabbitmq.client.AMQP.Queue.Bind
        {
            public static final int INDEX = 20;

            private final int ticket;
            private final String queue;
            private final String exchange;
            private final String routingKey;
            private final boolean nowait;
            private final Map<String,Object> arguments;

            public int getTicket() { return ticket; }
            public String getQueue() { return queue; }
            public String getExchange() { return exchange; }
            public String getRoutingKey() { return routingKey; }
            public boolean getNowait() { return nowait; }
            public Map<String,Object> getArguments() { return arguments; }

            public Bind(int ticket, String queue, String exchange, String routingKey, boolean nowait, Map<String,Object> arguments) {
                if (exchange == null)
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                if (queue == null)
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                if (routingKey == null)
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                this.ticket = ticket;
                this.queue = queue;
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.nowait = nowait;
                this.arguments = arguments==null ? null : Collections.unmodifiableMap(new HashMap<String,Object>(arguments));
            }
            public Bind(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readShortstr(), rdr.readShortstr(), rdr.readBit(), rdr.readTable());
            }

            public int protocolClassId() { return 50; }
            public int protocolMethodId() { return 20; }
            public String protocolMethodName() { return "queue.bind";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Bind that = (Bind) o;
            if (ticket != that.ticket)
                return false;
            if (queue != null ? !queue.equals(that.queue) : that.queue != null)
                return false;
            if (exchange != null ? !exchange.equals(that.exchange) : that.exchange != null)
                return false;
            if (routingKey != null ? !routingKey.equals(that.routingKey) : that.routingKey != null)
                return false;
            if (nowait != that.nowait)
                return false;
            if (arguments != null ? !arguments.equals(that.arguments) : that.arguments != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + ticket;
            result = 31 * result + (queue != null ? queue.hashCode() : 0);
            result = 31 * result + (exchange != null ? exchange.hashCode() : 0);
            result = 31 * result + (routingKey != null ? routingKey.hashCode() : 0);
            result = 31 * result + (nowait ? 1 : 0);
            result = 31 * result + (arguments != null ? arguments.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=")
                   .append(this.ticket)
                   .append(", queue=")
                   .append(this.queue)
                   .append(", exchange=")
                   .append(this.exchange)
                   .append(", routing-key=")
                   .append(this.routingKey)
                   .append(", nowait=")
                   .append(this.nowait)
                   .append(", arguments=")
                   .append(this.arguments)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }

        public static class BindOk
            extends Method
            implements com.rabbitmq.client.AMQP.Queue.BindOk
        {
            public static final int INDEX = 21;


            public BindOk() {
            }
            public BindOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() { return 50; }
            public int protocolMethodId() { return 21; }
            public String protocolMethodName() { return "queue.bind-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
            }
        }

        public static class Purge
            extends Method
            implements com.rabbitmq.client.AMQP.Queue.Purge
        {
            public static final int INDEX = 30;

            private final int ticket;
            private final String queue;
            private final boolean nowait;

            public int getTicket() { return ticket; }
            public String getQueue() { return queue; }
            public boolean getNowait() { return nowait; }

            public Purge(int ticket, String queue, boolean nowait) {
                if (queue == null)
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                this.ticket = ticket;
                this.queue = queue;
                this.nowait = nowait;
            }
            public Purge(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readBit());
            }

            public int protocolClassId() { return 50; }
            public int protocolMethodId() { return 30; }
            public String protocolMethodName() { return "queue.purge";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Purge that = (Purge) o;
            if (ticket != that.ticket)
                return false;
            if (queue != null ? !queue.equals(that.queue) : that.queue != null)
                return false;
            if (nowait != that.nowait)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + ticket;
            result = 31 * result + (queue != null ? queue.hashCode() : 0);
            result = 31 * result + (nowait ? 1 : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=")
                   .append(this.ticket)
                   .append(", queue=")
                   .append(this.queue)
                   .append(", nowait=")
                   .append(this.nowait)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeBit(this.nowait);
            }
        }

        public static class PurgeOk
            extends Method
            implements com.rabbitmq.client.AMQP.Queue.PurgeOk
        {
            public static final int INDEX = 31;

            private final int messageCount;

            public int getMessageCount() { return messageCount; }

            public PurgeOk(int messageCount) {
                this.messageCount = messageCount;
            }
            public PurgeOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLong());
            }

            public int protocolClassId() { return 50; }
            public int protocolMethodId() { return 31; }
            public String protocolMethodName() { return "queue.purge-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            PurgeOk that = (PurgeOk) o;
            if (messageCount != that.messageCount)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + messageCount;
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(message-count=")
                   .append(this.messageCount)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeLong(this.messageCount);
            }
        }

        public static class Delete
            extends Method
            implements com.rabbitmq.client.AMQP.Queue.Delete
        {
            public static final int INDEX = 40;

            private final int ticket;
            private final String queue;
            private final boolean ifUnused;
            private final boolean ifEmpty;
            private final boolean nowait;

            public int getTicket() { return ticket; }
            public String getQueue() { return queue; }
            public boolean getIfUnused() { return ifUnused; }
            public boolean getIfEmpty() { return ifEmpty; }
            public boolean getNowait() { return nowait; }

            public Delete(int ticket, String queue, boolean ifUnused, boolean ifEmpty, boolean nowait) {
                if (queue == null)
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                this.ticket = ticket;
                this.queue = queue;
                this.ifUnused = ifUnused;
                this.ifEmpty = ifEmpty;
                this.nowait = nowait;
            }
            public Delete(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readBit(), rdr.readBit(), rdr.readBit());
            }

            public int protocolClassId() { return 50; }
            public int protocolMethodId() { return 40; }
            public String protocolMethodName() { return "queue.delete";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Delete that = (Delete) o;
            if (ticket != that.ticket)
                return false;
            if (queue != null ? !queue.equals(that.queue) : that.queue != null)
                return false;
            if (ifUnused != that.ifUnused)
                return false;
            if (ifEmpty != that.ifEmpty)
                return false;
            if (nowait != that.nowait)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + ticket;
            result = 31 * result + (queue != null ? queue.hashCode() : 0);
            result = 31 * result + (ifUnused ? 1 : 0);
            result = 31 * result + (ifEmpty ? 1 : 0);
            result = 31 * result + (nowait ? 1 : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=")
                   .append(this.ticket)
                   .append(", queue=")
                   .append(this.queue)
                   .append(", if-unused=")
                   .append(this.ifUnused)
                   .append(", if-empty=")
                   .append(this.ifEmpty)
                   .append(", nowait=")
                   .append(this.nowait)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeBit(this.ifUnused);
                writer.writeBit(this.ifEmpty);
                writer.writeBit(this.nowait);
            }
        }

        public static class DeleteOk
            extends Method
            implements com.rabbitmq.client.AMQP.Queue.DeleteOk
        {
            public static final int INDEX = 41;

            private final int messageCount;

            public int getMessageCount() { return messageCount; }

            public DeleteOk(int messageCount) {
                this.messageCount = messageCount;
            }
            public DeleteOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLong());
            }

            public int protocolClassId() { return 50; }
            public int protocolMethodId() { return 41; }
            public String protocolMethodName() { return "queue.delete-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            DeleteOk that = (DeleteOk) o;
            if (messageCount != that.messageCount)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + messageCount;
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(message-count=")
                   .append(this.messageCount)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeLong(this.messageCount);
            }
        }

        public static class Unbind
            extends Method
            implements com.rabbitmq.client.AMQP.Queue.Unbind
        {
            public static final int INDEX = 50;

            private final int ticket;
            private final String queue;
            private final String exchange;
            private final String routingKey;
            private final Map<String,Object> arguments;

            public int getTicket() { return ticket; }
            public String getQueue() { return queue; }
            public String getExchange() { return exchange; }
            public String getRoutingKey() { return routingKey; }
            public Map<String,Object> getArguments() { return arguments; }

            public Unbind(int ticket, String queue, String exchange, String routingKey, Map<String,Object> arguments) {
                if (exchange == null)
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                if (queue == null)
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                if (routingKey == null)
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                this.ticket = ticket;
                this.queue = queue;
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.arguments = arguments==null ? null : Collections.unmodifiableMap(new HashMap<String,Object>(arguments));
            }
            public Unbind(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readShortstr(), rdr.readShortstr(), rdr.readTable());
            }

            public int protocolClassId() { return 50; }
            public int protocolMethodId() { return 50; }
            public String protocolMethodName() { return "queue.unbind";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Unbind that = (Unbind) o;
            if (ticket != that.ticket)
                return false;
            if (queue != null ? !queue.equals(that.queue) : that.queue != null)
                return false;
            if (exchange != null ? !exchange.equals(that.exchange) : that.exchange != null)
                return false;
            if (routingKey != null ? !routingKey.equals(that.routingKey) : that.routingKey != null)
                return false;
            if (arguments != null ? !arguments.equals(that.arguments) : that.arguments != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + ticket;
            result = 31 * result + (queue != null ? queue.hashCode() : 0);
            result = 31 * result + (exchange != null ? exchange.hashCode() : 0);
            result = 31 * result + (routingKey != null ? routingKey.hashCode() : 0);
            result = 31 * result + (arguments != null ? arguments.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=")
                   .append(this.ticket)
                   .append(", queue=")
                   .append(this.queue)
                   .append(", exchange=")
                   .append(this.exchange)
                   .append(", routing-key=")
                   .append(this.routingKey)
                   .append(", arguments=")
                   .append(this.arguments)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
                writer.writeTable(this.arguments);
            }
        }

        public static class UnbindOk
            extends Method
            implements com.rabbitmq.client.AMQP.Queue.UnbindOk
        {
            public static final int INDEX = 51;


            public UnbindOk() {
            }
            public UnbindOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() { return 50; }
            public int protocolMethodId() { return 51; }
            public String protocolMethodName() { return "queue.unbind-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
            }
        }
    }

    public static class Basic {
        public static final int INDEX = 60;

        public static class Qos
            extends Method
            implements com.rabbitmq.client.AMQP.Basic.Qos
        {
            public static final int INDEX = 10;

            private final int prefetchSize;
            private final int prefetchCount;
            private final boolean global;

            public int getPrefetchSize() { return prefetchSize; }
            public int getPrefetchCount() { return prefetchCount; }
            public boolean getGlobal() { return global; }

            public Qos(int prefetchSize, int prefetchCount, boolean global) {
                this.prefetchSize = prefetchSize;
                this.prefetchCount = prefetchCount;
                this.global = global;
            }
            public Qos(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLong(), rdr.readShort(), rdr.readBit());
            }

            public int protocolClassId() { return 60; }
            public int protocolMethodId() { return 10; }
            public String protocolMethodName() { return "basic.qos";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Qos that = (Qos) o;
            if (prefetchSize != that.prefetchSize)
                return false;
            if (prefetchCount != that.prefetchCount)
                return false;
            if (global != that.global)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + prefetchSize;
            result = 31 * result + prefetchCount;
            result = 31 * result + (global ? 1 : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(prefetch-size=")
                   .append(this.prefetchSize)
                   .append(", prefetch-count=")
                   .append(this.prefetchCount)
                   .append(", global=")
                   .append(this.global)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeLong(this.prefetchSize);
                writer.writeShort(this.prefetchCount);
                writer.writeBit(this.global);
            }
        }

        public static class QosOk
            extends Method
            implements com.rabbitmq.client.AMQP.Basic.QosOk
        {
            public static final int INDEX = 11;


            public QosOk() {
            }
            public QosOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() { return 60; }
            public int protocolMethodId() { return 11; }
            public String protocolMethodName() { return "basic.qos-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
            }
        }

        public static class Consume
            extends Method
            implements com.rabbitmq.client.AMQP.Basic.Consume
        {
            public static final int INDEX = 20;

            private final int ticket;
            private final String queue;
            private final String consumerTag;
            private final boolean noLocal;
            private final boolean noAck;
            private final boolean exclusive;
            private final boolean nowait;
            private final Map<String,Object> arguments;

            public int getTicket() { return ticket; }
            public String getQueue() { return queue; }
            public String getConsumerTag() { return consumerTag; }
            public boolean getNoLocal() { return noLocal; }
            public boolean getNoAck() { return noAck; }
            public boolean getExclusive() { return exclusive; }
            public boolean getNowait() { return nowait; }
            public Map<String,Object> getArguments() { return arguments; }

            public Consume(int ticket, String queue, String consumerTag, boolean noLocal, boolean noAck, boolean exclusive, boolean nowait, Map<String,Object> arguments) {
                if (consumerTag == null)
                    throw new IllegalStateException("Invalid configuration: 'consumerTag' must be non-null.");
                if (queue == null)
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                this.ticket = ticket;
                this.queue = queue;
                this.consumerTag = consumerTag;
                this.noLocal = noLocal;
                this.noAck = noAck;
                this.exclusive = exclusive;
                this.nowait = nowait;
                this.arguments = arguments==null ? null : Collections.unmodifiableMap(new HashMap<String,Object>(arguments));
            }
            public Consume(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readShortstr(), rdr.readBit(), rdr.readBit(), rdr.readBit(), rdr.readBit(), rdr.readTable());
            }

            public int protocolClassId() { return 60; }
            public int protocolMethodId() { return 20; }
            public String protocolMethodName() { return "basic.consume";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Consume that = (Consume) o;
            if (ticket != that.ticket)
                return false;
            if (queue != null ? !queue.equals(that.queue) : that.queue != null)
                return false;
            if (consumerTag != null ? !consumerTag.equals(that.consumerTag) : that.consumerTag != null)
                return false;
            if (noLocal != that.noLocal)
                return false;
            if (noAck != that.noAck)
                return false;
            if (exclusive != that.exclusive)
                return false;
            if (nowait != that.nowait)
                return false;
            if (arguments != null ? !arguments.equals(that.arguments) : that.arguments != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + ticket;
            result = 31 * result + (queue != null ? queue.hashCode() : 0);
            result = 31 * result + (consumerTag != null ? consumerTag.hashCode() : 0);
            result = 31 * result + (noLocal ? 1 : 0);
            result = 31 * result + (noAck ? 1 : 0);
            result = 31 * result + (exclusive ? 1 : 0);
            result = 31 * result + (nowait ? 1 : 0);
            result = 31 * result + (arguments != null ? arguments.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=")
                   .append(this.ticket)
                   .append(", queue=")
                   .append(this.queue)
                   .append(", consumer-tag=")
                   .append(this.consumerTag)
                   .append(", no-local=")
                   .append(this.noLocal)
                   .append(", no-ack=")
                   .append(this.noAck)
                   .append(", exclusive=")
                   .append(this.exclusive)
                   .append(", nowait=")
                   .append(this.nowait)
                   .append(", arguments=")
                   .append(this.arguments)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeShortstr(this.consumerTag);
                writer.writeBit(this.noLocal);
                writer.writeBit(this.noAck);
                writer.writeBit(this.exclusive);
                writer.writeBit(this.nowait);
                writer.writeTable(this.arguments);
            }
        }

        public static class ConsumeOk
            extends Method
            implements com.rabbitmq.client.AMQP.Basic.ConsumeOk
        {
            public static final int INDEX = 21;

            private final String consumerTag;

            public String getConsumerTag() { return consumerTag; }

            public ConsumeOk(String consumerTag) {
                if (consumerTag == null)
                    throw new IllegalStateException("Invalid configuration: 'consumerTag' must be non-null.");
                this.consumerTag = consumerTag;
            }
            public ConsumeOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr());
            }

            public int protocolClassId() { return 60; }
            public int protocolMethodId() { return 21; }
            public String protocolMethodName() { return "basic.consume-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            ConsumeOk that = (ConsumeOk) o;
            if (consumerTag != null ? !consumerTag.equals(that.consumerTag) : that.consumerTag != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (consumerTag != null ? consumerTag.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(consumer-tag=")
                   .append(this.consumerTag)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShortstr(this.consumerTag);
            }
        }

        public static class Cancel
            extends Method
            implements com.rabbitmq.client.AMQP.Basic.Cancel
        {
            public static final int INDEX = 30;

            private final String consumerTag;
            private final boolean nowait;

            public String getConsumerTag() { return consumerTag; }
            public boolean getNowait() { return nowait; }

            public Cancel(String consumerTag, boolean nowait) {
                if (consumerTag == null)
                    throw new IllegalStateException("Invalid configuration: 'consumerTag' must be non-null.");
                this.consumerTag = consumerTag;
                this.nowait = nowait;
            }
            public Cancel(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr(), rdr.readBit());
            }

            public int protocolClassId() { return 60; }
            public int protocolMethodId() { return 30; }
            public String protocolMethodName() { return "basic.cancel";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Cancel that = (Cancel) o;
            if (consumerTag != null ? !consumerTag.equals(that.consumerTag) : that.consumerTag != null)
                return false;
            if (nowait != that.nowait)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (consumerTag != null ? consumerTag.hashCode() : 0);
            result = 31 * result + (nowait ? 1 : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(consumer-tag=")
                   .append(this.consumerTag)
                   .append(", nowait=")
                   .append(this.nowait)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShortstr(this.consumerTag);
                writer.writeBit(this.nowait);
            }
        }

        public static class CancelOk
            extends Method
            implements com.rabbitmq.client.AMQP.Basic.CancelOk
        {
            public static final int INDEX = 31;

            private final String consumerTag;

            public String getConsumerTag() { return consumerTag; }

            public CancelOk(String consumerTag) {
                if (consumerTag == null)
                    throw new IllegalStateException("Invalid configuration: 'consumerTag' must be non-null.");
                this.consumerTag = consumerTag;
            }
            public CancelOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr());
            }

            public int protocolClassId() { return 60; }
            public int protocolMethodId() { return 31; }
            public String protocolMethodName() { return "basic.cancel-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            CancelOk that = (CancelOk) o;
            if (consumerTag != null ? !consumerTag.equals(that.consumerTag) : that.consumerTag != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (consumerTag != null ? consumerTag.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(consumer-tag=")
                   .append(this.consumerTag)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShortstr(this.consumerTag);
            }
        }

        public static class Publish
            extends Method
            implements com.rabbitmq.client.AMQP.Basic.Publish
        {
            public static final int INDEX = 40;

            private final int ticket;
            private final String exchange;
            private final String routingKey;
            private final boolean mandatory;
            private final boolean immediate;

            public int getTicket() { return ticket; }
            public String getExchange() { return exchange; }
            public String getRoutingKey() { return routingKey; }
            public boolean getMandatory() { return mandatory; }
            public boolean getImmediate() { return immediate; }

            public Publish(int ticket, String exchange, String routingKey, boolean mandatory, boolean immediate) {
                if (exchange == null)
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                if (routingKey == null)
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                this.ticket = ticket;
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.mandatory = mandatory;
                this.immediate = immediate;
            }
            public Publish(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readShortstr(), rdr.readBit(), rdr.readBit());
            }

            public int protocolClassId() { return 60; }
            public int protocolMethodId() { return 40; }
            public String protocolMethodName() { return "basic.publish";}

            public boolean hasContent() { return true; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Publish that = (Publish) o;
            if (ticket != that.ticket)
                return false;
            if (exchange != null ? !exchange.equals(that.exchange) : that.exchange != null)
                return false;
            if (routingKey != null ? !routingKey.equals(that.routingKey) : that.routingKey != null)
                return false;
            if (mandatory != that.mandatory)
                return false;
            if (immediate != that.immediate)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + ticket;
            result = 31 * result + (exchange != null ? exchange.hashCode() : 0);
            result = 31 * result + (routingKey != null ? routingKey.hashCode() : 0);
            result = 31 * result + (mandatory ? 1 : 0);
            result = 31 * result + (immediate ? 1 : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=")
                   .append(this.ticket)
                   .append(", exchange=")
                   .append(this.exchange)
                   .append(", routing-key=")
                   .append(this.routingKey)
                   .append(", mandatory=")
                   .append(this.mandatory)
                   .append(", immediate=")
                   .append(this.immediate)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
                writer.writeBit(this.mandatory);
                writer.writeBit(this.immediate);
            }
        }

        public static class Return
            extends Method
            implements com.rabbitmq.client.AMQP.Basic.Return
        {
            public static final int INDEX = 50;

            private final int replyCode;
            private final String replyText;
            private final String exchange;
            private final String routingKey;

            public int getReplyCode() { return replyCode; }
            public String getReplyText() { return replyText; }
            public String getExchange() { return exchange; }
            public String getRoutingKey() { return routingKey; }

            public Return(int replyCode, String replyText, String exchange, String routingKey) {
                if (exchange == null)
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                if (replyText == null)
                    throw new IllegalStateException("Invalid configuration: 'replyText' must be non-null.");
                if (routingKey == null)
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                this.replyCode = replyCode;
                this.replyText = replyText;
                this.exchange = exchange;
                this.routingKey = routingKey;
            }
            public Return(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readShortstr(), rdr.readShortstr());
            }

            public int protocolClassId() { return 60; }
            public int protocolMethodId() { return 50; }
            public String protocolMethodName() { return "basic.return";}

            public boolean hasContent() { return true; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Return that = (Return) o;
            if (replyCode != that.replyCode)
                return false;
            if (replyText != null ? !replyText.equals(that.replyText) : that.replyText != null)
                return false;
            if (exchange != null ? !exchange.equals(that.exchange) : that.exchange != null)
                return false;
            if (routingKey != null ? !routingKey.equals(that.routingKey) : that.routingKey != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + replyCode;
            result = 31 * result + (replyText != null ? replyText.hashCode() : 0);
            result = 31 * result + (exchange != null ? exchange.hashCode() : 0);
            result = 31 * result + (routingKey != null ? routingKey.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(reply-code=")
                   .append(this.replyCode)
                   .append(", reply-text=")
                   .append(this.replyText)
                   .append(", exchange=")
                   .append(this.exchange)
                   .append(", routing-key=")
                   .append(this.routingKey)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShort(this.replyCode);
                writer.writeShortstr(this.replyText);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
            }
        }

        public static class Deliver
            extends Method
            implements com.rabbitmq.client.AMQP.Basic.Deliver
        {
            public static final int INDEX = 60;

            private final String consumerTag;
            private final long deliveryTag;
            private final boolean redelivered;
            private final String exchange;
            private final String routingKey;

            public String getConsumerTag() { return consumerTag; }
            public long getDeliveryTag() { return deliveryTag; }
            public boolean getRedelivered() { return redelivered; }
            public String getExchange() { return exchange; }
            public String getRoutingKey() { return routingKey; }

            public Deliver(String consumerTag, long deliveryTag, boolean redelivered, String exchange, String routingKey) {
                if (consumerTag == null)
                    throw new IllegalStateException("Invalid configuration: 'consumerTag' must be non-null.");
                if (exchange == null)
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                if (routingKey == null)
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                this.consumerTag = consumerTag;
                this.deliveryTag = deliveryTag;
                this.redelivered = redelivered;
                this.exchange = exchange;
                this.routingKey = routingKey;
            }
            public Deliver(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr(), rdr.readLonglong(), rdr.readBit(), rdr.readShortstr(), rdr.readShortstr());
            }

            public int protocolClassId() { return 60; }
            public int protocolMethodId() { return 60; }
            public String protocolMethodName() { return "basic.deliver";}

            public boolean hasContent() { return true; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Deliver that = (Deliver) o;
            if (consumerTag != null ? !consumerTag.equals(that.consumerTag) : that.consumerTag != null)
                return false;
            if (deliveryTag != that.deliveryTag)
                return false;
            if (redelivered != that.redelivered)
                return false;
            if (exchange != null ? !exchange.equals(that.exchange) : that.exchange != null)
                return false;
            if (routingKey != null ? !routingKey.equals(that.routingKey) : that.routingKey != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (consumerTag != null ? consumerTag.hashCode() : 0);
            result = 31 * result + (int) (deliveryTag ^ (deliveryTag >>> 32));
            result = 31 * result + (redelivered ? 1 : 0);
            result = 31 * result + (exchange != null ? exchange.hashCode() : 0);
            result = 31 * result + (routingKey != null ? routingKey.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(consumer-tag=")
                   .append(this.consumerTag)
                   .append(", delivery-tag=")
                   .append(this.deliveryTag)
                   .append(", redelivered=")
                   .append(this.redelivered)
                   .append(", exchange=")
                   .append(this.exchange)
                   .append(", routing-key=")
                   .append(this.routingKey)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShortstr(this.consumerTag);
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.redelivered);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
            }
        }

        public static class Get
            extends Method
            implements com.rabbitmq.client.AMQP.Basic.Get
        {
            public static final int INDEX = 70;

            private final int ticket;
            private final String queue;
            private final boolean noAck;

            public int getTicket() { return ticket; }
            public String getQueue() { return queue; }
            public boolean getNoAck() { return noAck; }

            public Get(int ticket, String queue, boolean noAck) {
                if (queue == null)
                    throw new IllegalStateException("Invalid configuration: 'queue' must be non-null.");
                this.ticket = ticket;
                this.queue = queue;
                this.noAck = noAck;
            }
            public Get(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShort(), rdr.readShortstr(), rdr.readBit());
            }

            public int protocolClassId() { return 60; }
            public int protocolMethodId() { return 70; }
            public String protocolMethodName() { return "basic.get";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Get that = (Get) o;
            if (ticket != that.ticket)
                return false;
            if (queue != null ? !queue.equals(that.queue) : that.queue != null)
                return false;
            if (noAck != that.noAck)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + ticket;
            result = 31 * result + (queue != null ? queue.hashCode() : 0);
            result = 31 * result + (noAck ? 1 : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(ticket=")
                   .append(this.ticket)
                   .append(", queue=")
                   .append(this.queue)
                   .append(", no-ack=")
                   .append(this.noAck)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShort(this.ticket);
                writer.writeShortstr(this.queue);
                writer.writeBit(this.noAck);
            }
        }

        public static class GetOk
            extends Method
            implements com.rabbitmq.client.AMQP.Basic.GetOk
        {
            public static final int INDEX = 71;

            private final long deliveryTag;
            private final boolean redelivered;
            private final String exchange;
            private final String routingKey;
            private final int messageCount;

            public long getDeliveryTag() { return deliveryTag; }
            public boolean getRedelivered() { return redelivered; }
            public String getExchange() { return exchange; }
            public String getRoutingKey() { return routingKey; }
            public int getMessageCount() { return messageCount; }

            public GetOk(long deliveryTag, boolean redelivered, String exchange, String routingKey, int messageCount) {
                if (exchange == null)
                    throw new IllegalStateException("Invalid configuration: 'exchange' must be non-null.");
                if (routingKey == null)
                    throw new IllegalStateException("Invalid configuration: 'routingKey' must be non-null.");
                this.deliveryTag = deliveryTag;
                this.redelivered = redelivered;
                this.exchange = exchange;
                this.routingKey = routingKey;
                this.messageCount = messageCount;
            }
            public GetOk(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLonglong(), rdr.readBit(), rdr.readShortstr(), rdr.readShortstr(), rdr.readLong());
            }

            public int protocolClassId() { return 60; }
            public int protocolMethodId() { return 71; }
            public String protocolMethodName() { return "basic.get-ok";}

            public boolean hasContent() { return true; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            GetOk that = (GetOk) o;
            if (deliveryTag != that.deliveryTag)
                return false;
            if (redelivered != that.redelivered)
                return false;
            if (exchange != null ? !exchange.equals(that.exchange) : that.exchange != null)
                return false;
            if (routingKey != null ? !routingKey.equals(that.routingKey) : that.routingKey != null)
                return false;
            if (messageCount != that.messageCount)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (int) (deliveryTag ^ (deliveryTag >>> 32));
            result = 31 * result + (redelivered ? 1 : 0);
            result = 31 * result + (exchange != null ? exchange.hashCode() : 0);
            result = 31 * result + (routingKey != null ? routingKey.hashCode() : 0);
            result = 31 * result + messageCount;
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(delivery-tag=")
                   .append(this.deliveryTag)
                   .append(", redelivered=")
                   .append(this.redelivered)
                   .append(", exchange=")
                   .append(this.exchange)
                   .append(", routing-key=")
                   .append(this.routingKey)
                   .append(", message-count=")
                   .append(this.messageCount)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.redelivered);
                writer.writeShortstr(this.exchange);
                writer.writeShortstr(this.routingKey);
                writer.writeLong(this.messageCount);
            }
        }

        public static class GetEmpty
            extends Method
            implements com.rabbitmq.client.AMQP.Basic.GetEmpty
        {
            public static final int INDEX = 72;

            private final String clusterId;

            public String getClusterId() { return clusterId; }

            public GetEmpty(String clusterId) {
                if (clusterId == null)
                    throw new IllegalStateException("Invalid configuration: 'clusterId' must be non-null.");
                this.clusterId = clusterId;
            }
            public GetEmpty(MethodArgumentReader rdr) throws IOException {
                this(rdr.readShortstr());
            }

            public int protocolClassId() { return 60; }
            public int protocolMethodId() { return 72; }
            public String protocolMethodName() { return "basic.get-empty";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            GetEmpty that = (GetEmpty) o;
            if (clusterId != null ? !clusterId.equals(that.clusterId) : that.clusterId != null)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (clusterId != null ? clusterId.hashCode() : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(cluster-id=")
                   .append(this.clusterId)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeShortstr(this.clusterId);
            }
        }

        public static class Ack
            extends Method
            implements com.rabbitmq.client.AMQP.Basic.Ack
        {
            public static final int INDEX = 80;

            private final long deliveryTag;
            private final boolean multiple;

            public long getDeliveryTag() { return deliveryTag; }
            public boolean getMultiple() { return multiple; }

            public Ack(long deliveryTag, boolean multiple) {
                this.deliveryTag = deliveryTag;
                this.multiple = multiple;
            }
            public Ack(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLonglong(), rdr.readBit());
            }

            public int protocolClassId() { return 60; }
            public int protocolMethodId() { return 80; }
            public String protocolMethodName() { return "basic.ack";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Ack that = (Ack) o;
            if (deliveryTag != that.deliveryTag)
                return false;
            if (multiple != that.multiple)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (int) (deliveryTag ^ (deliveryTag >>> 32));
            result = 31 * result + (multiple ? 1 : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(delivery-tag=")
                   .append(this.deliveryTag)
                   .append(", multiple=")
                   .append(this.multiple)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.multiple);
            }
        }

        public static class Reject
            extends Method
            implements com.rabbitmq.client.AMQP.Basic.Reject
        {
            public static final int INDEX = 90;

            private final long deliveryTag;
            private final boolean requeue;

            public long getDeliveryTag() { return deliveryTag; }
            public boolean getRequeue() { return requeue; }

            public Reject(long deliveryTag, boolean requeue) {
                this.deliveryTag = deliveryTag;
                this.requeue = requeue;
            }
            public Reject(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLonglong(), rdr.readBit());
            }

            public int protocolClassId() { return 60; }
            public int protocolMethodId() { return 90; }
            public String protocolMethodName() { return "basic.reject";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Reject that = (Reject) o;
            if (deliveryTag != that.deliveryTag)
                return false;
            if (requeue != that.requeue)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (int) (deliveryTag ^ (deliveryTag >>> 32));
            result = 31 * result + (requeue ? 1 : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(delivery-tag=")
                   .append(this.deliveryTag)
                   .append(", requeue=")
                   .append(this.requeue)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.requeue);
            }
        }

        public static class RecoverAsync
            extends Method
            implements com.rabbitmq.client.AMQP.Basic.RecoverAsync
        {
            public static final int INDEX = 100;

            private final boolean requeue;

            public boolean getRequeue() { return requeue; }

            public RecoverAsync(boolean requeue) {
                this.requeue = requeue;
            }
            public RecoverAsync(MethodArgumentReader rdr) throws IOException {
                this(rdr.readBit());
            }

            public int protocolClassId() { return 60; }
            public int protocolMethodId() { return 100; }
            public String protocolMethodName() { return "basic.recover-async";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            RecoverAsync that = (RecoverAsync) o;
            if (requeue != that.requeue)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (requeue ? 1 : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(requeue=")
                   .append(this.requeue)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeBit(this.requeue);
            }
        }

        public static class Recover
            extends Method
            implements com.rabbitmq.client.AMQP.Basic.Recover
        {
            public static final int INDEX = 110;

            private final boolean requeue;

            public boolean getRequeue() { return requeue; }

            public Recover(boolean requeue) {
                this.requeue = requeue;
            }
            public Recover(MethodArgumentReader rdr) throws IOException {
                this(rdr.readBit());
            }

            public int protocolClassId() { return 60; }
            public int protocolMethodId() { return 110; }
            public String protocolMethodName() { return "basic.recover";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Recover that = (Recover) o;
            if (requeue != that.requeue)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (requeue ? 1 : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(requeue=")
                   .append(this.requeue)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeBit(this.requeue);
            }
        }

        public static class RecoverOk
            extends Method
            implements com.rabbitmq.client.AMQP.Basic.RecoverOk
        {
            public static final int INDEX = 111;


            public RecoverOk() {
            }
            public RecoverOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() { return 60; }
            public int protocolMethodId() { return 111; }
            public String protocolMethodName() { return "basic.recover-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
            }
        }

        public static class Nack
            extends Method
            implements com.rabbitmq.client.AMQP.Basic.Nack
        {
            public static final int INDEX = 120;

            private final long deliveryTag;
            private final boolean multiple;
            private final boolean requeue;

            public long getDeliveryTag() { return deliveryTag; }
            public boolean getMultiple() { return multiple; }
            public boolean getRequeue() { return requeue; }

            public Nack(long deliveryTag, boolean multiple, boolean requeue) {
                this.deliveryTag = deliveryTag;
                this.multiple = multiple;
                this.requeue = requeue;
            }
            public Nack(MethodArgumentReader rdr) throws IOException {
                this(rdr.readLonglong(), rdr.readBit(), rdr.readBit());
            }

            public int protocolClassId() { return 60; }
            public int protocolMethodId() { return 120; }
            public String protocolMethodName() { return "basic.nack";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Nack that = (Nack) o;
            if (deliveryTag != that.deliveryTag)
                return false;
            if (multiple != that.multiple)
                return false;
            if (requeue != that.requeue)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (int) (deliveryTag ^ (deliveryTag >>> 32));
            result = 31 * result + (multiple ? 1 : 0);
            result = 31 * result + (requeue ? 1 : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(delivery-tag=")
                   .append(this.deliveryTag)
                   .append(", multiple=")
                   .append(this.multiple)
                   .append(", requeue=")
                   .append(this.requeue)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeLonglong(this.deliveryTag);
                writer.writeBit(this.multiple);
                writer.writeBit(this.requeue);
            }
        }
    }

    public static class Tx {
        public static final int INDEX = 90;

        public static class Select
            extends Method
            implements com.rabbitmq.client.AMQP.Tx.Select
        {
            public static final int INDEX = 10;


            public Select() {
            }
            public Select(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() { return 90; }
            public int protocolMethodId() { return 10; }
            public String protocolMethodName() { return "tx.select";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
            }
        }

        public static class SelectOk
            extends Method
            implements com.rabbitmq.client.AMQP.Tx.SelectOk
        {
            public static final int INDEX = 11;


            public SelectOk() {
            }
            public SelectOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() { return 90; }
            public int protocolMethodId() { return 11; }
            public String protocolMethodName() { return "tx.select-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
            }
        }

        public static class Commit
            extends Method
            implements com.rabbitmq.client.AMQP.Tx.Commit
        {
            public static final int INDEX = 20;


            public Commit() {
            }
            public Commit(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() { return 90; }
            public int protocolMethodId() { return 20; }
            public String protocolMethodName() { return "tx.commit";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
            }
        }

        public static class CommitOk
            extends Method
            implements com.rabbitmq.client.AMQP.Tx.CommitOk
        {
            public static final int INDEX = 21;


            public CommitOk() {
            }
            public CommitOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() { return 90; }
            public int protocolMethodId() { return 21; }
            public String protocolMethodName() { return "tx.commit-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
            }
        }

        public static class Rollback
            extends Method
            implements com.rabbitmq.client.AMQP.Tx.Rollback
        {
            public static final int INDEX = 30;


            public Rollback() {
            }
            public Rollback(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() { return 90; }
            public int protocolMethodId() { return 30; }
            public String protocolMethodName() { return "tx.rollback";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
            }
        }

        public static class RollbackOk
            extends Method
            implements com.rabbitmq.client.AMQP.Tx.RollbackOk
        {
            public static final int INDEX = 31;


            public RollbackOk() {
            }
            public RollbackOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() { return 90; }
            public int protocolMethodId() { return 31; }
            public String protocolMethodName() { return "tx.rollback-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
            }
        }
    }

    public static class Confirm {
        public static final int INDEX = 85;

        public static class Select
            extends Method
            implements com.rabbitmq.client.AMQP.Confirm.Select
        {
            public static final int INDEX = 10;

            private final boolean nowait;

            public boolean getNowait() { return nowait; }

            public Select(boolean nowait) {
                this.nowait = nowait;
            }
            public Select(MethodArgumentReader rdr) throws IOException {
                this(rdr.readBit());
            }

            public int protocolClassId() { return 85; }
            public int protocolMethodId() { return 10; }
            public String protocolMethodName() { return "confirm.select";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }


        @Override
        public boolean equals(Object o) {
            if (this == o)
                return true;
            if (o == null || getClass() != o.getClass())
               return false;
            Select that = (Select) o;
            if (nowait != that.nowait)
                return false;
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            result = 31 * result + (nowait ? 1 : 0);
            return result;
        }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("(nowait=")
                   .append(this.nowait)
                   .append(")");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
                writer.writeBit(this.nowait);
            }
        }

        public static class SelectOk
            extends Method
            implements com.rabbitmq.client.AMQP.Confirm.SelectOk
        {
            public static final int INDEX = 11;


            public SelectOk() {
            }
            public SelectOk(MethodArgumentReader rdr) throws IOException {
                this();
            }

            public int protocolClassId() { return 85; }
            public int protocolMethodId() { return 11; }
            public String protocolMethodName() { return "confirm.select-ok";}

            public boolean hasContent() { return false; }

            public Object visit(MethodVisitor visitor) throws IOException
            {   return visitor.visit(this); }

            public void appendArgumentDebugStringTo(StringBuilder acc) {
                acc.append("()");
            }

            public void writeArgumentsTo(MethodArgumentWriter writer)
                throws IOException
            {
            }
        }
    }

    public interface MethodVisitor {
        Object visit(Connection.Start x) throws IOException;
        Object visit(Connection.StartOk x) throws IOException;
        Object visit(Connection.Secure x) throws IOException;
        Object visit(Connection.SecureOk x) throws IOException;
        Object visit(Connection.Tune x) throws IOException;
        Object visit(Connection.TuneOk x) throws IOException;
        Object visit(Connection.Open x) throws IOException;
        Object visit(Connection.OpenOk x) throws IOException;
        Object visit(Connection.Close x) throws IOException;
        Object visit(Connection.CloseOk x) throws IOException;
        Object visit(Connection.Blocked x) throws IOException;
        Object visit(Connection.Unblocked x) throws IOException;
        Object visit(Connection.UpdateSecret x) throws IOException;
        Object visit(Connection.UpdateSecretOk x) throws IOException;
        Object visit(Channel.Open x) throws IOException;
        Object visit(Channel.OpenOk x) throws IOException;
        Object visit(Channel.Flow x) throws IOException;
        Object visit(Channel.FlowOk x) throws IOException;
        Object visit(Channel.Close x) throws IOException;
        Object visit(Channel.CloseOk x) throws IOException;
        Object visit(Access.Request x) throws IOException;
        Object visit(Access.RequestOk x) throws IOException;
        Object visit(Exchange.Declare x) throws IOException;
        Object visit(Exchange.DeclareOk x) throws IOException;
        Object visit(Exchange.Delete x) throws IOException;
        Object visit(Exchange.DeleteOk x) throws IOException;
        Object visit(Exchange.Bind x) throws IOException;
        Object visit(Exchange.BindOk x) throws IOException;
        Object visit(Exchange.Unbind x) throws IOException;
        Object visit(Exchange.UnbindOk x) throws IOException;
        Object visit(Queue.Declare x) throws IOException;
        Object visit(Queue.DeclareOk x) throws IOException;
        Object visit(Queue.Bind x) throws IOException;
        Object visit(Queue.BindOk x) throws IOException;
        Object visit(Queue.Purge x) throws IOException;
        Object visit(Queue.PurgeOk x) throws IOException;
        Object visit(Queue.Delete x) throws IOException;
        Object visit(Queue.DeleteOk x) throws IOException;
        Object visit(Queue.Unbind x) throws IOException;
        Object visit(Queue.UnbindOk x) throws IOException;
        Object visit(Basic.Qos x) throws IOException;
        Object visit(Basic.QosOk x) throws IOException;
        Object visit(Basic.Consume x) throws IOException;
        Object visit(Basic.ConsumeOk x) throws IOException;
        Object visit(Basic.Cancel x) throws IOException;
        Object visit(Basic.CancelOk x) throws IOException;
        Object visit(Basic.Publish x) throws IOException;
        Object visit(Basic.Return x) throws IOException;
        Object visit(Basic.Deliver x) throws IOException;
        Object visit(Basic.Get x) throws IOException;
        Object visit(Basic.GetOk x) throws IOException;
        Object visit(Basic.GetEmpty x) throws IOException;
        Object visit(Basic.Ack x) throws IOException;
        Object visit(Basic.Reject x) throws IOException;
        Object visit(Basic.RecoverAsync x) throws IOException;
        Object visit(Basic.Recover x) throws IOException;
        Object visit(Basic.RecoverOk x) throws IOException;
        Object visit(Basic.Nack x) throws IOException;
        Object visit(Tx.Select x) throws IOException;
        Object visit(Tx.SelectOk x) throws IOException;
        Object visit(Tx.Commit x) throws IOException;
        Object visit(Tx.CommitOk x) throws IOException;
        Object visit(Tx.Rollback x) throws IOException;
        Object visit(Tx.RollbackOk x) throws IOException;
        Object visit(Confirm.Select x) throws IOException;
        Object visit(Confirm.SelectOk x) throws IOException;
    }

    public static class DefaultMethodVisitor implements MethodVisitor {
        public Object visit(Connection.Start x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Connection.StartOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Connection.Secure x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Connection.SecureOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Connection.Tune x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Connection.TuneOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Connection.Open x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Connection.OpenOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Connection.Close x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Connection.CloseOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Connection.Blocked x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Connection.Unblocked x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Connection.UpdateSecret x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Connection.UpdateSecretOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Channel.Open x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Channel.OpenOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Channel.Flow x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Channel.FlowOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Channel.Close x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Channel.CloseOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Access.Request x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Access.RequestOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Exchange.Declare x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Exchange.DeclareOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Exchange.Delete x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Exchange.DeleteOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Exchange.Bind x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Exchange.BindOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Exchange.Unbind x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Exchange.UnbindOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Queue.Declare x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Queue.DeclareOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Queue.Bind x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Queue.BindOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Queue.Purge x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Queue.PurgeOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Queue.Delete x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Queue.DeleteOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Queue.Unbind x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Queue.UnbindOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Basic.Qos x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Basic.QosOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Basic.Consume x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Basic.ConsumeOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Basic.Cancel x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Basic.CancelOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Basic.Publish x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Basic.Return x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Basic.Deliver x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Basic.Get x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Basic.GetOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Basic.GetEmpty x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Basic.Ack x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Basic.Reject x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Basic.RecoverAsync x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Basic.Recover x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Basic.RecoverOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Basic.Nack x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Tx.Select x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Tx.SelectOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Tx.Commit x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Tx.CommitOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Tx.Rollback x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Tx.RollbackOk x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Confirm.Select x) throws IOException { throw new UnexpectedMethodError(x); }
        public Object visit(Confirm.SelectOk x) throws IOException { throw new UnexpectedMethodError(x); }
    }

    public static Method readMethodFrom(DataInputStream in) throws IOException {
        int classId = in.readShort();
        int methodId = in.readShort();
        switch (classId) {
            case 10:
                switch (methodId) {
                    case 10: {
                        return new Connection.Start(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 11: {
                        return new Connection.StartOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 20: {
                        return new Connection.Secure(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 21: {
                        return new Connection.SecureOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 30: {
                        return new Connection.Tune(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 31: {
                        return new Connection.TuneOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 40: {
                        return new Connection.Open(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 41: {
                        return new Connection.OpenOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 50: {
                        return new Connection.Close(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 51: {
                        return new Connection.CloseOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 60: {
                        return new Connection.Blocked(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 61: {
                        return new Connection.Unblocked(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 70: {
                        return new Connection.UpdateSecret(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 71: {
                        return new Connection.UpdateSecretOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    default: break;
                } break;
            case 20:
                switch (methodId) {
                    case 10: {
                        return new Channel.Open(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 11: {
                        return new Channel.OpenOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 20: {
                        return new Channel.Flow(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 21: {
                        return new Channel.FlowOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 40: {
                        return new Channel.Close(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 41: {
                        return new Channel.CloseOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    default: break;
                } break;
            case 30:
                switch (methodId) {
                    case 10: {
                        return new Access.Request(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 11: {
                        return new Access.RequestOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    default: break;
                } break;
            case 40:
                switch (methodId) {
                    case 10: {
                        return new Exchange.Declare(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 11: {
                        return new Exchange.DeclareOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 20: {
                        return new Exchange.Delete(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 21: {
                        return new Exchange.DeleteOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 30: {
                        return new Exchange.Bind(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 31: {
                        return new Exchange.BindOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 40: {
                        return new Exchange.Unbind(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 51: {
                        return new Exchange.UnbindOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    default: break;
                } break;
            case 50:
                switch (methodId) {
                    case 10: {
                        return new Queue.Declare(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 11: {
                        return new Queue.DeclareOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 20: {
                        return new Queue.Bind(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 21: {
                        return new Queue.BindOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 30: {
                        return new Queue.Purge(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 31: {
                        return new Queue.PurgeOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 40: {
                        return new Queue.Delete(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 41: {
                        return new Queue.DeleteOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 50: {
                        return new Queue.Unbind(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 51: {
                        return new Queue.UnbindOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    default: break;
                } break;
            case 60:
                switch (methodId) {
                    case 10: {
                        return new Basic.Qos(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 11: {
                        return new Basic.QosOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 20: {
                        return new Basic.Consume(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 21: {
                        return new Basic.ConsumeOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 30: {
                        return new Basic.Cancel(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 31: {
                        return new Basic.CancelOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 40: {
                        return new Basic.Publish(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 50: {
                        return new Basic.Return(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 60: {
                        return new Basic.Deliver(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 70: {
                        return new Basic.Get(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 71: {
                        return new Basic.GetOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 72: {
                        return new Basic.GetEmpty(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 80: {
                        return new Basic.Ack(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 90: {
                        return new Basic.Reject(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 100: {
                        return new Basic.RecoverAsync(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 110: {
                        return new Basic.Recover(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 111: {
                        return new Basic.RecoverOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 120: {
                        return new Basic.Nack(new MethodArgumentReader(new ValueReader(in)));
                    }
                    default: break;
                } break;
            case 90:
                switch (methodId) {
                    case 10: {
                        return new Tx.Select(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 11: {
                        return new Tx.SelectOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 20: {
                        return new Tx.Commit(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 21: {
                        return new Tx.CommitOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 30: {
                        return new Tx.Rollback(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 31: {
                        return new Tx.RollbackOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    default: break;
                } break;
            case 85:
                switch (methodId) {
                    case 10: {
                        return new Confirm.Select(new MethodArgumentReader(new ValueReader(in)));
                    }
                    case 11: {
                        return new Confirm.SelectOk(new MethodArgumentReader(new ValueReader(in)));
                    }
                    default: break;
                } break;
        }

        throw new UnknownClassOrMethodId(classId, methodId);
    }

    public static AMQContentHeader readContentHeaderFrom(DataInputStream in) throws IOException {
        int classId = in.readShort();
        switch (classId) {
            case 60: return new BasicProperties(in);
            default: break;
        }

        throw new UnknownClassOrMethodId(classId);
    }
}
