/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.task;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerClass;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.hook.PlaceholderAPIHook;
import com.sucy.skill.hook.PluginChecker;
import com.sucy.skill.log.LogType;
import com.sucy.skill.log.Logger;
import com.sucy.skill.thread.RepeatThreadTask;
import mc.promcteam.engine.mccore.util.TextFormatter;
import mc.promcteam.engine.mccore.util.VersionManager;
import mc.promcteam.engine.utils.MsgUT;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class GUITask
extends RepeatThreadTask {
    private final boolean levelMana;
    private final boolean levelLevel;
    private final boolean foodMana;
    private final boolean foodExp;
    private final boolean forceScaling;
    private final boolean oldHealth;
    private final boolean useAction;
    private final String actionText;

    public GUITask(SkillAPI api) {
        super(5, 5);
        String levelBar = SkillAPI.getSettings().getLevelBar().toLowerCase();
        this.levelMana = levelBar.equals("mana");
        this.levelLevel = levelBar.equals("level");
        String foodBar = SkillAPI.getSettings().getFoodBar().toLowerCase();
        this.foodMana = foodBar.equals("mana");
        this.foodExp = foodBar.equals("exp");
        this.forceScaling = SkillAPI.getSettings().isForceScaling();
        this.oldHealth = SkillAPI.getSettings().isOldHealth();
        this.useAction = SkillAPI.getSettings().isUseActionBar();
        this.actionText = TextFormatter.colorString((String)SkillAPI.getSettings().getActionText());
        Logger.log(LogType.GUI, 1, "GUI Settings: " + this.levelMana + "/" + this.levelLevel + "/" + this.foodMana + "/" + this.foodExp + "/" + this.useAction + "/" + this.actionText);
        if (this.useAction || this.levelMana || this.levelLevel || this.foodMana || this.foodExp || this.forceScaling) {
            return;
        }
        this.expired = true;
    }

    @Override
    public void run() {
        Logger.log(LogType.GUI, 1, "Updating GUI (" + VersionManager.getOnlinePlayers().length + " players)...");
        for (Player player : VersionManager.getOnlinePlayers()) {
            PlayerClass main;
            if (!SkillAPI.getSettings().isWorldEnabled(player.getWorld()) || !SkillAPI.hasPlayerData((OfflinePlayer)player)) continue;
            PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)player);
            if (this.forceScaling) {
                if (this.oldHealth) {
                    player.setHealthScale(20.0);
                } else {
                    player.setHealthScale(player.getMaxHealth());
                }
            }
            if (this.levelMana) {
                Logger.log(LogType.GUI, 2, "Updating level bar with mana");
                if (data.getMaxMana() == 0.0) {
                    player.setLevel(0);
                    player.setExp(0.0f);
                } else {
                    player.setLevel((int)data.getMana());
                    player.setExp(Math.min(0.999f, (float)(0.999 * data.getMana() / data.getMaxMana())));
                }
            } else if (this.levelLevel) {
                Logger.log(LogType.GUI, 2, "Updating level bar with class level/exp");
                if (!data.hasClass()) {
                    player.setLevel(0);
                    player.setExp(0.0f);
                } else {
                    main = data.getMainClass();
                    player.setLevel(main.getLevel());
                    player.setExp(Math.min(0.999f, (float)main.getExp() / (float)main.getRequiredExp()));
                }
            }
            if (this.foodMana) {
                Logger.log(LogType.GUI, 2, "Updating food bar with mana");
                player.setSaturation(20.0f);
                if (data.getMaxMana() == 0.0) {
                    player.setFoodLevel(20);
                } else {
                    player.setFoodLevel((int)Math.ceil(20.0 * data.getMana() / data.getMaxMana()));
                }
            } else if (this.foodExp) {
                Logger.log(LogType.GUI, 2, "Updating food bar with class level/exp");
                player.setSaturation(20.0f);
                if (!data.hasClass()) {
                    player.setFoodLevel(0);
                } else {
                    main = data.getMainClass();
                    player.setFoodLevel((int)Math.floor(20.0 * main.getExp() / (double)main.getRequiredExp()));
                }
            }
            if (!this.useAction || !data.hasClass()) continue;
            Logger.log(LogType.GUI, 2, "Updating action bar");
            main = data.getMainClass();
            String filtered = (main.getData().hasActionBarText() ? main.getData().getActionBarText() : this.actionText).replace("{combo}", data.getComboData().getCurrentComboString()).replace("{class}", main.getData().getPrefix()).replace("{level}", "" + main.getLevel()).replace("{exp}", "" + (int)main.getExp()).replace("{expReq}", "" + main.getRequiredExp()).replace("{expLeft}", "" + (int)Math.ceil((double)main.getRequiredExp() - main.getExp())).replace("{mana}", "" + (int)data.getMana()).replace("{maxMana}", "" + (int)data.getMaxMana()).replace("{name}", player.getName()).replace("{health}", "" + (int)player.getHealth()).replace("{maxHealth}", "" + (int)player.getMaxHealth()).replace("{attr}", "" + data.getAttributePoints()).replace("{sp}", "" + main.getPoints());
            while (filtered.contains("{value:")) {
                int index = filtered.indexOf("{value:");
                int end = filtered.indexOf(125, index);
                String key = filtered.substring(index + 7, end);
                Object value = DynamicSkill.getCastData((LivingEntity)player).get(key);
                filtered = filtered.replace("{value:" + key + "}", value == null ? "None" : value.toString());
            }
            if (PluginChecker.isPlaceholderAPIActive()) {
                filtered = PlaceholderAPIHook.format(filtered, player);
            }
            if (VersionManager.isVersionAtLeast((int)11000)) {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)filtered));
                continue;
            }
            MsgUT.sendActionBar((Player)player, (String)filtered);
        }
    }
}

