/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.listener;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.enums.ExpSource;
import com.sucy.skill.api.event.PhysicalDamageEvent;
import com.sucy.skill.api.event.SkillDamageEvent;
import com.sucy.skill.api.event.TrueDamageEvent;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.util.BuffManager;
import com.sucy.skill.api.util.FlagManager;
import com.sucy.skill.listener.ListenerUtil;
import com.sucy.skill.listener.SkillAPIListener;
import mc.promcteam.engine.utils.reflection.ReflectionManager;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.metadata.Metadatable;

public class KillListener
extends SkillAPIListener {
    private static final String S_TYPE = "sType";
    private static final int SPAWNER = 0;
    private static final int EGG = 1;

    public static void giveExp(LivingEntity entity, Player killer, int exp) {
        if (!SkillAPI.getSettings().isWorldEnabled(entity.getWorld())) {
            return;
        }
        if (entity.hasMetadata(S_TYPE)) {
            int value = SkillAPI.getMetaInt((Metadatable)entity, S_TYPE);
            if (value == 0 && SkillAPI.getSettings().isBlockSpawner()) {
                return;
            }
            if (value == 1 && SkillAPI.getSettings().isBlockEgg()) {
                return;
            }
        }
        if (entity.hasMetadata("sapiSumDamage")) {
            return;
        }
        if (killer != null && killer.hasPermission("skillapi.exp")) {
            if (killer.getGameMode() == GameMode.CREATIVE && SkillAPI.getSettings().isBlockCreative()) {
                return;
            }
            PlayerData player = SkillAPI.getPlayerData((OfflinePlayer)killer);
            if (SkillAPI.getSettings().isUseOrbs()) {
                player.giveExp(exp, ExpSource.MOB);
            } else {
                String name = ListenerUtil.getName((Entity)entity);
                double yield = SkillAPI.getSettings().getYield(name);
                player.giveExp(yield, ExpSource.MOB);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onKill(EntityDeathEvent event) {
        FlagManager.clearFlags(event.getEntity());
        BuffManager.clearData(event.getEntity());
        KillListener.giveExp(event.getEntity(), event.getEntity().getKiller(), event.getDroppedExp());
    }

    @EventHandler
    public void onSpawn(CreatureSpawnEvent event) {
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER) {
            SkillAPI.setMeta((Metadatable)event.getEntity(), S_TYPE, 0);
        } else if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER_EGG) {
            SkillAPI.setMeta((Metadatable)event.getEntity(), S_TYPE, 1);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPhysical(PhysicalDamageEvent event) {
        if (event.getDamager() instanceof Player) {
            ReflectionManager.getReflectionUtil().setKiller(event.getTarget(), (Player)event.getDamager());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSpell(SkillDamageEvent event) {
        if (event.getDamager() instanceof Player) {
            ReflectionManager.getReflectionUtil().setKiller(event.getTarget(), (Player)event.getDamager());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTrue(TrueDamageEvent event) {
        if (event.getDamager() instanceof Player) {
            ReflectionManager.getReflectionUtil().setKiller(event.getTarget(), (Player)event.getDamager());
        }
    }
}

