/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.listener;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.event.SkillDamageEvent;
import com.sucy.skill.api.event.TrueDamageEvent;
import com.sucy.skill.api.particle.EffectManager;
import com.sucy.skill.listener.KillListener;
import com.sucy.skill.listener.SkillAPIListener;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.metadata.Metadatable;

public class DeathListener
extends SkillAPIListener {
    private final String KILLER = "sapiKiller";

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSpell(SkillDamageEvent event) {
        this.handle(event.getTarget(), event.getDamager(), event.getDamage());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTrue(TrueDamageEvent event) {
        this.handle(event.getTarget(), event.getDamager(), event.getDamage());
    }

    private void handle(LivingEntity entity, LivingEntity damager, double damage) {
        SkillAPI.setMeta((Metadatable)entity, "sapiKiller", damager);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onDeath(EntityDeathEvent event) {
        EffectManager.clear(event.getEntity());
        Object killer = SkillAPI.getMeta((Metadatable)event.getEntity(), "sapiKiller");
        if (killer != null && event.getEntity().getKiller() == null) {
            this.applyDeath(event.getEntity(), (LivingEntity)killer, event.getDroppedExp());
        }
    }

    private void applyDeath(LivingEntity entity, LivingEntity damager, int exp) {
        if (!entity.isDead() || entity.getKiller() != null || !(damager instanceof Player)) {
            return;
        }
        KillListener.giveExp(entity, (Player)damager, exp);
    }
}

