/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.listener;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.event.KeyPressEvent;
import com.sucy.skill.api.player.PlayerCombos;
import com.sucy.skill.data.Click;
import com.sucy.skill.listener.SkillAPIListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;

public class ComboListener
extends SkillAPIListener {
    private HashMap<UUID, Long> lastClick = new HashMap();
    private HashSet<UUID> onGround = new HashSet();

    @Override
    public void cleanup() {
        this.lastClick.clear();
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.lastClick.remove(event.getPlayer().getUniqueId());
        this.onGround.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onClick(KeyPressEvent event) {
        Long time = this.lastClick.get(event.getPlayer().getUniqueId());
        if (time != null && time > System.currentTimeMillis()) {
            return;
        }
        PlayerCombos combo = SkillAPI.getPlayerData((OfflinePlayer)event.getPlayer()).getComboData();
        switch (event.getKey()) {
            case Q: {
                combo.applyClick(Click.Q);
                break;
            }
            case LEFT: {
                if (event.getPlayer().isSneaking() && SkillAPI.getComboManager().isClickEnabled(Click.LEFT_SHIFT.getId())) {
                    combo.applyClick(Click.LEFT_SHIFT);
                    break;
                }
                combo.applyClick(Click.LEFT);
                break;
            }
            case RIGHT: {
                if (event.getPlayer().isSneaking() && SkillAPI.getComboManager().isClickEnabled(Click.RIGHT_SHIFT.getId())) {
                    combo.applyClick(Click.RIGHT_SHIFT);
                    break;
                }
                combo.applyClick(Click.RIGHT);
                break;
            }
            default: {
                return;
            }
        }
        this.lastClick.put(event.getPlayer().getUniqueId(), System.currentTimeMillis() + 40L);
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        if (SkillAPI.getComboManager().isClickEnabled(Click.Q.getId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onShiftClick(PlayerToggleSneakEvent event) {
        if (event.isSneaking()) {
            SkillAPI.getPlayerData((OfflinePlayer)event.getPlayer()).getComboData().applyClick(Click.SHIFT);
        }
    }

    @EventHandler
    public void onJump(PlayerMoveEvent event) {
        if (event.getTo().getY() > event.getFrom().getY() && event.getPlayer().getNoDamageTicks() == 0 && this.onGround.contains(event.getPlayer().getUniqueId())) {
            SkillAPI.getPlayerData((OfflinePlayer)event.getPlayer()).getComboData().applyClick(Click.SPACE);
        }
        if (event.getPlayer().isOnGround()) {
            this.onGround.add(event.getPlayer().getUniqueId());
        } else {
            this.onGround.remove(event.getPlayer().getUniqueId());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onFClick(PlayerSwapHandItemsEvent event) {
        SkillAPI.getPlayerData((OfflinePlayer)event.getPlayer()).getComboData().applyClick(Click.F);
        if (SkillAPI.getComboManager().isClickEnabled(Click.F.getId())) {
            event.setCancelled(true);
        }
    }
}

