/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.listener;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.event.PlayerClassChangeEvent;
import com.sucy.skill.api.event.PlayerSkillUnlockEvent;
import com.sucy.skill.cast.PlayerCastBars;
import com.sucy.skill.listener.MainListener;
import com.sucy.skill.listener.SkillAPIListener;
import com.sucy.skill.thread.MainThread;
import com.sucy.skill.thread.ThreadTask;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class CastListener
extends SkillAPIListener {
    private static int slot = SkillAPI.getSettings().getCastSlot();

    private static void cleanup(Player player) {
        if (SkillAPI.getSettings().isWorldEnabled(player.getWorld())) {
            CastListener.forceCleanup(player);
        }
    }

    private static void forceCleanup(Player player) {
        SkillAPI.getPlayerData((OfflinePlayer)player).getCastBars().restore(player);
        player.getInventory().setItem(slot, null);
    }

    @Override
    public void init() {
        MainListener.registerJoin(this::init);
        MainListener.registerClear(this::handleClear);
        Bukkit.getOnlinePlayers().forEach(this::init);
    }

    @Override
    public void cleanup() {
        if (slot == -1) {
            return;
        }
        Bukkit.getOnlinePlayers().forEach(CastListener::cleanup);
        slot = -1;
    }

    @EventHandler
    public void onDamaged(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            SkillAPI.getPlayerData((OfflinePlayer)player).getCastBars().restore(player);
        }
    }

    @EventHandler
    public void onClassChange(PlayerClassChangeEvent event) {
        event.getPlayerData().getCastBars().reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChangedWorldPre(PlayerChangedWorldEvent event) {
        boolean from = SkillAPI.getSettings().isWorldEnabled(event.getFrom());
        boolean to = SkillAPI.getSettings().isWorldEnabled(event.getPlayer().getWorld());
        if (from && !to) {
            CastListener.forceCleanup(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChangeWorld(PlayerChangedWorldEvent event) {
        boolean from = SkillAPI.getSettings().isWorldEnabled(event.getFrom());
        boolean to = SkillAPI.getSettings().isWorldEnabled(event.getPlayer().getWorld());
        if (to && !from) {
            this.init(event.getPlayer());
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        if (SkillAPI.getSettings().isWorldEnabled(event.getEntity().getWorld())) {
            if (slot == -1) {
                return;
            }
            event.getDrops().remove(event.getEntity().getInventory().getItem(slot));
        }
    }

    private void init(Player player) {
        if (!SkillAPI.getSettings().isWorldEnabled(player.getWorld())) {
            return;
        }
        PlayerInventory inv = player.getInventory();
        int slot = SkillAPI.getSettings().getCastSlot();
        ItemStack item = inv.getItem(slot);
        inv.setItem(slot, SkillAPI.getSettings().getCastItem());
        if (item != null && item.getType() != Material.AIR) {
            inv.addItem(new ItemStack[]{item});
        }
        inv.getItem(slot).setAmount(1);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        CastListener.cleanup(event.getPlayer());
    }

    @EventHandler
    public void onOpen(InventoryOpenEvent event) {
        SkillAPI.getPlayerData((OfflinePlayer)((Player)event.getPlayer())).getCastBars().handleOpen((Player)event.getPlayer());
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        SkillAPI.getPlayerData((OfflinePlayer)((Player)event.getPlayer())).getCastBars().restore((Player)event.getPlayer());
        this.init((Player)event.getPlayer());
    }

    @EventHandler
    public void onUnlock(PlayerSkillUnlockEvent event) {
        if (event.getUnlockedSkill().getData().canCast() && event.getPlayerData().getPlayer() != null) {
            event.getPlayerData().getCastBars().unlock(event.getUnlockedSkill());
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        if (SkillAPI.getSettings().isWorldEnabled(event.getWhoClicked().getWorld())) {
            if (event.getSlot() == slot && event.getSlotType() == InventoryType.SlotType.QUICKBAR) {
                event.setCancelled(true);
            } else if ((event.getAction() == InventoryAction.HOTBAR_SWAP || event.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD) && event.getHotbarButton() == slot) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        if (!SkillAPI.getSettings().isWorldEnabled(event.getPlayer().getWorld())) {
            return;
        }
        if (SkillAPI.getPlayerData((OfflinePlayer)event.getPlayer()).getCastBars().handleInteract(event.getPlayer())) {
            event.getItemDrop().remove();
        } else if (event.getPlayer().getInventory().getHeldItemSlot() == slot) {
            event.getItemDrop().remove();
            MainThread.register(new OrganizerTask(event.getPlayer()));
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (!SkillAPI.getSettings().isWorldEnabled(event.getPlayer().getWorld())) {
            return;
        }
        PlayerCastBars bars = SkillAPI.getPlayerData((OfflinePlayer)event.getPlayer()).getCastBars();
        if (bars.isHovering()) {
            event.setCancelled(true);
        } else if (event.getPlayer().getInventory().getHeldItemSlot() == slot) {
            event.setCancelled(true);
            if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) {
                bars.showHoverBar(event.getPlayer());
            } else if (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                bars.showInstantBar(event.getPlayer());
            }
        }
    }

    @EventHandler
    public void onHeld(PlayerItemHeldEvent event) {
        SkillAPI.getPlayerData((OfflinePlayer)event.getPlayer()).getCastBars().handle(event);
    }

    private void handleClear(Player player) {
        player.getInventory().setItem(slot, SkillAPI.getSettings().getCastItem());
    }

    private class OrganizerTask
    extends ThreadTask {
        private final Player player;

        public OrganizerTask(Player player) {
            this.player = player;
        }

        @Override
        public void run() {
            SkillAPI.getPlayerData((OfflinePlayer)this.player).getCastBars().showOrganizer(this.player);
        }
    }
}

