/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.listener;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.event.PlayerCastSkillEvent;
import com.sucy.skill.api.event.PlayerExperienceGainEvent;
import com.sucy.skill.api.player.PlayerClass;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.hook.PluginChecker;
import com.sucy.skill.hook.WorldGuardHook;
import com.sucy.skill.listener.ListenerUtil;
import com.sucy.skill.listener.SkillAPIListener;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;

public class AddonListener
extends SkillAPIListener {
    private static final Set<UUID> IGNORE_CASTING = new HashSet<UUID>();

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerHit(EntityDamageByEntityEvent event) {
        if (!SkillAPI.getSettings().isWorldEnabled(event.getEntity().getWorld())) {
            return;
        }
        LivingEntity damager = ListenerUtil.getDamager(event);
        if (event.getEntity() instanceof Player && damager instanceof Player) {
            PlayerData attackerData = SkillAPI.getPlayerData((OfflinePlayer)((Player)damager));
            PlayerData defenderData = SkillAPI.getPlayerData((OfflinePlayer)((Player)event.getEntity()));
            for (String group : SkillAPI.getGroups()) {
                boolean friendly = SkillAPI.getSettings().getGroupSettings(group).isFriendly();
                PlayerClass attacker = attackerData.getClass(group);
                PlayerClass defender = defenderData.getClass(group);
                if (!friendly || attacker == null || defender == null || attacker.getData().getRoot() != defender.getData().getRoot()) continue;
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onChangeWorld(PlayerChangedWorldEvent e) {
        this.startIgnoring(e.getPlayer());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        this.startIgnoring(e.getPlayer());
    }

    private void startIgnoring(Player player) {
        if (!SkillAPI.getSettings().isWorldEnabled(player.getWorld())) {
            return;
        }
        UUID uuid = player.getUniqueId();
        IGNORE_CASTING.add(uuid);
        SkillAPI.schedule(() -> IGNORE_CASTING.remove(uuid), 40);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onSkillUse(PlayerCastSkillEvent e) {
        if (IGNORE_CASTING.contains(e.getPlayer().getUniqueId())) {
            e.setCancelled(true);
        } else if (PluginChecker.isWorldGuardActive() && WorldGuardHook.getRegionIds(e.getPlayer().getLocation()).stream().anyMatch(id -> SkillAPI.getSettings().areSkillsDisabledForRegion((String)id))) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onExpGain(PlayerExperienceGainEvent e) {
        if (PluginChecker.isWorldGuardActive() && WorldGuardHook.getRegionIds(e.getPlayerData().getPlayer().getLocation()).stream().anyMatch(id -> SkillAPI.getSettings().isExpDisabledForRegion((String)id))) {
            e.setCancelled(true);
        }
    }
}

