/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.gui.tool;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.gui.tool.GUIData;
import com.sucy.skill.gui.tool.GUITool;
import com.sucy.skill.gui.tool.IconHolder;
import com.sucy.skill.hook.PlaceholderAPIHook;
import com.sucy.skill.hook.PluginChecker;
import java.util.HashMap;
import java.util.Map;
import mc.promcteam.engine.mccore.config.parse.DataSection;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GUIPage {
    private final HashMap<String, Integer> slots = new HashMap();
    private final HashMap<Integer, String> lookup = new HashMap();
    private final GUIData parent;

    GUIPage(GUIData parent) {
        this.parent = parent;
    }

    GUIPage(GUIData parent, Map<Integer, Skill> skillSlots) {
        this.parent = parent;
        for (Map.Entry<Integer, Skill> entry : skillSlots.entrySet()) {
            this.slots.put(entry.getValue().getName().toLowerCase(), entry.getKey());
            this.lookup.put(entry.getKey(), entry.getValue().getName().toLowerCase());
        }
    }

    GUIPage(GUIData parent, DataSection data) {
        this(parent);
        for (String key : data.keys()) {
            this.slots.put(key, data.getInt(key));
            this.lookup.put(data.getInt(key), key);
        }
    }

    public String get(int index) {
        return this.lookup.get(index);
    }

    public void set(int index, String value) {
        this.slots.put(value, index);
        this.lookup.put(index, value);
    }

    public int getIndex(String item) {
        if (!this.slots.containsKey(item = item.toLowerCase())) {
            return -1;
        }
        return this.slots.get(item);
    }

    public void fill(ItemStack[] data) {
        for (Map.Entry<String, Integer> entry : this.slots.entrySet()) {
            data[entry.getValue().intValue()] = this.make(entry.getKey());
        }
    }

    public void clearRight() {
        for (int i = 8; i < 54; i += 9) {
            if (!this.lookup.containsKey(i)) continue;
            this.slots.remove(this.lookup.remove(i));
        }
    }

    public void remove(int min, int max) {
        for (int i = min; i < max; ++i) {
            if (!this.lookup.containsKey(i)) continue;
            this.slots.remove(this.lookup.remove(i));
        }
    }

    private ItemStack make(String key) {
        ItemStack item = SkillAPI.isSkillRegistered(key) ? SkillAPI.getSkill(key).getToolIndicator() : (SkillAPI.isClassRegistered(key) ? SkillAPI.getClass(key).getToolIcon() : GUITool.getIcon(key));
        return item;
    }

    public void load(ItemStack[] data) {
        this.slots.clear();
        this.lookup.clear();
        for (int i = 0; i < data.length; ++i) {
            String key;
            ItemStack item = data[i];
            if (item == null || (key = ChatColor.stripColor((String)data[i].getItemMeta().getDisplayName()).toLowerCase()).equals("next page") || key.equals("prev page")) continue;
            this.slots.put(key.toLowerCase(), i);
            this.lookup.put(i, key.toLowerCase());
        }
    }

    public ItemStack[] instance(PlayerData player, HashMap<String, ? extends IconHolder> data) {
        ItemStack[] contents = new ItemStack[this.parent.getSize()];
        Player bukkitPlayer = player.getPlayer();
        for (Map.Entry<Integer, String> entry : this.lookup.entrySet()) {
            ItemStack item;
            IconHolder holder = data.get(entry.getValue());
            ItemStack itemStack = item = holder != null && holder.isAllowed(bukkitPlayer) ? holder.getIcon(player) : GUITool.getIcon(entry.getValue());
            if (item == null) {
                SkillAPI.inst().getLogger().warning("Could not find GUI item for " + entry.getValue() + ". Please either remove it from the GUI or add it to the config.");
                continue;
            }
            if (PluginChecker.isPlaceholderAPIActive()) {
                PlaceholderAPIHook.processPlaceholders(item, bukkitPlayer);
            }
            contents[entry.getKey().intValue()] = item;
        }
        return contents;
    }

    public void save(DataSection data) {
        for (Map.Entry<String, Integer> entry : this.slots.entrySet()) {
            data.set(entry.getKey(), (Object)entry.getValue());
        }
    }

    public boolean isValid() {
        return this.slots.size() > 0;
    }
}

