/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.gui.map;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerSkill;
import com.sucy.skill.gui.map.SkillListMenu;
import java.util.List;
import mc.promcteam.engine.mccore.gui.MapBuffer;
import mc.promcteam.engine.mccore.gui.MapFont;
import mc.promcteam.engine.mccore.gui.MapImage;
import mc.promcteam.engine.mccore.gui.MapMenu;
import mc.promcteam.engine.mccore.gui.MapMenuManager;
import mc.promcteam.engine.mccore.gui.MapObject;
import mc.promcteam.engine.mccore.gui.MapScene;
import mc.promcteam.engine.mccore.gui.MapScheme;
import mc.promcteam.engine.mccore.gui.MapString;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class SkillDetailMenu
extends MapMenu {
    private static final String BACKGROUND = "background";
    private static final String DETAIL = "detail";
    private static final String BACK_ON = "back1";
    private static final String UP_ON = "up1";
    private static final String DOWN_ON = "down1";
    private static final String MORE_ON = "more1";
    private static final String BACK_OFF = "back0";
    private static final String UP_OFF = "up0";
    private static final String DOWN_OFF = "down0";
    private static final String MORE_OFF = "more0";
    private SkillAPI api;

    public SkillDetailMenu(SkillAPI api) {
        this.api = api;
    }

    private int getButton(Player player) {
        return SkillDetailMenu.getSelection((Player)player) & 0xFF;
    }

    private int getPage(Player player) {
        return SkillDetailMenu.getSelection((Player)player) >> 8 & 0xFF;
    }

    private int getPages(Player player) {
        return SkillDetailMenu.getSelection((Player)player) >> 16;
    }

    private void setButton(Player player, int button) {
        this.setSelection(player, button, this.getPage(player), this.getPages(player));
    }

    private void setPage(Player player, int page) {
        this.setSelection(player, this.getButton(player), page, this.getPages(player));
    }

    private void setPages(Player player, int pages) {
        this.setSelection(player, this.getButton(player), this.getPage(player), pages);
    }

    private void setSelection(Player player, int button, int page, int pages) {
        SkillDetailMenu.setSelection((Player)player, (int)(button | page << 8 | pages << 16));
    }

    public void onLeft(Player player) {
        int button = this.getButton(player);
        button = Math.max(0, button - 1);
        boolean down = SkillAPI.getSettings().isAllowDowngrade();
        if (button == 2 && !down) {
            --button;
        }
        this.setButton(player, button);
    }

    public void onRight(Player player) {
        int button = this.getButton(player);
        int page = this.getPage(player);
        button = Math.min(3, button + 1);
        boolean down = SkillAPI.getSettings().isAllowDowngrade();
        if (button == 2 && !down) {
            ++button;
        }
        this.setButton(player, button);
    }

    public void onUp(Player player) {
        SkillAPI.getPlayerData((OfflinePlayer)player).upgradeSkill(SkillListMenu.getSkill(player).getData());
    }

    public void onDown(Player player) {
        if (!SkillAPI.getSettings().isAllowDowngrade()) {
            return;
        }
        SkillAPI.getPlayerData((OfflinePlayer)player).downgradeSkill(SkillListMenu.getSkill(player).getData());
    }

    public void onSelect(Player player) {
        int button = this.getButton(player);
        int page = this.getPage(player);
        if (button == 0) {
            MapMenuManager.sendBack((Player)player);
        } else if (button == 1) {
            SkillAPI.getPlayerData((OfflinePlayer)player).upgradeSkill(SkillListMenu.getSkill(player).getData());
        } else if (button == 2) {
            if (SkillAPI.getSettings().isAllowDowngrade()) {
                SkillAPI.getPlayerData((OfflinePlayer)player).downgradeSkill(SkillListMenu.getSkill(player).getData());
            }
        } else {
            page = (page + 1) % this.getPages(player);
            this.setPage(player, page);
            this.setup(player);
        }
    }

    public void setup(Player player) {
        int start;
        MapScheme scheme = MapScheme.get((JavaPlugin)this.api, (String)SkillAPI.getPlayerData((OfflinePlayer)player).getScheme());
        MapScene scene = SkillDetailMenu.getScene((Player)player);
        int page = this.getPage(player);
        scene.add(BACKGROUND, new MapObject(scheme.getImage(BACKGROUND), 0, 0));
        PlayerSkill skill = SkillListMenu.getSkill(player);
        ItemStack icon = skill.getData().getIndicator(skill, true);
        List lore = icon.getItemMeta().getLore();
        lore.add(0, icon.getItemMeta().getDisplayName());
        MapFont font = scheme.getFont(DETAIL);
        int linesPerPage = 90 / (font.getFont().getSize() + 3);
        int pages = (lore.size() + linesPerPage - 1) / linesPerPage;
        int y = font.getFont().getSize() + 5;
        for (int i = start = linesPerPage * page; i < start + linesPerPage && i < lore.size(); ++i) {
            String line = (String)lore.get(i);
            scene.add(DETAIL + i, new MapObject((MapImage)new MapString(font, scheme.getColor("font"), line), 7, y));
            y += font.getFont().getSize() + 3;
        }
        boolean down = SkillAPI.getSettings().isAllowDowngrade();
        int x = down ? 42 : 56;
        scene.add(BACK_ON, new MapObject(scheme.getImage(BACK_ON), 6, 95));
        scene.add(BACK_OFF, new MapObject(scheme.getImage(BACK_OFF), 6, 95));
        scene.add(UP_ON, new MapObject(scheme.getImage(UP_ON), x, 95));
        scene.add(UP_OFF, new MapObject(scheme.getImage(UP_OFF), x, 95));
        scene.add(DOWN_ON, new MapObject(scheme.getImage(DOWN_ON), 68, 95));
        scene.add(DOWN_OFF, new MapObject(scheme.getImage(DOWN_OFF), 68, 95));
        scene.add(MORE_ON, new MapObject(scheme.getImage(MORE_ON), 90, 95));
        scene.add(MORE_OFF, new MapObject(scheme.getImage(MORE_OFF), 90, 95));
        this.setPages(player, pages);
    }

    public void render(MapBuffer mapBuffer, Player player) {
        int button = this.getButton(player);
        MapScene scene = SkillDetailMenu.getScene((Player)player);
        scene.get(BACK_ON).setVisible(button == 0);
        scene.get(BACK_OFF).setVisible(button != 0);
        scene.get(UP_ON).setVisible(button == 1);
        scene.get(UP_OFF).setVisible(button != 1);
        scene.get(DOWN_ON).setVisible(button == 2);
        scene.get(DOWN_OFF).setVisible(button != 2);
        scene.get(MORE_ON).setVisible(button == 3);
        scene.get(MORE_OFF).setVisible(button != 3);
        scene.apply(mapBuffer);
    }
}

