/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.trigger;

import com.sucy.skill.api.Settings;
import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.dynamic.trigger.Trigger;
import java.util.Map;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDamageEvent;

public class EnvironmentalTrigger
implements Trigger<EntityDamageEvent> {
    @Override
    public String getKey() {
        return "ENVIRONMENT_DAMAGE";
    }

    @Override
    public Class<EntityDamageEvent> getEvent() {
        return EntityDamageEvent.class;
    }

    @Override
    public boolean shouldTrigger(EntityDamageEvent event, int level, Settings settings) {
        String type = settings.getString("type", "any").replace(' ', '_').toUpperCase();
        return type.equalsIgnoreCase("ANY") || type.equalsIgnoreCase(event.getCause().name());
    }

    @Override
    public void setValues(EntityDamageEvent event, Map<String, Object> data) {
        data.put("api-taken", event.getDamage());
    }

    @Override
    public LivingEntity getCaster(EntityDamageEvent event) {
        if (event.getEntity() instanceof LivingEntity) {
            return (LivingEntity)event.getEntity();
        }
        return null;
    }

    @Override
    public LivingEntity getTarget(EntityDamageEvent event, Settings settings) {
        return this.getCaster(event);
    }

    @Override
    public void postProcess(EntityDamageEvent event, DynamicSkill skill) {
        double damage = skill.applyImmediateBuff(event.getDamage());
        event.setDamage(damage);
    }
}

