/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.target;

import com.google.common.collect.ImmutableList;
import com.sucy.skill.api.target.TargetHelper;
import com.sucy.skill.cast.ConePreview;
import com.sucy.skill.cast.PreviewSettings;
import com.sucy.skill.dynamic.target.TargetComponent;
import java.util.List;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class SingleTarget
extends TargetComponent {
    private static final String RANGE = "range";
    private static final String TOLERANCE = "tolerance";
    private ConePreview preview;

    @Override
    public void playPreview(Player caster, int level, LivingEntity target, int step) {
        double arc = this.parseValues((LivingEntity)caster, TOLERANCE, level, 4.0) * Math.PI / 180.0;
        double radius = this.parseValues((LivingEntity)caster, RANGE, level, 3.0);
        if (this.preview == null || this.preview.getArc() != arc || this.preview.getRadius() != radius) {
            this.preview = new ConePreview(arc, radius);
        }
        this.preview.playParticles(caster, PreviewSettings.particle, target.getLocation(), step);
    }

    @Override
    List<LivingEntity> getTargets(LivingEntity caster, int level, List<LivingEntity> targets) {
        double range = this.parseValues(caster, RANGE, level, 5.0);
        double tolerance = this.parseValues(caster, TOLERANCE, level, 4.0);
        return this.determineTargets(caster, level, targets, t -> {
            LivingEntity target = TargetHelper.getLivingTarget(t, range, tolerance);
            return target == null ? ImmutableList.of() : ImmutableList.of((Object)target);
        });
    }

    @Override
    public String getKey() {
        return "single";
    }
}

