/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.api.event.SkillPushEvent;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import com.sucy.skill.dynamic.target.RememberTarget;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class PushMechanic
extends MechanicComponent {
    private static final String SPEED = "speed";
    private static final String SOURCE = "source";

    @Override
    public String getKey() {
        return "push";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.size() == 0) {
            return false;
        }
        double speed = this.parseValues(caster, SPEED, level, 3.0);
        String type = this.settings.getString("type", "scaled").toLowerCase();
        List<LivingEntity> sources = RememberTarget.remember(caster, this.settings.getString(SOURCE, "_none"));
        Location center = sources.isEmpty() ? caster.getLocation() : sources.get(0).getLocation();
        boolean worked = false;
        for (LivingEntity target : targets) {
            Vector vel = target.getLocation().subtract(center).toVector();
            if (vel.lengthSquared() == 0.0) continue;
            if (type.equals("inverse")) {
                vel.multiply(speed);
            } else if (type.equals("fixed")) {
                vel.multiply(speed / vel.length());
            } else {
                vel.multiply(speed / vel.lengthSquared());
            }
            vel.setY(vel.getY() / 5.0 + 0.5);
            SkillPushEvent event = new SkillPushEvent(caster, target, vel);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                target.setVelocity(event.getVelocity());
            }
            worked = true;
        }
        return worked;
    }
}

