/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.List;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionMechanic
extends MechanicComponent {
    private static final String POTION = "potion";
    private static final String AMBIENT = "ambient";
    private static final String TIER = "tier";
    private static final String SECONDS = "seconds";

    @Override
    public String getKey() {
        return POTION;
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.size() == 0) {
            return false;
        }
        try {
            PotionEffectType potion = PotionEffectType.getByName((String)this.settings.getString(POTION, "Absorption").toUpperCase().replace(' ', '_'));
            int tier = (int)this.parseValues(caster, TIER, level, 1.0) - 1;
            double seconds = this.parseValues(caster, SECONDS, level, 3.0);
            boolean ambient = this.settings.getBool(AMBIENT, true);
            int ticks = (int)(seconds * 20.0);
            for (LivingEntity target : targets) {
                target.addPotionEffect(new PotionEffect(potion, ticks, tier, ambient, ambient));
            }
            return targets.size() > 0;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

