/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.particle.EffectPlayer;
import com.sucy.skill.api.particle.target.FollowTarget;
import com.sucy.skill.api.projectile.CustomProjectile;
import com.sucy.skill.api.projectile.ItemProjectile;
import com.sucy.skill.api.projectile.ProjectileCallback;
import com.sucy.skill.api.util.ItemStackReader;
import com.sucy.skill.cast.CirclePreview;
import com.sucy.skill.cast.CylinderPreview;
import com.sucy.skill.cast.Preview;
import com.sucy.skill.cast.PreviewSettings;
import com.sucy.skill.cast.PreviewType;
import com.sucy.skill.cast.ProjectilePreview;
import com.sucy.skill.dynamic.TempEntity;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ItemProjectileMechanic
extends MechanicComponent
implements ProjectileCallback {
    private static final Vector UP = new Vector(0, 1, 0);
    private static final String ALLY = "group";
    private static final String WALLS = "walls";
    private static final String VELOCITY = "velocity";
    private static final String LIFESPAN = "lifespan";
    private static final String SPREAD = "spread";
    private static final String AMOUNT = "amount";
    private static final String ANGLE = "angle";
    private static final String HEIGHT = "height";
    private static final String RADIUS = "rain-radius";
    private static final String LEVEL = "skill_level";
    private static final String FORWARD = "forward";
    private static final String UPWARD = "upward";
    private static final String RIGHT = "right";
    private static final String USE_EFFECT = "use-effect";
    private static final String EFFECT_KEY = "effect-key";
    private Preview preview;

    @Override
    public void playPreview(Player caster, int level, List<LivingEntity> targets, int step) {
        double speed = this.parseValues((LivingEntity)caster, VELOCITY, level, 1.0);
        String spread = this.settings.getString(SPREAD, "cone").toLowerCase();
        double radius = this.parseValues((LivingEntity)caster, RADIUS, level, 2.0);
        if (spread.equals("rain")) {
            if (this.previewType == PreviewType.DIM_2) {
                CirclePreview circlePreview = (CirclePreview)this.preview;
                if (this.preview == null || circlePreview.getRadius() != radius) {
                    this.preview = new CirclePreview(radius);
                }
            } else {
                CylinderPreview cylinderPreview = (CylinderPreview)this.preview;
                double height = this.parseValues((LivingEntity)caster, HEIGHT, level, 8.0);
                if (this.preview == null || cylinderPreview.getRadius() != radius || cylinderPreview.getHeight() != height) {
                    this.preview = new CylinderPreview(radius, height);
                }
            }
            targets.forEach(target -> this.preview.playParticles(caster, PreviewSettings.particle, target.getLocation().add(0.0, 0.1, 0.0), step));
        } else {
            int amount = (int)this.parseValues((LivingEntity)caster, AMOUNT, level, 1.0);
            ProjectilePreview projectilePreview = (ProjectilePreview)this.preview;
            if (this.preview == null || projectilePreview.getSpeed() != speed) {
                this.preview = new ProjectilePreview(speed, 0.0);
            }
            targets.forEach(target -> {
                Location location = target.getEyeLocation();
                if (spread.equals("horizontal cone")) {
                    location.setDirection(location.getDirection().setY(0).normalize());
                }
                double angle = this.parseValues((LivingEntity)caster, ANGLE, level, 30.0);
                ArrayList<Vector> dirs = CustomProjectile.calcSpread(location.getDirection(), angle, amount);
                for (Vector d : dirs) {
                    Location spreadLocation = location.clone();
                    spreadLocation.setDirection(d);
                    this.preview.playParticles(caster, PreviewSettings.particle, spreadLocation, step);
                }
            });
        }
    }

    @Override
    public String getKey() {
        return "item projectile";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        ItemStack item = ItemStackReader.read(this.settings);
        double speed = this.parseValues(caster, VELOCITY, level, 3.0);
        int amount = (int)this.parseValues(caster, AMOUNT, level, 1.0);
        String spread = this.settings.getString(SPREAD, "cone").toLowerCase();
        boolean ally = this.settings.getString(ALLY, "enemy").equalsIgnoreCase("ally");
        boolean walls = this.settings.getBool(WALLS, false);
        int lifespan = (int)(this.parseValues(caster, LIFESPAN, level, 9999.0) * 20.0);
        for (LivingEntity target : targets) {
            ArrayList<ItemProjectile> list;
            Location loc = target.getLocation();
            if (spread.equals("rain")) {
                double radius = this.parseValues(caster, RADIUS, level, 2.0);
                double d = this.parseValues(caster, HEIGHT, level, 8.0);
                list = ItemProjectile.rain(caster, loc, item, radius, d, speed, amount, this, lifespan, walls);
            } else {
                Vector dir = target.getLocation().getDirection();
                double right = this.parseValues(caster, RIGHT, level, 0.0);
                double upward = this.parseValues(caster, UPWARD, level, 0.0);
                double forward = this.parseValues(caster, FORWARD, level, 0.0);
                Vector looking = dir.clone().setY(0).normalize();
                Vector normal = looking.clone().crossProduct(UP);
                looking.multiply(forward).add(normal.multiply(right));
                if (spread.equals("horizontal cone")) {
                    dir.setY(0);
                    dir.normalize();
                }
                dir.multiply(speed);
                double angle = this.parseValues(caster, ANGLE, level, 30.0);
                list = ItemProjectile.spread(caster, dir, loc.add(looking).add(0.0, 0.5 + upward, 0.0), item, angle, amount, this, lifespan, walls);
            }
            for (ItemProjectile p : list) {
                SkillAPI.setMeta(p, LEVEL, level);
                p.setAllyEnemy(ally, !ally);
            }
            if (!this.settings.getBool(USE_EFFECT, false)) continue;
            EffectPlayer player = new EffectPlayer(this.settings);
            for (CustomProjectile customProjectile : list) {
                player.start(new FollowTarget(customProjectile), this.settings.getString(EFFECT_KEY, this.skill.getName()), 9999, level, true);
            }
        }
        return targets.size() > 0;
    }

    @Override
    public void callback(CustomProjectile projectile, LivingEntity hit) {
        if (hit == null) {
            hit = new TempEntity(projectile.getLocation());
        }
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
        targets.add(hit);
        this.executeChildren(projectile.getShooter(), SkillAPI.getMetaInt(projectile, LEVEL), targets, this.skill.isForced(projectile.getShooter()));
        projectile.setCallback(null);
    }
}

