/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mc.promcteam.engine.mccore.config.parse.NumberParser;
import mc.promcteam.engine.mccore.util.VersionManager;
import org.bukkit.ChatColor;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;

public class DamageLoreMechanic
extends MechanicComponent {
    private static final String REGEX = "regex";
    private static final String MULTIPLIER = "multiplier";
    private static final String HAND = "hand";
    private static final String TRUE = "true";
    private static final String CLASSIFIER = "classifier";
    private static final String KNOCKBACK = "knockback";
    private static final String CAUSE = "cause";

    @Override
    public String getKey() {
        return "damage lore";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        String regex = this.settings.getString(REGEX, "Damage: {value}");
        regex = regex.replace("{value}", "([0-9]+)");
        Pattern pattern = Pattern.compile(regex);
        double m = this.parseValues(caster, MULTIPLIER, level, 1.0);
        boolean worked = false;
        boolean offhand = VersionManager.isVersionAtLeast((int)VersionManager.V1_9_0) && this.settings.getString(HAND).equalsIgnoreCase("offhand");
        boolean trueDmg = this.settings.getBool(TRUE, false);
        String classification = this.settings.getString(CLASSIFIER, "default");
        if (caster.getEquipment() == null) {
            return false;
        }
        ItemStack hand = offhand ? caster.getEquipment().getItemInOffHand() : caster.getEquipment().getItemInMainHand();
        if (hand == null || !hand.hasItemMeta() || !hand.getItemMeta().hasLore()) {
            return false;
        }
        List lore = hand.getItemMeta().getLore();
        for (String line : lore) {
            Matcher matcher = pattern.matcher(line = ChatColor.stripColor((String)line));
            if (!matcher.find()) continue;
            String value = matcher.group(1);
            try {
                double base = NumberParser.parseDouble((String)value);
                if (!(base * m > 0.0)) continue;
                for (LivingEntity target : targets) {
                    if (target.isDead()) continue;
                    if (trueDmg) {
                        this.skill.trueDamage(target, base * m, caster);
                        continue;
                    }
                    this.skill.damage(target, base * m, caster, classification, this.settings.getBool(KNOCKBACK, true), EntityDamageEvent.DamageCause.valueOf((String)this.settings.getString(CAUSE, "Entity Attack").toUpperCase().replace(' ', '_')));
                }
                worked = targets.size() > 0;
                break;
            }
            catch (Exception exception) {
            }
        }
        return worked;
    }
}

