/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.LivingEntity;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class BlockMechanic
extends MechanicComponent {
    private static final Vector UP = new Vector(0, 1, 0);
    private static final String SHAPE = "shape";
    private static final String TYPE = "type";
    private static final String RADIUS = "radius";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String DEPTH = "depth";
    private static final String BLOCK = "block";
    private static final String DATA = "data";
    private static final String SECONDS = "seconds";
    private static final String FORWARD = "forward";
    private static final String UPWARD = "upward";
    private static final String RIGHT = "right";
    private static final String RESET_YAW = "reset-yaw";
    private static final HashMap<Location, Integer> pending = new HashMap();
    private static final HashMap<Location, BlockState> original = new HashMap();
    private final Map<Integer, List<RevertTask>> tasks = new HashMap<Integer, List<RevertTask>>();

    public static boolean isPending(Location loc) {
        return pending.containsKey(loc);
    }

    @Override
    public String getKey() {
        return BLOCK;
    }

    @Override
    protected void doCleanUp(LivingEntity caster) {
        List<RevertTask> casterTasks = this.tasks.remove(caster.getEntityId());
        if (casterTasks != null) {
            casterTasks.forEach(task -> {
                task.revert();
                task.cancel();
            });
        }
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.size() == 0) {
            return false;
        }
        Material block = Material.ICE;
        try {
            block = Material.valueOf((String)this.settings.getString(BLOCK, "ICE").toUpperCase().replace(' ', '_'));
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean sphere = this.settings.getString(SHAPE, "sphere").equalsIgnoreCase("sphere");
        int ticks = (int)(20.0 * this.parseValues(caster, SECONDS, level, 5.0));
        byte data = (byte)this.settings.getInt(DATA, 0);
        String type = this.settings.getString(TYPE, "solid").toLowerCase();
        boolean solid = type.equals("solid");
        boolean air = type.equals("air");
        Material matType = !solid && !air && !type.equals("any") ? Material.valueOf((String)type.toUpperCase().replace(' ', '_')) : null;
        boolean resetYaw = this.settings.getBool(RESET_YAW, false);
        double forward = this.parseValues(caster, FORWARD, level, 0.0);
        double upward = this.parseValues(caster, UPWARD, level, 0.0);
        double right = this.parseValues(caster, RIGHT, level, 0.0);
        ArrayList<Block> blocks = new ArrayList<Block>();
        World w = caster.getWorld();
        if (sphere) {
            double radius = this.parseValues(caster, RADIUS, level, 3.0);
            double rSq = radius * radius;
            for (LivingEntity t : targets) {
                Location loc = t.getLocation();
                Location dirLoc = t.getLocation().clone();
                if (resetYaw) {
                    dirLoc.setYaw(0.0f);
                }
                Vector dir = dirLoc.getDirection().setY(0).normalize();
                Vector nor = dir.clone().crossProduct(UP);
                loc.add(dir.multiply(forward).add(nor.multiply(right)));
                loc.add(0.0, upward, 0.0);
                double x = loc.getBlockX();
                double y = loc.getBlockY();
                double z = loc.getBlockZ();
                for (int i = (int)(x - radius) + 1; i < (int)(x + radius); ++i) {
                    for (int j = (int)(y - radius) + 1; j < (int)(y + radius); ++j) {
                        for (int k = (int)(z - radius) + 1; k < (int)(z + radius); ++k) {
                            double dx = x - (double)i;
                            double dy = y - (double)j;
                            double dz = z - (double)k;
                            if (!(dx * dx + dy * dy + dz * dz < rSq)) continue;
                            Block b = w.getBlockAt(i, j, k);
                            if (matType != null && matType != b.getType() || solid && !b.getType().isSolid() || air && !b.getType().isAir() || SkillAPI.getSettings().getFilteredBlocks().contains(b.getType())) continue;
                            blocks.add(b);
                        }
                    }
                }
            }
        } else {
            double width = (this.parseValues(caster, WIDTH, level, 5.0) - 1.0) / 2.0;
            double height = (this.parseValues(caster, HEIGHT, level, 5.0) - 1.0) / 2.0;
            double depth = (this.parseValues(caster, DEPTH, level, 5.0) - 1.0) / 2.0;
            for (LivingEntity t : targets) {
                boolean facingZ;
                Location loc = t.getLocation();
                Location dirLoc = t.getLocation().clone();
                if (resetYaw) {
                    dirLoc.setYaw(0.0f);
                }
                Vector dir = dirLoc.getDirection().setY(0).normalize();
                Vector nor = dir.clone().crossProduct(UP);
                loc.add(dir.multiply(forward).add(nor.multiply(right)));
                loc.add(0.0, upward, 0.0);
                double x = loc.getX();
                double y = loc.getY();
                double z = loc.getZ();
                double yaw = loc.getYaw();
                boolean bl = facingZ = Math.abs(yaw) < 45.0 || Math.abs(yaw) > 135.0;
                if (!resetYaw) {
                    x = facingZ ? loc.getX() : loc.getZ();
                    z = facingZ ? loc.getZ() : loc.getX();
                }
                for (double i = x - width; i <= x + width + 0.01; i += 1.0) {
                    for (double j = y - height; j <= y + height + 0.01; j += 1.0) {
                        for (double k = z - depth; k <= z + depth + 0.01; k += 1.0) {
                            int blockX = (int)Math.floor(resetYaw || facingZ ? i : k);
                            int blockY = (int)Math.floor(j);
                            int blockZ = (int)Math.floor(resetYaw || facingZ ? k : i);
                            Block b = w.getBlockAt(blockX, blockY, blockZ);
                            if (solid && !b.getType().isSolid() || air && !b.getType().isAir() || SkillAPI.getSettings().getFilteredBlocks().contains(b.getType())) continue;
                            blocks.add(b);
                        }
                    }
                }
            }
        }
        ArrayList<Location> states = new ArrayList<Location>();
        for (Block b : blocks) {
            Location loc = b.getLocation();
            if (pending.containsKey(loc)) {
                pending.put(loc, pending.get(loc) + 1);
            } else {
                pending.put(loc, 1);
                original.put(loc, b.getState());
            }
            states.add(b.getLocation());
            BlockState state = b.getState();
            state.setType(block);
            if (data > 0) {
                state.setData(new MaterialData(block, data));
            }
            state.update(true, false);
        }
        RevertTask task = new RevertTask(caster, states);
        task.runTaskLater((Plugin)SkillAPI.inst(), ticks);
        this.tasks.computeIfAbsent(caster.getEntityId(), ArrayList::new).add(task);
        return true;
    }

    private class RevertTask
    extends BukkitRunnable {
        private final ArrayList<Location> locs;
        private final LivingEntity caster;

        RevertTask(LivingEntity caster, ArrayList<Location> locs) {
            this.caster = caster;
            this.locs = locs;
        }

        public void run() {
            this.revert();
            BlockMechanic.this.tasks.get(this.caster.getEntityId()).remove((Object)this);
        }

        private void revert() {
            for (Location loc : this.locs) {
                int count = pending.remove(loc);
                if (count == 1) {
                    original.remove(loc).update(true, false);
                    continue;
                }
                pending.put(loc, count - 1);
            }
        }
    }
}

