/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.condition;

import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.dynamic.condition.ConditionComponent;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import mc.promcteam.engine.mccore.config.parse.DataSection;
import org.bukkit.entity.LivingEntity;

public class MountedCondition
extends ConditionComponent {
    private static final String TYPE = "types";
    private Set<String> types;

    @Override
    public String getKey() {
        return "mounted";
    }

    @Override
    public void load(DynamicSkill skill, DataSection config) {
        super.load(skill, config);
        this.types = this.settings.getStringList(TYPE).stream().map(s -> s.toUpperCase().replace(' ', '_')).collect(Collectors.toSet());
    }

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        Set passengers = target.getPassengers().stream().map(e -> e.getType().name()).collect(Collectors.toSet());
        return !passengers.isEmpty() && (this.types.isEmpty() || this.types.contains("ANY") || !Collections.disjoint(passengers, this.types));
    }
}

