/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.condition;

import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.dynamic.condition.ConditionComponent;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import mc.promcteam.engine.mccore.config.parse.DataSection;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;

public class LoreCondition
extends ConditionComponent {
    private static final String REGEX = "regex";
    private static final String STRING = "str";
    private Predicate<String> test;

    @Override
    public String getKey() {
        return "lore";
    }

    @Override
    public void load(DynamicSkill skill, DataSection config) {
        super.load(skill, config);
        boolean regex = this.settings.getString(REGEX, "false").toLowerCase().equals("true");
        String str = this.settings.getString(STRING, "");
        if (regex) {
            Pattern pattern = Pattern.compile(str);
            this.test = line -> pattern.matcher((CharSequence)line).find();
        } else {
            this.test = line -> line.contains(str);
        }
    }

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        EntityEquipment items = target.getEquipment();
        if (items == null || items.getItemInMainHand() == null || !items.getItemInMainHand().hasItemMeta()) {
            return false;
        }
        List lore = items.getItemInMainHand().getItemMeta().getLore();
        return lore != null && lore.stream().anyMatch(this.test);
    }
}

