/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic;

import com.google.common.collect.ImmutableList;
import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.skills.PassiveSkill;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.api.skills.SkillShot;
import com.sucy.skill.dynamic.ComponentRegistry;
import com.sucy.skill.dynamic.EffectComponent;
import com.sucy.skill.dynamic.TriggerHandler;
import com.sucy.skill.dynamic.trigger.TriggerComponent;
import com.sucy.skill.log.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mc.promcteam.engine.mccore.config.parse.DataSection;
import mc.promcteam.engine.mccore.util.TextFormatter;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Listener;

public class DynamicSkill
extends Skill
implements SkillShot,
PassiveSkill,
Listener {
    private static final HashMap<Integer, HashMap<String, Object>> castData = new HashMap();
    private final List<TriggerHandler> triggers = new ArrayList<TriggerHandler>();
    private final Map<String, EffectComponent> attribKeys = new HashMap<String, EffectComponent>();
    private final Map<Integer, Integer> active = new HashMap<Integer, Integer>();
    private final List<Integer> forced = new ArrayList<Integer>();
    private TriggerComponent castTrigger;
    private TriggerComponent initializeTrigger;
    private TriggerComponent cleanupTrigger;
    private boolean cancel = false;
    private double multiplier = 1.0;
    private double bonus = 0.0;

    public DynamicSkill(String name) {
        super(name, "Dynamic", Material.JACK_O_LANTERN, 1);
    }

    public static HashMap<String, Object> getCastData(LivingEntity caster) {
        if (caster == null) {
            return null;
        }
        HashMap<String, Object> map = castData.get(caster.getEntityId());
        if (map == null) {
            map = new HashMap();
            map.put("caster", caster);
            castData.put(caster.getEntityId(), map);
        }
        return map;
    }

    public static void clearCastData(LivingEntity entity) {
        castData.remove(entity.getEntityId());
    }

    @Override
    public boolean canCast() {
        return this.castTrigger != null;
    }

    public boolean isActive(LivingEntity caster) {
        return this.active.containsKey(caster.getEntityId());
    }

    public int getActiveLevel(LivingEntity caster) {
        return this.active.containsKey(caster.getEntityId()) ? this.active.get(caster.getEntityId()) : 0;
    }

    void setAttribKey(String key, EffectComponent component) {
        this.attribKeys.put(key, component);
    }

    public void cancelTrigger() {
        this.cancel = true;
    }

    void applyCancelled(Cancellable event) {
        if (this.checkCancelled()) {
            event.setCancelled(true);
        }
    }

    public boolean checkCancelled() {
        boolean result = this.cancel;
        this.cancel = false;
        return result;
    }

    public void setImmediateBuff(double value, boolean flat) {
        if (flat) {
            this.bonus = value;
        } else {
            this.multiplier = value;
        }
    }

    public double applyImmediateBuff(double damage) {
        double result = damage * this.multiplier + this.bonus;
        this.multiplier = 1.0;
        this.bonus = 0.0;
        return result;
    }

    public void registerEvents(SkillAPI plugin) {
        for (TriggerHandler triggerHandler : this.triggers) {
            triggerHandler.register(plugin);
        }
    }

    @Override
    public void update(LivingEntity user, int prevLevel, int newLevel) {
        this.active.put(user.getEntityId(), newLevel);
        for (TriggerHandler triggerHandler : this.triggers) {
            triggerHandler.init(user, newLevel);
        }
    }

    @Override
    public void initialize(LivingEntity user, int level) {
        this.trigger(user, user, level, this.initializeTrigger);
        this.active.put(user.getEntityId(), level);
        for (TriggerHandler triggerHandler : this.triggers) {
            triggerHandler.init(user, level);
        }
    }

    @Override
    public void stopEffects(LivingEntity user, int level) {
        this.active.remove(user.getEntityId());
        if (this.forced.contains(user.getEntityId())) {
            this.forced.remove((Object)user.getEntityId());
        }
        for (TriggerHandler triggerHandler : this.triggers) {
            triggerHandler.cleanup(user);
        }
        this.cleanup(user, this.castTrigger);
        this.cleanup(user, this.initializeTrigger);
        this.trigger(user, user, 1, this.cleanupTrigger);
    }

    private void cleanup(LivingEntity user, TriggerComponent component) {
        if (component != null) {
            component.cleanUp(user);
        }
    }

    public boolean isForced(LivingEntity user) {
        return this.forced.contains(user.getEntityId());
    }

    @Override
    public boolean cast(LivingEntity user, int level, boolean force) {
        if (!force && !SkillAPI.getSettings().isWorldEnabled(user.getWorld())) {
            return false;
        }
        if (force && !this.isForced(user)) {
            this.forced.add(user.getEntityId());
        }
        return this.trigger(user, user, level, this.castTrigger, force);
    }

    @Override
    public boolean cast(LivingEntity user, int level) {
        return this.cast(user, level, false);
    }

    @Override
    public void playPreview(Player player, int level, int step) {
        if (this.castTrigger != null) {
            this.castTrigger.playPreview(player, level, (List<LivingEntity>)ImmutableList.of((Object)player), level);
        }
    }

    @Override
    protected String getAttrName(String key) {
        if (key.contains(".")) {
            return TextFormatter.format((String)key.substring(key.lastIndexOf(46) + 1));
        }
        return super.getAttrName(key);
    }

    @Override
    protected Object getAttr(LivingEntity caster, String key, int level) {
        if (key.contains(".")) {
            String[] path = key.split("\\.");
            String attr = path[1].toLowerCase();
            if (this.attribKeys.containsKey(path[0]) && this.attribKeys.get((Object)path[0]).settings.has(attr)) {
                return this.format(this.attribKeys.get(path[0]).parseValues(caster, attr, level, 0.0));
            }
            return 0;
        }
        return super.getAttr(caster, key, level);
    }

    private boolean trigger(LivingEntity user, LivingEntity target, int level, TriggerComponent component) {
        return this.trigger(user, target, level, component, false);
    }

    private boolean trigger(LivingEntity user, LivingEntity target, int level, TriggerComponent component, boolean force) {
        return component != null && component.trigger(user, target, level, force);
    }

    @Override
    public void load(DataSection config) {
        super.load(config);
        DataSection triggers = config.getSection("components");
        if (triggers == null) {
            return;
        }
        for (String key : triggers.keys()) {
            String modified = key.replaceAll("-.+", "");
            try {
                DataSection settings = triggers.getSection(key);
                if (modified.equalsIgnoreCase("CAST")) {
                    this.castTrigger = this.loadComponent(settings);
                    continue;
                }
                if (modified.equalsIgnoreCase("INITIALIZE")) {
                    this.initializeTrigger = this.loadComponent(settings);
                    continue;
                }
                if (modified.equalsIgnoreCase("CLEANUP")) {
                    this.cleanupTrigger = this.loadComponent(settings);
                    continue;
                }
                this.triggers.add(new TriggerHandler(this, key, ComponentRegistry.getTrigger(modified), this.loadComponent(settings)));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Logger.invalid("Invalid trigger for the skill \"" + this.getName() + "\" - \"" + key + "\"");
            }
        }
    }

    private TriggerComponent loadComponent(DataSection data) {
        TriggerComponent component = new TriggerComponent();
        component.load(this, data);
        return component;
    }

    @Override
    public void save(DataSection config) {
        super.save(config);
        DataSection triggers = config.createSection("components");
        for (TriggerHandler triggerHandler : this.triggers) {
            triggerHandler.getComponent().save(triggers.createSection(TextFormatter.format((String)triggerHandler.getKey())));
        }
        this.save(triggers, this.castTrigger, "Cast");
        this.save(triggers, this.initializeTrigger, "Initialize");
        this.save(triggers, this.cleanupTrigger, "Cleanup");
    }

    private void save(DataSection triggers, TriggerComponent component, String key) {
        if (component != null) {
            component.save(triggers.createSection(TextFormatter.format((String)key)));
        }
    }
}

