/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.data.io;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerAccounts;
import com.sucy.skill.data.Settings;
import com.sucy.skill.data.io.IOManager;
import com.sucy.skill.log.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import mc.promcteam.engine.mccore.config.parse.DataSection;
import mc.promcteam.engine.mccore.config.parse.YAMLParser;
import mc.promcteam.engine.mccore.sql.ColumnType;
import mc.promcteam.engine.mccore.sql.direct.SQLDatabase;
import mc.promcteam.engine.mccore.sql.direct.SQLTable;
import mc.promcteam.engine.mccore.util.VersionManager;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SQLIO
extends IOManager {
    public static final String ID = "id";
    public static final String DATA = "data";
    public static final char STRING = '\u221a';

    public SQLIO(SkillAPI api) {
        super(api);
    }

    private SQLConnection openConnection() {
        SQLConnection connection = new SQLConnection();
        Settings settings = SkillAPI.getSettings();
        connection.database = new SQLDatabase((Plugin)this.api, settings.getSqlHost(), settings.getSqlPort(), settings.getSqlDatabase(), settings.getSqlUser(), settings.getSqlPass());
        connection.database.openConnection();
        connection.table = connection.database.createTable((Plugin)this.api, "players");
        connection.table.createColumn(ID, ColumnType.INCREMENT);
        connection.table.createColumn(DATA, ColumnType.TEXT);
        return connection;
    }

    @Override
    public HashMap<String, PlayerAccounts> loadAll() {
        SQLConnection connection = this.openConnection();
        HashMap<String, PlayerAccounts> result = new HashMap<String, PlayerAccounts>();
        for (Player player : VersionManager.getOnlinePlayers()) {
            result.put(player.getUniqueId().toString().toLowerCase(), this.load(connection, (OfflinePlayer)player));
        }
        connection.database.closeConnection();
        return result;
    }

    @Override
    public PlayerAccounts loadData(OfflinePlayer player) {
        if (player == null) {
            return null;
        }
        SQLConnection connection = this.openConnection();
        PlayerAccounts result = this.load(connection, player);
        connection.database.closeConnection();
        return result;
    }

    @Override
    public void saveData(PlayerAccounts data) {
        if (!data.isLoaded()) {
            return;
        }
        SQLConnection connection = this.openConnection();
        this.saveSingle(connection, data);
        connection.database.closeConnection();
    }

    @Override
    public void saveAll() {
        SQLConnection connection = this.openConnection();
        HashMap<String, PlayerAccounts> data = SkillAPI.getPlayerAccountData();
        ArrayList<String> keys = new ArrayList<String>(data.keySet());
        for (String key : keys) {
            this.saveSingle(connection, data.get(key));
        }
        connection.database.closeConnection();
    }

    private PlayerAccounts load(SQLConnection connection, OfflinePlayer player) {
        try {
            String playerKey = player.getUniqueId().toString().toLowerCase();
            DataSection file = YAMLParser.parseText((String)connection.table.createEntry(playerKey).getString(DATA), (char)'\u221a');
            return this.load(player, file);
        }
        catch (Exception ex) {
            Logger.bug("Failed to load data from the SQL Database - " + ex.getMessage());
            return null;
        }
    }

    private void saveSingle(SQLConnection connection, PlayerAccounts data) {
        DataSection file = this.save(data);
        try {
            String playerKey = data.getOfflinePlayer().getUniqueId().toString().toLowerCase();
            connection.table.createEntry(playerKey).set(DATA, file.toString('\u221a'));
        }
        catch (Exception ex) {
            Logger.bug("Failed to save data for invalid player");
        }
    }

    private class SQLConnection {
        private SQLDatabase database;
        private SQLTable table;

        private SQLConnection() {
        }
    }
}

