/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.cmd;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.classes.RPGClass;
import com.sucy.skill.api.player.PlayerClass;
import com.sucy.skill.api.player.PlayerData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mc.promcteam.engine.mccore.commands.ConfigurableCommand;
import mc.promcteam.engine.mccore.commands.IFunction;
import mc.promcteam.engine.mccore.config.CustomFilter;
import mc.promcteam.engine.mccore.util.TextFormatter;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CmdOptions
implements IFunction {
    private static final String TITLE = "title";
    private static final String CATEGORY = "category";
    private static final String OPTION = "option";
    private static final String SEPARATOR = "separator";
    private static final String END = "end";
    private static final String CANNOT_USE = "cannot-use";
    private static final String NO_OPTIONS = "no-options";
    private static final String DISABLED = "world-disabled";

    public void execute(ConfigurableCommand cmd, Plugin plugin, CommandSender sender, String[] args) {
        if (sender instanceof Player && !SkillAPI.getSettings().isWorldEnabled(((Player)sender).getWorld())) {
            cmd.sendMessage(sender, DISABLED, "&4You cannot use this command in this world", new CustomFilter[0]);
        } else if (sender instanceof Player) {
            cmd.sendMessage(sender, TITLE, ChatColor.DARK_GRAY + "--" + ChatColor.DARK_GREEN + " Profess Options " + ChatColor.DARK_GRAY + "-----------", new CustomFilter[0]);
            PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)((Player)sender));
            String categoryTemplate = cmd.getMessage(CATEGORY, ChatColor.GOLD + "{category}" + ChatColor.GRAY + ": ", new CustomFilter[0]);
            String optionTemplate = cmd.getMessage(OPTION, ChatColor.LIGHT_PURPLE + "{option}" + ChatColor.GRAY, new CustomFilter[0]);
            String separator = cmd.getMessage(SEPARATOR, ChatColor.DARK_GRAY + "----------------------------", new CustomFilter[0]);
            String none = cmd.getMessage(NO_OPTIONS, ChatColor.GRAY + "None", new CustomFilter[0]);
            boolean first = true;
            if (data != null) {
                List<RPGClass> options;
                HashMap groupList = new HashMap();
                for (String string : SkillAPI.getGroups()) {
                    PlayerClass c = data.getClass(string);
                    options = c != null ? c.getData().getOptions() : SkillAPI.getBaseClasses(string);
                    for (RPGClass option : options) {
                        String gp = option.getGroup().toLowerCase();
                        if (!groupList.containsKey(gp)) {
                            groupList.put(gp, new ArrayList());
                        }
                        String entry = optionTemplate.replace("{option}", option.getName());
                        if (((List)groupList.get(gp)).contains(entry)) continue;
                        ((List)groupList.get(gp)).add(entry);
                    }
                }
                for (Map.Entry entry : groupList.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        sender.sendMessage(separator);
                    }
                    String group = (String)entry.getKey();
                    options = (List)entry.getValue();
                    StringBuilder list = new StringBuilder();
                    list.append(categoryTemplate.replace("{category}", TextFormatter.format((String)group)));
                    if (options.size() > 0) {
                        list.append(String.join((CharSequence)", ", options));
                    } else {
                        list.append(none);
                    }
                    sender.sendMessage(list.toString());
                }
            }
            cmd.sendMessage(sender, END, ChatColor.DARK_GRAY + "----------------------------", new CustomFilter[0]);
        } else {
            cmd.sendMessage(sender, CANNOT_USE, ChatColor.RED + "This cannot be used by the console", new CustomFilter[0]);
        }
    }
}

