/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.cast;

import com.sucy.skill.api.particle.ParticleSettings;
import com.sucy.skill.cast.PreviewSettings;
import com.sucy.skill.cast.RoundPreview;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class SpherePreview
extends RoundPreview {
    private static final double COS_45 = Math.cos(0.7853981633974483);
    private double radius;
    private double sin;
    private double cos;
    private double angleStep;
    private int particles;

    public SpherePreview(double radius) {
        if (radius == 0.0) {
            throw new IllegalArgumentException("Invalid radius - cannot be 0");
        }
        this.radius = Math.abs(radius);
        this.particles = (int)(PreviewSettings.density * radius * 2.0 * Math.PI);
        this.angleStep = PreviewSettings.animation * (double)PreviewSettings.interval / (20.0 * this.radius);
        double angle = Math.PI * 2 / (double)this.particles;
        this.sin = Math.sin(angle);
        this.cos = Math.cos(angle);
    }

    @Override
    public void playParticles(Player player, ParticleSettings particle, Location location, int step) {
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        double startAngle = (double)step * this.angleStep;
        double urs = Math.sin(startAngle);
        double urc = Math.cos(startAngle);
        double rs = urs * this.radius;
        double rc = urc * this.radius;
        for (int i = 0; i < this.particles; ++i) {
            particle.instance(player, x + rs, y, z + rc);
            particle.instance(player, x + rs * urc, y + rc, z + rs * urs);
            particle.instance(player, x + (rc - rs * urs) * COS_45, y + rs * urc, z + (rc + rs * urs) * COS_45);
            double temp = rs * this.cos - rc * this.sin;
            rc = rs * this.sin + rc * this.cos;
            rs = temp;
        }
    }

    @Override
    public double getRadius() {
        return this.radius;
    }
}

