/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.cast;

import com.sucy.skill.api.particle.ParticleSettings;
import com.sucy.skill.cast.Preview;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class ProjectilePreview
extends Preview {
    private double speed;
    private double gravity;
    private double tBase;

    public ProjectilePreview(double speed, double gravity) {
        this.speed = speed;
        this.gravity = gravity;
        this.tBase = 3.0 / this.speed;
    }

    @Override
    public void playParticles(Player player, ParticleSettings particle, Location location, int step) {
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        Vector direction = location.getDirection();
        double px = x + direction.getX() * this.tBase;
        double py = y + direction.getY() * this.tBase - this.gravity * this.tBase * this.tBase;
        double pz = z + direction.getZ() * this.tBase;
        particle.instance(player, px, py, pz);
    }

    public double getSpeed() {
        return this.speed;
    }

    public double getGravity() {
        return this.gravity;
    }
}

