/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.cast;

import com.sucy.skill.api.particle.ParticleSettings;
import com.sucy.skill.cast.PreviewSettings;
import com.sucy.skill.cast.RoundPreview;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class CylinderPreview
extends RoundPreview {
    private double radius;
    private double height;
    private double sin;
    private double cos;
    private int particles;
    private int vertParticles;
    private double vertOffset;
    private int vert;

    public CylinderPreview(double radius, double height) {
        if (radius == 0.0) {
            throw new IllegalArgumentException("Invalid radius - cannot be 0");
        }
        this.radius = Math.abs(radius);
        this.height = height;
        this.particles = (int)(PreviewSettings.density * radius * 2.0 * Math.PI);
        this.vert = this.particles / 8;
        this.vertParticles = (int)(PreviewSettings.density * height);
        this.vertOffset = height / (double)this.vertParticles;
        double angle = Math.PI * 2 / (double)this.particles;
        this.sin = Math.sin(angle);
        this.cos = Math.cos(angle);
    }

    @Override
    public void playParticles(Player player, ParticleSettings particle, Location location, int step) {
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        double startAngle = (double)step * PreviewSettings.animation / (20.0 * this.radius);
        double rSin = Math.sin(startAngle) * this.radius;
        double rCos = Math.cos(startAngle) * this.radius;
        for (int i = 0; i < this.particles; ++i) {
            particle.instance(player, x + rSin, y, z + rCos);
            particle.instance(player, x + rSin, y + this.height, z + rCos);
            if (i % this.vert == 0) {
                for (int j = 0; j < this.vertParticles; ++j) {
                    particle.instance(player, x + rSin, y + this.vertOffset * (double)j, z + rCos);
                }
            }
            double temp = rSin * this.cos - rCos * this.sin;
            rCos = rSin * this.sin + rCos * this.cos;
            rSin = temp;
        }
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    public double getHeight() {
        return this.height;
    }
}

