/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.util;

import com.sucy.skill.api.util.FlagData;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.LivingEntity;

public class FlagManager {
    private static final Map<Integer, FlagData> data = new HashMap<Integer, FlagData>();

    public static FlagData getFlagData(LivingEntity entity) {
        return FlagManager.getFlagData(entity, true);
    }

    public static FlagData getFlagData(LivingEntity entity, boolean create) {
        if (entity == null) {
            return null;
        }
        if (!data.containsKey(entity.getEntityId()) && create) {
            data.put(entity.getEntityId(), new FlagData(entity));
        }
        return data.get(entity.getEntityId());
    }

    public static void addFlag(LivingEntity entity, String flag, int ticks) {
        FlagData data = FlagManager.getFlagData(entity, true);
        if (data != null) {
            data.addFlag(flag, ticks);
        }
    }

    public static void removeFlag(LivingEntity entity, String flag) {
        FlagData data = FlagManager.getFlagData(entity, false);
        if (data != null) {
            data.removeFlag(flag);
        }
    }

    public static boolean hasFlag(LivingEntity entity, String flag) {
        return entity != null && data.containsKey(entity.getEntityId()) && FlagManager.getFlagData(entity, false).hasFlag(flag);
    }

    public static int getTimeLeft(LivingEntity entity, String flag) {
        if (entity == null) {
            return 0;
        }
        return data.containsKey(entity.getEntityId()) ? FlagManager.getFlagData(entity).getSecondsLeft(flag) : 0;
    }

    public static void clearFlags(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        FlagData result = data.remove(entity.getEntityId());
        if (result != null) {
            result.clear();
        }
    }
}

