/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.util;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.event.FlagApplyEvent;
import com.sucy.skill.api.event.FlagExpireEvent;
import com.sucy.skill.api.util.FlagManager;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class FlagData {
    private final HashMap<String, Long> flags = new HashMap();
    private final HashMap<String, BukkitTask> tasks = new HashMap();
    private final LivingEntity entity;
    private final Plugin plugin = SkillAPI.inst();

    public FlagData(LivingEntity entity) {
        this.entity = entity;
    }

    public void addFlag(String flag, int ticks) {
        FlagApplyEvent event = new FlagApplyEvent(this.entity, flag, ticks);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (ticks < 0) {
            BukkitTask task = this.tasks.remove(flag);
            if (task != null) {
                task.cancel();
            }
            this.flags.put(flag, Long.MAX_VALUE);
            return;
        }
        if (this.flags.containsKey(flag)) {
            long time = this.flags.get(flag);
            if (time > (long)(ticks * 50) + System.currentTimeMillis()) {
                return;
            }
            BukkitTask task = this.tasks.remove(flag);
            if (task != null) {
                task.cancel();
            }
        }
        this.flags.put(flag, System.currentTimeMillis() + (long)(ticks * 50));
        this.tasks.put(flag, new FlagTask(flag).runTaskLater(this.plugin, ticks));
    }

    public void removeFlag(String flag) {
        this.removeFlag(flag, FlagExpireEvent.ExpireReason.REMOVED);
    }

    private void removeFlag(String flag, FlagExpireEvent.ExpireReason reason) {
        if (this.flags.containsKey(flag)) {
            this.flags.remove(flag);
            BukkitTask task = this.tasks.remove(flag);
            if (task != null) {
                task.cancel();
            }
            Bukkit.getPluginManager().callEvent((Event)new FlagExpireEvent(this.entity, flag, reason));
            if (this.flags.size() == 0) {
                FlagManager.clearFlags(this.entity);
            }
        }
    }

    public void clear() {
        ArrayList<String> flags = new ArrayList<String>(this.flags.keySet());
        for (String flag : flags) {
            this.removeFlag(flag);
        }
        FlagManager.clearFlags(this.entity);
    }

    public int getSecondsLeft(String flag) {
        if (!this.hasFlag(flag)) {
            return 0;
        }
        long millis = this.flags.get(flag) - System.currentTimeMillis();
        return (int)Math.max(1L, (millis + 999L) / 1000L);
    }

    public int getMillisLeft(String flag) {
        if (!this.hasFlag(flag)) {
            return 0;
        }
        return (int)(this.flags.get(flag) - System.currentTimeMillis());
    }

    public boolean hasFlag(String flag) {
        return this.flags.containsKey(flag);
    }

    private class FlagTask
    extends BukkitRunnable {
        private final String flag;

        public FlagTask(String flag) {
            this.flag = flag;
        }

        public void run() {
            if (!FlagData.this.entity.isValid() || FlagData.this.entity.isDead()) {
                FlagManager.clearFlags(FlagData.this.entity);
                return;
            }
            FlagData.this.removeFlag(this.flag, FlagExpireEvent.ExpireReason.TIME);
        }
    }
}

