/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.projectile;

import com.sucy.skill.api.Settings;
import com.sucy.skill.api.event.ParticleProjectileExpireEvent;
import com.sucy.skill.api.event.ParticleProjectileHitEvent;
import com.sucy.skill.api.event.ParticleProjectileLandEvent;
import com.sucy.skill.api.event.ParticleProjectileLaunchEvent;
import com.sucy.skill.api.particle.ParticleHelper;
import com.sucy.skill.api.projectile.CustomProjectile;
import com.sucy.skill.api.projectile.ProjectileCallback;
import com.sucy.skill.api.target.TargetHelper;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class ParticleProjectile
extends CustomProjectile {
    public static final String SPEED = "velocity";
    private static final String LIFESPAN = "lifespan";
    private static final String FREQUENCY = "frequency";
    private static final String GRAVITY = "gravity";
    private static final String PIERCE = "pierce";
    private Location loc;
    private final Settings settings;
    private Vector vel;
    private final int steps;
    private int count;
    private final int freq;
    private int life;
    private final Vector gravity;
    private final boolean pierce;

    public ParticleProjectile(LivingEntity shooter, int level, Location loc, Settings settings, int lifespan) {
        super(shooter);
        this.loc = loc;
        this.settings = settings;
        this.vel = loc.getDirection().multiply(settings.getAttr(SPEED, level, 1.0));
        this.freq = (int)(20.0 * settings.getDouble(FREQUENCY, 0.5));
        this.life = lifespan;
        this.gravity = new Vector(0.0, settings.getDouble(GRAVITY, 0.0), 0.0);
        this.pierce = settings.getBool(PIERCE, false);
        this.steps = (int)Math.ceil(this.vel.length() * 2.0);
        this.vel.multiply(1.0 / (double)this.steps);
        this.gravity.multiply(1.0 / (double)this.steps);
        Bukkit.getPluginManager().callEvent((Event)new ParticleProjectileLaunchEvent(this));
    }

    @Override
    public Location getLocation() {
        return this.loc;
    }

    @Override
    protected Event expire() {
        return new ParticleProjectileExpireEvent(this);
    }

    @Override
    protected Event land() {
        return new ParticleProjectileLandEvent(this);
    }

    @Override
    protected Event hit(LivingEntity entity) {
        return new ParticleProjectileHitEvent(this, entity);
    }

    @Override
    protected boolean landed() {
        return TargetHelper.isSolid(this.getLocation().getBlock().getType());
    }

    @Override
    protected double getCollisionRadius() {
        return 1.5;
    }

    @Override
    public Vector getVelocity() {
        return this.vel;
    }

    public void teleport(Location loc) {
        this.loc = loc;
    }

    @Override
    public void setVelocity(Vector vel) {
        this.vel = vel;
    }

    public void run() {
        for (int i = 0; i < this.steps; ++i) {
            this.loc.add(this.vel);
            this.vel.add(this.gravity);
            if (!this.isTraveling()) {
                return;
            }
            if (!this.checkCollision(this.pierce)) break;
        }
        ++this.count;
        if (this.count >= this.freq) {
            this.count = 0;
            ParticleHelper.play(this.loc, this.settings);
        }
        --this.life;
        if (this.life <= 0) {
            this.cancel();
            Bukkit.getPluginManager().callEvent((Event)new ParticleProjectileExpireEvent(this));
        }
    }

    public static ArrayList<ParticleProjectile> spread(LivingEntity shooter, int level, Vector center, Location loc, Settings settings, double angle, int amount, ProjectileCallback callback, int lifespan) {
        ArrayList<Vector> dirs = ParticleProjectile.calcSpread(center, angle, amount);
        ArrayList<ParticleProjectile> list = new ArrayList<ParticleProjectile>();
        for (Vector dir : dirs) {
            Location l = loc.clone();
            l.setDirection(dir);
            ParticleProjectile p = new ParticleProjectile(shooter, level, l, settings, lifespan);
            p.setCallback(callback);
            list.add(p);
        }
        return list;
    }

    public static ArrayList<ParticleProjectile> rain(LivingEntity shooter, int level, Location center, Settings settings, double radius, double height, int amount, ProjectileCallback callback, int lifespan) {
        Vector vel = new Vector(0, 1, 0);
        ArrayList<Location> locs = ParticleProjectile.calcRain(center, radius, height, amount);
        ArrayList<ParticleProjectile> list = new ArrayList<ParticleProjectile>();
        for (Location l : locs) {
            l.setDirection(vel);
            ParticleProjectile p = new ParticleProjectile(shooter, level, l, settings, lifespan);
            p.setCallback(callback);
            list.add(p);
        }
        return list;
    }
}

