/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.player;

import com.google.common.base.Preconditions;
import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.classes.RPGClass;
import com.sucy.skill.api.enums.ExpSource;
import com.sucy.skill.api.enums.ManaCost;
import com.sucy.skill.api.enums.ManaSource;
import com.sucy.skill.api.enums.PointSource;
import com.sucy.skill.api.enums.SkillStatus;
import com.sucy.skill.api.event.PlayerCastSkillEvent;
import com.sucy.skill.api.event.PlayerClassChangeEvent;
import com.sucy.skill.api.event.PlayerManaGainEvent;
import com.sucy.skill.api.event.PlayerManaLossEvent;
import com.sucy.skill.api.event.PlayerPreClassChangeEvent;
import com.sucy.skill.api.event.PlayerRefundAttributeEvent;
import com.sucy.skill.api.event.PlayerSkillCastFailedEvent;
import com.sucy.skill.api.event.PlayerSkillDowngradeEvent;
import com.sucy.skill.api.event.PlayerSkillUnlockEvent;
import com.sucy.skill.api.event.PlayerSkillUpgradeEvent;
import com.sucy.skill.api.event.PlayerUpAttributeEvent;
import com.sucy.skill.api.player.PlayerAttributeModifier;
import com.sucy.skill.api.player.PlayerClass;
import com.sucy.skill.api.player.PlayerCombos;
import com.sucy.skill.api.player.PlayerSkill;
import com.sucy.skill.api.player.PlayerSkillBar;
import com.sucy.skill.api.player.PlayerStatModifier;
import com.sucy.skill.api.skills.PassiveSkill;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.api.skills.SkillShot;
import com.sucy.skill.api.skills.TargetSkill;
import com.sucy.skill.api.target.TargetHelper;
import com.sucy.skill.cast.PlayerCastBars;
import com.sucy.skill.data.GroupSettings;
import com.sucy.skill.data.PlayerEquips;
import com.sucy.skill.dynamic.EffectComponent;
import com.sucy.skill.gui.handlers.AttributeHandler;
import com.sucy.skill.gui.handlers.DetailsHandler;
import com.sucy.skill.gui.handlers.ProfessHandler;
import com.sucy.skill.gui.handlers.SkillHandler;
import com.sucy.skill.gui.tool.GUITool;
import com.sucy.skill.language.RPGFilter;
import com.sucy.skill.log.LogType;
import com.sucy.skill.log.Logger;
import com.sucy.skill.manager.AttributeManager;
import com.sucy.skill.task.ScoreboardTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mc.promcteam.engine.NexEngine;
import mc.promcteam.engine.api.meta.NBTAttribute;
import mc.promcteam.engine.mccore.config.CustomFilter;
import mc.promcteam.engine.mccore.config.Filter;
import mc.promcteam.engine.mccore.config.FilterType;
import mc.promcteam.engine.mccore.config.parse.DataSection;
import mc.promcteam.engine.mccore.util.VersionManager;
import mc.promcteam.engine.utils.EntityUT;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.Nullable;

public class PlayerData {
    public final HashMap<String, Integer> attributes = new HashMap();
    private final HashMap<String, PlayerClass> classes = new HashMap();
    private final HashMap<String, PlayerSkill> skills = new HashMap();
    private final HashSet<ExternallyAddedSkill> extSkills = new HashSet();
    private final HashMap<Material, PlayerSkill> binds = new HashMap();
    private final HashMap<String, List<PlayerAttributeModifier>> attributesModifiers = new HashMap();
    private final HashMap<String, List<PlayerStatModifier>> statModifiers = new HashMap();
    private final DataSection extraData = new DataSection();
    private final UUID playerUUID;
    private final PlayerSkillBar skillBar;
    private final PlayerCastBars castBars;
    private final PlayerCombos combos;
    private final PlayerEquips equips;
    private final List<UUID> onCooldown = new ArrayList<UUID>();
    public int attribPoints;
    private String scheme;
    private String menuClass;
    private double mana;
    private double maxMana;
    private double lastHealth;
    private double health;
    private double maxHealth;
    private double hunger;
    private boolean init;
    private boolean passive;
    private long skillTimer;
    private BukkitTask removeTimer;

    PlayerData(OfflinePlayer player, boolean init) {
        this.playerUUID = player.getUniqueId();
        this.skillBar = new PlayerSkillBar(this);
        this.castBars = new PlayerCastBars(this);
        this.combos = new PlayerCombos(this);
        this.equips = new PlayerEquips(this);
        this.init = SkillAPI.isLoaded() && init;
        this.scheme = "default";
        this.hunger = 1.0;
        for (String group : SkillAPI.getGroups()) {
            GroupSettings settings = SkillAPI.getSettings().getGroupSettings(group);
            RPGClass rpgClass = settings.getDefault();
            if (rpgClass == null || settings.getPermission() != null) continue;
            this.setClass(null, rpgClass, true);
        }
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.playerUUID);
    }

    public String getPlayerName() {
        return this.getPlayer().getName();
    }

    public UUID getUUID() {
        return this.playerUUID;
    }

    public PlayerSkillBar getSkillBar() {
        return this.skillBar;
    }

    public PlayerCastBars getCastBars() {
        return this.castBars;
    }

    public PlayerCombos getComboData() {
        return this.combos;
    }

    public DataSection getExtraData() {
        return this.extraData;
    }

    public PlayerEquips getEquips() {
        return this.equips;
    }

    public double getLastHealth() {
        return this.lastHealth;
    }

    public void setLastHealth(double health) {
        this.lastHealth = health;
    }

    public double getHungerValue() {
        return this.hunger;
    }

    public void setHungerValue(double hungerValue) {
        this.hunger = hungerValue;
    }

    public int subtractHungerValue(double amount) {
        double scaled = amount / this.scaleStat("hunger", amount, 0.0, Double.MAX_VALUE);
        int lost = scaled >= this.hunger ? (int)(scaled - this.hunger) + 1 : 0;
        this.hunger += (double)lost - amount;
        return lost;
    }

    public void endInit() {
        this.init = false;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String name) {
        this.scheme = name;
    }

    public HashMap<String, Integer> getAttributes() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String key : SkillAPI.getAttributeManager().getKeys()) {
            map.put(key, this.getAttribute(key));
        }
        return map;
    }

    public HashMap<String, Integer> getInvestedAttributes() {
        return new HashMap<String, Integer>(this.attributes);
    }

    public int getAttribute(String key) {
        key = key.toLowerCase();
        double total = 0.0;
        for (PlayerClass playerClass : this.classes.values()) {
            total += (double)playerClass.getData().getAttribute(key, playerClass.getLevel());
        }
        if (this.attributes.containsKey(key)) {
            total += (double)this.attributes.get(key).intValue();
        }
        if (this.attributesModifiers.containsKey(key)) {
            double multiplier = 1.0;
            for (PlayerAttributeModifier modifier : this.getAttributeModifiers(key)) {
                switch (modifier.getOperation()) {
                    case ADD_NUMBER: {
                        total = modifier.applyOn(total);
                        break;
                    }
                    case MULTIPLY_PERCENTAGE: {
                        multiplier = modifier.applyOn(multiplier);
                    }
                }
            }
            total *= multiplier;
        }
        return Math.max(0, (int)Math.round(total));
    }

    public int getInvestedAttribute(String key) {
        return this.attributes.getOrDefault(key.toLowerCase(), 0);
    }

    public boolean hasAttribute(String key) {
        return this.getAttribute(key) > 0;
    }

    public boolean upAttribute(String key) {
        key = key.toLowerCase();
        int current = this.getInvestedAttribute(key);
        int max = SkillAPI.getAttributeManager().getAttribute(key).getMax();
        if (this.attribPoints > 0 && current < max) {
            this.attributes.put(key, current + 1);
            --this.attribPoints;
            PlayerUpAttributeEvent event = new PlayerUpAttributeEvent(this, key);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.attributes.put(key, current);
                ++this.attribPoints;
            } else {
                return true;
            }
        }
        return false;
    }

    public void giveAttribute(String key, int amount) {
        int max;
        int current = this.getInvestedAttribute(key = key.toLowerCase());
        if ((amount = Math.min(amount + current, max = SkillAPI.getAttributeManager().getAttribute(key).getMax())) > current) {
            this.attributes.put(key, amount);
            this.updatePlayerStat(this.getPlayer());
        }
    }

    public void addStatModifier(String key, PlayerStatModifier modifier, boolean update) {
        List<PlayerStatModifier> modifiers = this.getStatModifiers(key);
        modifiers.add(modifier);
        this.statModifiers.put(key, modifiers);
        if (update) {
            this.updatePlayerStat(this.getPlayer());
        }
    }

    public List<PlayerStatModifier> getStatModifiers(String key) {
        if (this.statModifiers.containsKey(key)) {
            return this.statModifiers.get(key);
        }
        return new ArrayList<PlayerStatModifier>();
    }

    public void addAttributeModifier(String key, PlayerAttributeModifier modifier, boolean update) {
        key = SkillAPI.getAttributeManager().normalize(key);
        List<PlayerAttributeModifier> modifiers = this.getAttributeModifiers(key);
        modifiers.add(modifier);
        this.attributesModifiers.put(key, modifiers);
        if (update) {
            this.updatePlayerStat(this.getPlayer());
        }
    }

    public List<PlayerAttributeModifier> getAttributeModifiers(String key) {
        if (this.attributesModifiers.containsKey(key)) {
            return this.attributesModifiers.get(key);
        }
        return new ArrayList<PlayerAttributeModifier>();
    }

    public boolean refundAttribute(String key) {
        int current = this.getInvestedAttribute(key = key.toLowerCase());
        if (current > 0) {
            PlayerRefundAttributeEvent event = new PlayerRefundAttributeEvent(this, key);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            ++this.attribPoints;
            this.attributes.put(key, current - 1);
            if (current - 1 <= 0) {
                this.attributes.remove(key);
            }
            this.updatePlayerStat(this.getPlayer());
            return true;
        }
        return false;
    }

    public void refundAttributes(String key) {
        key = key.toLowerCase();
        this.attribPoints += this.getInvestedAttribute(key);
        this.attributes.remove(key);
        this.updatePlayerStat(this.getPlayer());
    }

    public void refundAttributes() {
        ArrayList<String> keys = new ArrayList<String>(this.attributes.keySet());
        for (String key : keys) {
            this.refundAttributes(key);
        }
    }

    public int getAttributePoints() {
        return this.attribPoints;
    }

    public void giveAttribPoints(int amount) {
        this.attribPoints += amount;
    }

    public void setAttribPoints(int amount) {
        this.attribPoints = amount;
    }

    public double scaleStat(String stat, double baseValue) {
        return this.scaleStat(stat, baseValue, 0.0, Double.MAX_VALUE);
    }

    public double scaleStat(String stat, double defaultValue, double min, double max) {
        Player player = this.getPlayer();
        if (player != null && !SkillAPI.getSettings().isWorldEnabled(player.getWorld())) {
            return defaultValue;
        }
        AttributeManager manager = SkillAPI.getAttributeManager();
        if (manager == null) {
            return defaultValue;
        }
        double modified = defaultValue;
        List<AttributeManager.Attribute> matches = manager.forStat(stat);
        if (matches != null) {
            for (AttributeManager.Attribute attribute : matches) {
                int amount = this.getAttribute(attribute.getKey());
                if (amount <= 0) continue;
                modified = attribute.modifyStat(stat, modified, amount);
            }
        }
        if (this.statModifiers.containsKey(stat)) {
            double multiplier = 1.0;
            for (PlayerStatModifier modifier : this.getStatModifiers(stat)) {
                switch (modifier.getOperation()) {
                    case ADD_NUMBER: {
                        modified = modifier.applyOn(modified);
                        break;
                    }
                    case MULTIPLY_PERCENTAGE: {
                        multiplier = modifier.applyOn(multiplier);
                    }
                }
            }
            modified *= multiplier;
        }
        return Math.max(min, Math.min(max, modified));
    }

    public double scaleDynamic(EffectComponent component, String key, double value) {
        AttributeManager manager = SkillAPI.getAttributeManager();
        if (manager == null) {
            return value;
        }
        List<AttributeManager.Attribute> matches = manager.forComponent(component, key);
        if (matches == null) {
            return value;
        }
        for (AttributeManager.Attribute attribute : matches) {
            int amount = this.getAttribute(attribute.getKey());
            if (amount <= 0) continue;
            value = attribute.modify(component, key, value, amount);
        }
        return value;
    }

    public boolean openAttributeMenu() {
        Player player = this.getPlayer();
        if (SkillAPI.getSettings().isAttributesEnabled() && player != null) {
            GUITool.getAttributesMenu().show(new AttributeHandler(), this, (String)SkillAPI.getLanguage().getMessage("GUI.attribute-title", true, FilterType.COLOR, new CustomFilter[]{RPGFilter.POINTS.setReplacement("" + this.attribPoints), Filter.PLAYER.setReplacement(player.getName())}).get(0), SkillAPI.getAttributeManager().getAttributes());
            return true;
        }
        return false;
    }

    public HashMap<String, Integer> getAttributeData() {
        return this.attributes;
    }

    public boolean hasSkill(String name) {
        return name != null && this.skills.containsKey(name.toLowerCase());
    }

    public PlayerSkill getSkill(String name) {
        if (name == null) {
            return null;
        }
        return this.skills.get(name.toLowerCase());
    }

    public int getInvestedSkillPoints() {
        int total = 0;
        for (PlayerSkill playerSkill : this.skills.values()) {
            total += playerSkill.getInvestedCost();
        }
        return total;
    }

    public Collection<PlayerSkill> getSkills() {
        return this.skills.values();
    }

    public Set<ExternallyAddedSkill> getExternallyAddedSkills() {
        return Collections.unmodifiableSet(this.extSkills);
    }

    public int getSkillLevel(String name) {
        PlayerSkill skill = this.getSkill(name);
        return skill == null ? 0 : skill.getLevel();
    }

    public void giveSkill(Skill skill) {
        this.giveSkill(skill, null);
    }

    public void giveSkill(Skill skill, PlayerClass parent) {
        String key = skill.getKey();
        if (!this.skills.containsKey(key)) {
            this.addSkill(skill, parent);
            this.autoLevel(skill);
        }
    }

    public void addSkill(Skill skill, PlayerClass parent) {
        String key = skill.getKey();
        PlayerSkill existing = this.skills.get(key);
        if (existing == null || !existing.isExternal()) {
            PlayerSkill data = new PlayerSkill(this, skill, parent);
            this.skills.put(key, data);
            this.combos.addSkill(skill);
        }
    }

    public void addSkillExternally(Skill skill, PlayerClass parent, NamespacedKey namespacedKey, int level) {
        String key = skill.getKey();
        this.extSkills.removeIf(extSkill -> extSkill.getId().equals(key) && extSkill.getKey().equals((Object)namespacedKey));
        this.extSkills.add(new ExternallyAddedSkill(key, namespacedKey, level));
        PlayerSkill existing = this.skills.get(key);
        if (existing == null || existing.getLevel() == 0) {
            PlayerSkill data = new PlayerSkill(this, skill, parent, true);
            this.skills.put(key, data);
            this.combos.addSkill(skill);
            this.forceUpSkill(data, level);
        } else if (existing.isExternal() && level > existing.getLevel()) {
            this.forceUpSkill(existing, level - existing.getLevel());
        }
    }

    public void removeSkillExternally(Skill skill, NamespacedKey namespacedKey) {
        String key = skill.getKey();
        this.extSkills.removeIf(extSkill -> extSkill.getId().equals(key) && extSkill.getKey().equals((Object)namespacedKey));
        PlayerSkill existing = this.skills.get(key);
        if (existing != null && existing.isExternal()) {
            ExternallyAddedSkill max = null;
            int maxLevel = Integer.MIN_VALUE;
            for (ExternallyAddedSkill extSkill2 : this.extSkills) {
                int level;
                if (!extSkill2.getId().equals(key) || (level = extSkill2.getLevel()) <= maxLevel) continue;
                maxLevel = level;
                max = extSkill2;
            }
            if (max == null) {
                this.skills.remove(key);
                this.combos.removeSkill(existing.getData());
                this.forceDownSkill(existing, existing.getLevel());
            } else {
                this.forceDownSkill(existing, existing.getLevel() - maxLevel);
            }
        }
    }

    public void autoLevel() {
        if (this.init) {
            return;
        }
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        for (PlayerSkill skill : this.skills.values()) {
            if (!skill.getData().isAllowed(player)) continue;
            this.autoLevel(skill.getData());
        }
    }

    private void autoLevel(Skill skill) {
        PlayerSkill data = this.skills.get(skill.getKey());
        if (data == null || this.getPlayer() == null || !skill.isAllowed(this.getPlayer())) {
            return;
        }
        int lastLevel = data.getLevel();
        while (data.getData().canAutoLevel(lastLevel) && !data.isMaxed() && data.getLevelReq() <= data.getPlayerClass().getLevel()) {
            this.upgradeSkill(skill);
            if (lastLevel == data.getLevel()) break;
            ++lastLevel;
        }
    }

    public boolean upgradeSkill(Skill skill) {
        if (skill == null) {
            return false;
        }
        PlayerSkill data = this.skills.get(skill.getName().toLowerCase());
        if (data == null) {
            return false;
        }
        if (!(skill.isCompatible(this) && skill.hasInvestedEnough(this) && skill.hasDependency(this))) {
            return false;
        }
        int level = data.getPlayerClass().getLevel();
        int points = data.getPlayerClass().getPoints();
        int cost = data.getCost();
        if (!data.isMaxed() && level >= data.getLevelReq() && points >= cost) {
            PlayerSkillUpgradeEvent event = new PlayerSkillUpgradeEvent(this, data, cost);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            data.getPlayerClass().usePoints(cost);
            this.forceUpSkill(data);
            return true;
        }
        return false;
    }

    public void forceUpSkill(PlayerSkill skill) {
        this.forceUpSkill(skill, 1);
    }

    public void forceUpSkill(PlayerSkill skill, int amount) {
        Preconditions.checkArgument((amount >= 0 ? 1 : 0) != 0);
        if (amount == 0) {
            return;
        }
        int oldLevel = skill.getLevel();
        skill.addLevels(amount);
        if (this.passive) {
            Player player = this.getPlayer();
            if (player != null && skill.getData() instanceof PassiveSkill) {
                if (oldLevel == 0) {
                    ((PassiveSkill)((Object)skill.getData())).initialize((LivingEntity)player, skill.getLevel());
                } else {
                    ((PassiveSkill)((Object)skill.getData())).update((LivingEntity)player, oldLevel, skill.getLevel());
                }
            }
            if (skill.getLevel() == 1) {
                Bukkit.getPluginManager().callEvent((Event)new PlayerSkillUnlockEvent(this, skill));
                this.autoLevel();
            }
        }
    }

    public boolean downgradeSkill(Skill skill) {
        if (skill == null) {
            return false;
        }
        PlayerSkill data = this.skills.get(skill.getName().toLowerCase());
        if (data == null) {
            return false;
        }
        if (data.getCost() == 0) {
            return false;
        }
        for (PlayerSkill s : this.skills.values()) {
            if (s.getData().getSkillReq() == null || !s.getData().getSkillReq().equalsIgnoreCase(skill.getName()) || data.getLevel() > s.getData().getSkillReqLevel() || s.getLevel() <= 0) continue;
            return false;
        }
        int cost = skill.getCost(data.getLevel() - 1);
        if (data.getLevel() > 0) {
            PlayerSkillDowngradeEvent event = new PlayerSkillDowngradeEvent(this, data, cost);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            data.getPlayerClass().givePoints(cost, PointSource.REFUND);
            this.forceDownSkill(data);
            return true;
        }
        return false;
    }

    public void forceDownSkill(PlayerSkill skill) {
        this.forceDownSkill(skill, 1);
    }

    public void forceDownSkill(PlayerSkill skill, int amount) {
        Preconditions.checkArgument((amount >= 0 ? 1 : 0) != 0);
        if (amount == 0) {
            return;
        }
        skill.addLevels(-amount);
        Player player = this.getPlayer();
        if (player != null && skill.getData() instanceof PassiveSkill) {
            if (skill.getLevel() == 0) {
                ((PassiveSkill)((Object)skill.getData())).stopEffects((LivingEntity)player, 1);
            } else {
                ((PassiveSkill)((Object)skill.getData())).update((LivingEntity)player, skill.getLevel() + amount, skill.getLevel());
            }
        }
        if (skill.getLevel() == 0) {
            this.clearBinds(skill.getData());
        }
    }

    public void refundSkill(PlayerSkill skill) {
        Player player = this.getPlayer();
        if (skill.getCost() == 0 || skill.getLevel() == 0) {
            return;
        }
        skill.getPlayerClass().givePoints(skill.getInvestedCost(), PointSource.REFUND);
        skill.setLevel(0);
        if (player != null && skill.getData() instanceof PassiveSkill) {
            ((PassiveSkill)((Object)skill.getData())).stopEffects((LivingEntity)player, 1);
        }
    }

    public void refundSkills() {
        for (PlayerSkill skill : this.skills.values()) {
            this.refundSkill(skill);
        }
        this.clearAllBinds();
    }

    public void showSkills() {
        this.showSkills(this.getPlayer());
    }

    public boolean showDetails(Player player) {
        if (this.classes.size() > 0 && player != null) {
            HashMap<String, RPGClass> iconMap = new HashMap<String, RPGClass>();
            for (Map.Entry<String, PlayerClass> entry : this.classes.entrySet()) {
                iconMap.put(entry.getKey().toLowerCase(), entry.getValue().getData());
            }
            GUITool.getDetailsMenu().show(new DetailsHandler(), this, (String)SkillAPI.getLanguage().getMessage("GUI.skill-class-list", true, FilterType.COLOR, new CustomFilter[]{Filter.PLAYER.setReplacement(player.getName())}).get(0), iconMap);
            return true;
        }
        return false;
    }

    public boolean showProfession(Player player) {
        for (String group : SkillAPI.getGroups()) {
            PlayerClass c = this.getClass(group);
            if (c != null && (c.getLevel() != c.getData().getMaxLevel() || c.getData().getOptions().size() <= 0)) continue;
            GUITool.getProfessMenu(c == null ? null : c.getData()).show(new ProfessHandler(), this, (String)SkillAPI.getLanguage().getMessage("GUI.profess-title", true, FilterType.COLOR, new CustomFilter[]{Filter.PLAYER.setReplacement(player.getName()), RPGFilter.GROUP.setReplacement(group)}).get(0), SkillAPI.getClasses());
            return true;
        }
        return false;
    }

    public boolean showSkills(Player player) {
        if (player == null || this.classes.size() == 0 || this.skills.size() == 0) {
            return false;
        }
        return this.classes.size() > 1 ? this.showDetails(player) : this.showSkills(player, this.getMainClass());
    }

    public boolean showSkills(Player player, PlayerClass playerClass) {
        if (player == null || playerClass.getData().getSkills().size() == 0) {
            return false;
        }
        this.menuClass = playerClass.getData().getName();
        GUITool.getSkillTree(playerClass.getData()).show(new SkillHandler(), this, (String)SkillAPI.getLanguage().getMessage("GUI.skill-tree", true, FilterType.COLOR, new CustomFilter[]{RPGFilter.POINTS.setReplacement("" + playerClass.getPoints()), RPGFilter.LEVEL.setReplacement("" + playerClass.getLevel()), RPGFilter.CLASS.setReplacement(playerClass.getData().getName()), Filter.PLAYER.setReplacement(this.getPlayerName())}).get(0), playerClass.getData().getSkillMap());
        return true;
    }

    public String getShownClassName() {
        return this.menuClass;
    }

    public boolean hasClass() {
        return this.classes.size() > 0;
    }

    public boolean hasClass(String group) {
        return this.classes.containsKey(group);
    }

    public Collection<PlayerClass> getClasses() {
        return this.classes.values();
    }

    public PlayerClass getClass(String group) {
        return this.classes.get(group);
    }

    @Nullable
    public PlayerClass getMainClass() {
        String main = SkillAPI.getSettings().getMainGroup();
        if (this.classes.containsKey(main)) {
            return this.classes.get(main);
        }
        if (this.classes.size() > 0) {
            return this.classes.values().toArray(new PlayerClass[this.classes.size()])[0];
        }
        return null;
    }

    public PlayerClass setClass(RPGClass previous, RPGClass rpgClass, boolean reset) {
        PlayerClass c = this.classes.remove(rpgClass.getGroup());
        if (c != null) {
            for (Skill skill : c.getData().getSkills()) {
                String nm = skill.getName().toLowerCase();
                PlayerSkill ps = this.skills.get(nm);
                if (previous != null && rpgClass.hasParent() && rpgClass.getParent().getName().equals(previous.getName())) {
                    GroupSettings group = SkillAPI.getSettings().getGroupSettings(rpgClass.getGroup());
                    if (!group.isProfessReset()) continue;
                    if (group.isProfessRefundSkills() && ps.getInvestedCost() > 0) {
                        c.givePoints(ps.getInvestedCost(), PointSource.REFUND);
                    }
                    if (group.isProfessRefundAttributes()) {
                        this.resetAttribs();
                    }
                    this.skills.remove(nm);
                    this.combos.removeSkill(skill);
                    continue;
                }
                if (!reset && SkillAPI.getSettings().isRefundOnClassChange() && this.skills.containsKey(nm)) {
                    if (ps.getInvestedCost() > 0) {
                        c.givePoints(ps.getInvestedCost(), PointSource.REFUND);
                    }
                    this.skills.remove(nm);
                    this.combos.removeSkill(skill);
                }
                if (reset) {
                    this.skills.remove(nm);
                    this.combos.removeSkill(skill);
                }
                this.resetAttribs();
            }
        } else {
            this.attribPoints += rpgClass.getGroupSettings().getStartingAttribs();
        }
        PlayerClass classData = new PlayerClass(this, rpgClass);
        if (!reset && c != null) {
            classData.setLevel(c.getLevel());
            classData.setExp(c.getExp());
            classData.setPoints(c.getPoints());
        }
        this.classes.put(rpgClass.getGroup(), classData);
        for (Skill skill : rpgClass.getSkills()) {
            this.giveSkill(skill, classData);
        }
        this.updatePlayerStat(this.getPlayer());
        this.updateScoreboard();
        return this.classes.get(rpgClass.getGroup());
    }

    public boolean isExactClass(RPGClass rpgClass) {
        if (rpgClass == null) {
            return false;
        }
        PlayerClass c = this.classes.get(rpgClass.getGroup());
        return c != null && c.getData() == rpgClass;
    }

    public boolean isClass(RPGClass rpgClass) {
        if (rpgClass == null) {
            return false;
        }
        PlayerClass pc = this.classes.get(rpgClass.getGroup());
        if (pc == null) {
            return false;
        }
        for (RPGClass temp = pc.getData(); temp != null; temp = temp.getParent()) {
            if (temp != rpgClass) continue;
            return true;
        }
        return false;
    }

    public boolean canProfess(RPGClass rpgClass) {
        Player p = this.getPlayer();
        if (p == null || !rpgClass.isAllowed(p)) {
            return false;
        }
        if (this.classes.containsKey(rpgClass.getGroup())) {
            PlayerClass current = this.classes.get(rpgClass.getGroup());
            return rpgClass.getParent() == current.getData() && current.getData().getMaxLevel() <= current.getLevel();
        }
        return !rpgClass.hasParent();
    }

    public int reset(String group, boolean toSubclass) {
        RPGClass rpgClass;
        GroupSettings settings = SkillAPI.getSettings().getGroupSettings(group);
        if (!settings.canReset()) {
            return 0;
        }
        PlayerClass playerClass = this.classes.remove(group);
        int points = 0;
        if (playerClass != null) {
            RPGClass data = playerClass.getData();
            for (Skill skill : data.getSkills()) {
                PlayerSkill ps = this.skills.remove(skill.getName().toLowerCase());
                if (ps != null && ps.isUnlocked() && ps.getData() instanceof PassiveSkill) {
                    ((PassiveSkill)((Object)ps.getData())).stopEffects((LivingEntity)this.getPlayer(), ps.getLevel());
                }
                if (settings.isProfessRefundSkills() && toSubclass) {
                    points += ps.getInvestedCost();
                }
                this.combos.removeSkill(skill);
            }
            this.updateScoreboard();
            Bukkit.getPluginManager().callEvent((Event)new PlayerClassChangeEvent(playerClass, data, null));
        }
        if ((rpgClass = settings.getDefault()) != null && settings.getPermission() == null) {
            this.setClass(null, rpgClass, true);
        }
        this.binds.clear();
        int aPoints = 0;
        if (settings.isProfessRefundAttributes() && toSubclass) {
            aPoints += this.attribPoints;
            for (Map.Entry<String, Integer> entry : this.attributes.entrySet()) {
                aPoints += entry.getValue().intValue();
            }
        }
        this.resetAttribs();
        this.attribPoints += aPoints;
        return points;
    }

    public void resetAll() {
        ArrayList<String> keys = new ArrayList<String>(this.classes.keySet());
        for (String key : keys) {
            this.reset(key, false);
        }
    }

    public void resetAttribs() {
        this.attributes.clear();
        this.attribPoints = 0;
        for (PlayerClass c : this.classes.values()) {
            GroupSettings s = c.getData().getGroupSettings();
            this.attribPoints += s.getStartingAttribs() + s.getAttribsForLevels(c.getLevel(), 1);
        }
        this.updatePlayerStat(this.getPlayer());
    }

    public boolean profess(RPGClass rpgClass) {
        if (rpgClass != null && this.canProfess(rpgClass)) {
            PlayerClass current;
            int skillPoints;
            PlayerClass previousData = this.classes.get(rpgClass.getGroup());
            RPGClass previous = previousData == null ? null : previousData.getData();
            PlayerPreClassChangeEvent event = new PlayerPreClassChangeEvent(this, previousData, previous, rpgClass);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            boolean isResetting = SkillAPI.getSettings().getGroupSettings(rpgClass.getGroup()).isProfessReset();
            boolean isSubclass = previous != null && rpgClass.getParent().getName().equals(previous.getName());
            int n = skillPoints = isResetting ? this.reset(rpgClass.getGroup(), isSubclass) : -1;
            if (previousData == null || isResetting) {
                current = new PlayerClass(this, rpgClass);
                this.classes.put(rpgClass.getGroup(), current);
                this.attribPoints += rpgClass.getGroupSettings().getStartingAttribs();
                if (skillPoints == -1) {
                    skillPoints = current.getPoints();
                }
            } else {
                current = previousData;
                previousData.setClassData(rpgClass);
            }
            for (Skill skill : rpgClass.getSkills(!isResetting)) {
                if (this.skills.containsKey(skill.getKey())) continue;
                this.skills.put(skill.getKey(), new PlayerSkill(this, skill, current));
                this.combos.addSkill(skill);
            }
            Bukkit.getPluginManager().callEvent((Event)new PlayerClassChangeEvent(current, previous, current.getData()));
            if (skillPoints < 0 || isResetting && skillPoints == 0) {
                skillPoints = rpgClass.getGroupSettings().getStartingPoints();
            }
            current.setPoints(skillPoints);
            this.updateScoreboard();
            this.updatePlayerStat(this.getPlayer());
            return true;
        }
        return false;
    }

    public void giveExp(double amount, ExpSource source) {
        this.giveExp(amount, source, true);
    }

    public void giveExp(double amount, ExpSource source, boolean message) {
        for (PlayerClass playerClass : this.classes.values()) {
            playerClass.giveExp(amount, source, message);
        }
    }

    public void loseExp(double amount, boolean percent, boolean changeLevel) {
        for (PlayerClass playerClass : this.classes.values()) {
            playerClass.loseExp(amount, percent, changeLevel);
        }
    }

    public void loseExp() {
        for (PlayerClass playerClass : this.classes.values()) {
            double penalty = playerClass.getData().getGroupSettings().getDeathPenalty();
            if (!(penalty > 0.0)) continue;
            playerClass.loseExp(penalty);
        }
    }

    public boolean giveLevels(int amount, ExpSource source) {
        boolean success = false;
        for (PlayerClass playerClass : this.classes.values()) {
            RPGClass data = playerClass.getData();
            if (!data.receivesExp(source)) continue;
            success = true;
            playerClass.giveLevels(amount);
        }
        this.updatePlayerStat(this.getPlayer());
        return success;
    }

    public void loseLevels(int amount) {
        this.classes.values().stream().filter(playerClass -> amount > 0).forEach(playerClass -> playerClass.loseLevels(amount));
    }

    public void givePoints(int amount, ExpSource source) {
        for (PlayerClass playerClass : this.classes.values()) {
            if (!playerClass.getData().receivesExp(source)) continue;
            playerClass.givePoints(amount);
        }
    }

    public void updatePlayerStat(Player player) {
        if (!this.hasClass()) {
            this.maxHealth = 0.0;
            if (player != null) {
                this.updateHealth(player);
            }
            return;
        }
        double oldMaxHealth = this.maxHealth;
        this.maxHealth = 0.0;
        this.maxMana = 0.0;
        for (PlayerClass playerClass : this.classes.values()) {
            this.maxHealth += playerClass.getHealth();
            this.maxMana += playerClass.getMana();
        }
        this.maxHealth = this.scaleStat("health", this.maxHealth);
        this.maxMana = this.scaleStat("mana", this.maxMana);
        this.mana = Math.min(this.mana, this.maxMana);
        if (player == null) {
            return;
        }
        this.updateWalkSpeed(player);
        if (oldMaxHealth != this.maxHealth || player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() != this.maxHealth) {
            this.updateHealth(player);
        } else if (SkillAPI.getSettings().isOldHealth()) {
            player.setHealthScaled(true);
            player.setHealthScale(20.0);
        } else {
            player.setHealthScaled(false);
        }
        if (VersionManager.isVersionAtLeast((int)VersionManager.V1_9_0)) {
            this.updateMCAttribute(player, Attribute.GENERIC_ATTACK_SPEED, "attack-speed", 0.0, 1024.0);
            this.updateMCAttribute(player, Attribute.GENERIC_ARMOR, "armor", 0.0, 30.0);
            this.updateMCAttribute(player, Attribute.GENERIC_LUCK, "luck", -1024.0, 1024.0);
            this.updateMCAttribute(player, Attribute.GENERIC_KNOCKBACK_RESISTANCE, "knockback-resist", 0.0, 1.0);
        }
        if (VersionManager.isVersionAtLeast((int)110200)) {
            this.updateMCAttribute(player, Attribute.GENERIC_ARMOR_TOUGHNESS, "armor-toughness", 0.0, 20.0);
        }
    }

    public void updateWalkSpeed(Player player) {
        float level = (float)this.scaleStat("move-speed", 0.2f, 0.0, Double.MAX_VALUE);
        try {
            player.setWalkSpeed(level);
        }
        catch (IllegalArgumentException e) {
            SkillAPI.inst().getLogger().warning("Attempted to set player speed to " + level + " but failed: " + e.getMessage());
        }
    }

    private double getModifiedMaxHealth(Player player) {
        double baseMaxHealth = this.maxHealth;
        double modifiedMax = this.maxHealth;
        for (ItemStack equipment : EntityUT.getEquipment((LivingEntity)player)) {
            ItemMeta meta;
            if (equipment == null || equipment.getType().isAir() || equipment.getItemMeta() == null || !(meta = equipment.getItemMeta()).hasAttributeModifiers() || meta.getAttributeModifiers(NBTAttribute.MAX_HEALTH.getAttribute()) == null) continue;
            block4: for (AttributeModifier modifier : meta.getAttributeModifiers(NBTAttribute.MAX_HEALTH.getAttribute())) {
                switch (modifier.getOperation()) {
                    case MULTIPLY_SCALAR_1: {
                        modifiedMax += baseMaxHealth * modifier.getAmount();
                        continue block4;
                    }
                }
                modifiedMax += modifier.getAmount();
            }
        }
        return modifiedMax;
    }

    public void updateHealth(Player player) {
        if (!SkillAPI.getSettings().isModifyHealth()) {
            return;
        }
        if (this.maxHealth <= 0.0) {
            this.health = this.maxHealth = (double)SkillAPI.getSettings().getDefaultHealth();
        }
        double modifiedMax = this.getModifiedMaxHealth(player);
        AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        attribute.setBaseValue(this.maxHealth);
        if (SkillAPI.getSettings().isOldHealth()) {
            if (SkillAPI.getSettings().isDownScaling() && player.getMaxHealth() < 20.0) {
                player.setHealthScaled(false);
            } else {
                player.setHealthScaled(true);
                player.setHealthScale(20.0);
            }
        } else {
            player.setHealthScaled(false);
        }
        if (player.getHealth() > modifiedMax) {
            player.setHealth(this.maxHealth);
        }
    }

    private void updateMCAttribute(Player player, Attribute attribute, String attribKey, double min, double max) {
        AttributeInstance instance = player.getAttribute(attribute);
        double def = instance.getDefaultValue();
        double modified = this.scaleStat(attribKey, def, min, max);
        instance.setBaseValue(modified);
    }

    public double getMana() {
        return this.mana;
    }

    public void setMana(double amount) {
        this.mana = amount;
    }

    public boolean hasMana(double amount) {
        return this.mana >= amount;
    }

    public double getMaxMana() {
        return this.maxMana;
    }

    public void regenMana() {
        double amount = 0.0;
        for (PlayerClass c : this.classes.values()) {
            if (!c.getData().hasManaRegen()) continue;
            amount += c.getData().getManaRegen();
        }
        if (amount > 0.0) {
            double finalAmount = amount;
            Bukkit.getScheduler().runTask((Plugin)NexEngine.get(), () -> this.giveMana(finalAmount, ManaSource.REGEN));
        }
    }

    public void giveMana(double amount) {
        this.giveMana(amount, ManaSource.SPECIAL);
    }

    public void giveMana(double amount, ManaSource source) {
        PlayerManaGainEvent event = new PlayerManaGainEvent(this, amount, source);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            Logger.log(LogType.MANA, 2, this.getPlayerName() + " gained " + amount + " mana due to " + event.getSource().name());
            this.mana += event.getAmount();
            if (this.mana > this.maxMana) {
                this.mana = this.maxMana;
            }
            if (this.mana < 0.0) {
                this.mana = 0.0;
            }
        } else {
            Logger.log(LogType.MANA, 2, this.getPlayerName() + " had their mana gain cancelled");
        }
    }

    public void useMana(double amount) {
        this.useMana(amount, ManaCost.SPECIAL);
    }

    public void useMana(double amount, ManaCost cost) {
        PlayerManaLossEvent event = new PlayerManaLossEvent(this, amount, cost);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            Logger.log(LogType.MANA, 2, this.getPlayerName() + " used " + amount + " mana due to " + event.getSource().name());
            this.mana -= event.getAmount();
            if (this.mana < 0.0) {
                this.mana = 0.0;
            }
        }
    }

    public void removeStatModifier(UUID uuid, boolean update) {
        for (Map.Entry<String, List<PlayerStatModifier>> entry : this.statModifiers.entrySet()) {
            List<PlayerStatModifier> modifiers = entry.getValue();
            Iterator<PlayerStatModifier> i = modifiers.iterator();
            while (i.hasNext()) {
                PlayerStatModifier modifier = i.next();
                if (!modifier.getUUID().equals(uuid)) continue;
                i.remove();
            }
            this.statModifiers.put(entry.getKey(), modifiers);
        }
        if (update) {
            this.updatePlayerStat(this.getPlayer());
        }
    }

    public void clearStatModifier() {
        for (Map.Entry<String, List<PlayerStatModifier>> entry : this.statModifiers.entrySet()) {
            List<PlayerStatModifier> modifiers = entry.getValue();
            Iterator<PlayerStatModifier> i = modifiers.iterator();
            while (i.hasNext()) {
                PlayerStatModifier modifier = i.next();
                if (modifier.isPersistent()) continue;
                i.remove();
            }
            this.statModifiers.put(entry.getKey(), modifiers);
        }
        this.updatePlayerStat(this.getPlayer());
    }

    public void removeAttributeModifier(UUID uuid, boolean update) {
        for (Map.Entry<String, List<PlayerAttributeModifier>> entry : this.attributesModifiers.entrySet()) {
            List<PlayerAttributeModifier> modifiers = entry.getValue();
            Iterator<PlayerAttributeModifier> i = modifiers.iterator();
            while (i.hasNext()) {
                PlayerAttributeModifier modifier = i.next();
                if (!modifier.getUUID().equals(uuid)) continue;
                i.remove();
            }
            this.attributesModifiers.put(entry.getKey(), modifiers);
        }
        if (update) {
            this.updatePlayerStat(this.getPlayer());
        }
    }

    public void clearAttributeModifiers() {
        for (Map.Entry<String, List<PlayerAttributeModifier>> entry : this.attributesModifiers.entrySet()) {
            List<PlayerAttributeModifier> modifiers = entry.getValue();
            Iterator<PlayerAttributeModifier> i = modifiers.iterator();
            while (i.hasNext()) {
                PlayerAttributeModifier modifier = i.next();
                if (modifier.isPersistent()) continue;
                i.remove();
            }
            this.attributesModifiers.put(entry.getKey(), modifiers);
        }
        this.equips.update(this.getPlayer());
        this.updatePlayerStat(this.getPlayer());
    }

    public void clearAllModifiers() {
        this.clearStatModifier();
        this.clearAttributeModifiers();
    }

    public PlayerSkill getBoundSkill(Material mat) {
        return this.binds.get(mat);
    }

    public HashMap<Material, PlayerSkill> getBinds() {
        return this.binds;
    }

    public boolean isBound(Material mat) {
        return this.binds.containsKey(mat);
    }

    public boolean bind(Material mat, PlayerSkill skill) {
        if (mat == null || skill != null && skill.getPlayerData() != this) {
            return false;
        }
        PlayerSkill bound = this.getBoundSkill(mat);
        if (bound != skill) {
            if (skill == null) {
                this.binds.remove(mat);
            } else {
                this.binds.put(mat, skill);
            }
            if (bound != null) {
                bound.setBind(null);
            }
            if (skill != null) {
                skill.setBind(mat);
            }
            return true;
        }
        return false;
    }

    public boolean clearBind(Material mat) {
        return this.binds.remove(mat) != null;
    }

    public void clearBinds(Skill skill) {
        ArrayList<Material> keys = new ArrayList<Material>(this.binds.keySet());
        for (Material key : keys) {
            PlayerSkill bound = this.binds.get(key);
            if (bound.getData() != skill) continue;
            this.binds.remove(key);
        }
    }

    public void clearAllBinds() {
        this.binds.clear();
    }

    public void record(Player player) {
        this.lastHealth = player.getHealth();
    }

    public void updateScoreboard() {
        if (SkillAPI.getSettings().isShowScoreboard()) {
            SkillAPI.schedule(new ScoreboardTask(this), 2);
        }
    }

    public void startPassives(Player player) {
        if (player == null) {
            return;
        }
        this.passive = true;
        for (PlayerSkill skill : this.skills.values()) {
            if (!skill.isUnlocked() || !(skill.getData() instanceof PassiveSkill)) continue;
            ((PassiveSkill)((Object)skill.getData())).initialize((LivingEntity)player, skill.getLevel());
        }
    }

    public void stopPassives(Player player) {
        if (player == null) {
            return;
        }
        this.passive = false;
        for (PlayerSkill skill : this.skills.values()) {
            if (!skill.isUnlocked() || !(skill.getData() instanceof PassiveSkill)) continue;
            try {
                ((PassiveSkill)((Object)skill.getData())).stopEffects((LivingEntity)player, skill.getLevel());
            }
            catch (Exception ex) {
                Logger.bug("Failed to stop passive skill " + skill.getData().getName());
                ex.printStackTrace();
            }
        }
    }

    public boolean cast(String skillName) {
        return this.cast(this.skills.get(skillName.toLowerCase()));
    }

    public boolean cast(PlayerSkill skill) {
        if (skill == null) {
            throw new IllegalArgumentException("Skill cannot be null");
        }
        int level = skill.getLevel();
        if (!this.check(skill, true, true)) {
            return false;
        }
        Player p = this.getPlayer();
        if (p.isDead()) {
            return PlayerSkillCastFailedEvent.invoke(skill, PlayerSkillCastFailedEvent.Cause.CASTER_DEAD);
        }
        if (p.getGameMode().name().equals("SPECTATOR")) {
            return PlayerSkillCastFailedEvent.invoke(skill, PlayerSkillCastFailedEvent.Cause.SPECTATOR);
        }
        if (skill.getData() instanceof SkillShot) {
            PlayerCastSkillEvent event = new PlayerCastSkillEvent(this, skill, p);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                try {
                    if (((SkillShot)((Object)skill.getData())).cast((LivingEntity)p, level)) {
                        return this.applyUse(p, skill, event.getManaCost());
                    }
                    return PlayerSkillCastFailedEvent.invoke(skill, PlayerSkillCastFailedEvent.Cause.EFFECT_FAILED);
                }
                catch (Exception ex) {
                    Logger.bug("Failed to cast skill - " + skill.getData().getName() + ": Internal skill error");
                    ex.printStackTrace();
                    return PlayerSkillCastFailedEvent.invoke(skill, PlayerSkillCastFailedEvent.Cause.EFFECT_FAILED);
                }
            }
            return PlayerSkillCastFailedEvent.invoke(skill, PlayerSkillCastFailedEvent.Cause.CANCELED);
        }
        if (skill.getData() instanceof TargetSkill) {
            LivingEntity target = TargetHelper.getLivingTarget((LivingEntity)p, skill.getData().getRange(level));
            if (target == null) {
                return PlayerSkillCastFailedEvent.invoke(skill, PlayerSkillCastFailedEvent.Cause.NO_TARGET);
            }
            PlayerCastSkillEvent event = new PlayerCastSkillEvent(this, skill, p);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                try {
                    boolean canAttack;
                    boolean bl = canAttack = !SkillAPI.getSettings().canAttack((LivingEntity)p, target);
                    if (((TargetSkill)((Object)skill.getData())).cast((LivingEntity)p, target, level, canAttack)) {
                        return this.applyUse(p, skill, event.getManaCost());
                    }
                    return PlayerSkillCastFailedEvent.invoke(skill, PlayerSkillCastFailedEvent.Cause.EFFECT_FAILED);
                }
                catch (Exception ex) {
                    Logger.bug("Failed to cast skill - " + skill.getData().getName() + ": Internal skill error");
                    ex.printStackTrace();
                    return PlayerSkillCastFailedEvent.invoke(skill, PlayerSkillCastFailedEvent.Cause.EFFECT_FAILED);
                }
            }
            PlayerSkillCastFailedEvent.invoke(skill, PlayerSkillCastFailedEvent.Cause.CANCELED);
        }
        return false;
    }

    private boolean applyUse(Player player, PlayerSkill skill, double manaCost) {
        player.setMetadata("custom-cooldown", (MetadataValue)new FixedMetadataValue((Plugin)SkillAPI.inst(), (Object)1));
        skill.startCooldown();
        if (SkillAPI.getSettings().isShowSkillMessages()) {
            skill.getData().sendMessage(player, SkillAPI.getSettings().getMessageRadius());
        }
        if (SkillAPI.getSettings().isManaEnabled()) {
            this.useMana(manaCost, ManaCost.SKILL_CAST);
        }
        this.skillTimer = System.currentTimeMillis() + SkillAPI.getSettings().getCastCooldown();
        if (this.removeTimer != null && !this.removeTimer.isCancelled()) {
            this.removeTimer.cancel();
        }
        this.removeTimer = Bukkit.getScheduler().runTaskLater((Plugin)SkillAPI.inst(), () -> player.removeMetadata("custom-cooldown", (Plugin)SkillAPI.inst()), 20L);
        return true;
    }

    public boolean check(PlayerSkill skill, boolean cooldown, boolean mana) {
        if (skill == null || System.currentTimeMillis() < this.skillTimer) {
            return false;
        }
        SkillStatus status = skill.getStatus();
        int level = skill.getLevel();
        double cost = skill.getData().getManaCost(level);
        if (level <= 0) {
            return PlayerSkillCastFailedEvent.invoke(skill, PlayerSkillCastFailedEvent.Cause.NOT_UNLOCKED);
        }
        if (status == SkillStatus.ON_COOLDOWN && cooldown) {
            if (skill.getData().cooldownMessage() && !this.onCooldown.contains(this.getUUID())) {
                SkillAPI.getLanguage().sendMessage("Errors.on-cooldown", (CommandSender)this.getPlayer(), FilterType.COLOR, new CustomFilter[]{RPGFilter.COOLDOWN.setReplacement("" + skill.getCooldown()), RPGFilter.SKILL.setReplacement(skill.getData().getName())});
                this.onCooldown.add(this.getUUID());
                Bukkit.getScheduler().runTaskLater((Plugin)SkillAPI.inst(), () -> this.onCooldown.remove(this.getUUID()), 40L);
            }
            return PlayerSkillCastFailedEvent.invoke(skill, PlayerSkillCastFailedEvent.Cause.ON_COOLDOWN);
        }
        if (status == SkillStatus.MISSING_MANA && mana) {
            SkillAPI.getLanguage().sendMessage("Errors.no-mana", (CommandSender)this.getPlayer(), FilterType.COLOR, new CustomFilter[]{RPGFilter.SKILL.setReplacement(skill.getData().getName()), RPGFilter.MANA.setReplacement("" + this.getMana()), RPGFilter.COST.setReplacement("" + (int)Math.ceil(cost)), RPGFilter.MISSING.setReplacement("" + (int)Math.ceil(cost - this.getMana()))});
            return PlayerSkillCastFailedEvent.invoke(skill, PlayerSkillCastFailedEvent.Cause.NO_MANA);
        }
        return true;
    }

    public void init(Player player) {
        if (!SkillAPI.getSettings().isWorldEnabled(player.getWorld())) {
            return;
        }
        this.getEquips().update(player);
        this.updatePlayerStat(player);
        this.startPassives(player);
        this.updateScoreboard();
        if (this.getLastHealth() > 0.0 && !player.isDead()) {
            player.setHealth(Math.min(this.getLastHealth(), player.getMaxHealth()));
        }
        this.autoLevel();
        this.updateScoreboard();
    }

    public static class ExternallyAddedSkill {
        private final String id;
        private final NamespacedKey key;
        private final int level;

        public ExternallyAddedSkill(String id, NamespacedKey key, int level) {
            this.id = id;
            this.key = key;
            this.level = level;
        }

        public String getId() {
            return this.id;
        }

        public NamespacedKey getKey() {
            return this.key;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

