/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.particle;

import com.sucy.skill.api.particle.direction.DirectionHandler;
import com.sucy.skill.data.Point2D;
import com.sucy.skill.data.Point3D;
import com.sucy.skill.data.formula.Formula;
import com.sucy.skill.data.formula.IValue;
import com.sucy.skill.data.formula.value.CustomValue;
import java.util.HashMap;
import mc.promcteam.engine.mccore.config.parse.DataSection;

public class PolarSettings {
    private final HashMap<DirectionHandler, Point3D[]> points = new HashMap();
    private final Point2D[][] trig;
    private final IValue formula;
    private final int copies;
    private final int steps;
    private final double domain;
    private double xOff;
    private double yOff;
    private double zOff;

    public PolarSettings(IValue formula, int steps) {
        this(formula, steps, 1, 1.0);
    }

    public PolarSettings(IValue formula, int steps, int copies, double domain) {
        this.formula = formula;
        this.copies = Math.max(1, copies);
        this.domain = Math.max(0.0, domain / (double)steps);
        this.steps = Math.max(1, steps);
        double angle = Math.PI * 2 * this.domain;
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double copyCos = Math.cos(Math.PI * 2 / (double)copies);
        double copySin = Math.sin(Math.PI * 2 / (double)copies);
        this.trig = new Point2D[steps][copies];
        Point2D rot = new Point2D(1.0, 0.0);
        Point2D copy = new Point2D();
        for (int i = 0; i < steps; ++i) {
            copy.x = rot.x;
            copy.y = rot.y;
            for (int j = 0; j < copies; ++j) {
                this.trig[i][j] = new Point2D(copy.x, copy.y);
                copy.rotate(copyCos, copySin);
            }
            rot.rotate(cos, sin);
        }
    }

    public PolarSettings(DataSection settings) {
        this(new Formula(settings.getString("formula"), new CustomValue("t"), new CustomValue("p"), new CustomValue("c"), new CustomValue("s")), settings.getInt("steps"), settings.getInt("copies"), settings.getDouble("domain"));
        this.setOffset(settings.getDouble("x"), settings.getDouble("y"), settings.getDouble("z"));
    }

    public Point2D[] getTrig(int step) {
        return this.trig[step];
    }

    public int getCopies() {
        return this.copies;
    }

    public int getSteps() {
        return this.steps;
    }

    public PolarSettings setOffset(double x, double y, double z) {
        this.xOff = x;
        this.yOff = y;
        this.zOff = z;
        return this;
    }

    public Point3D[] getPoints(DirectionHandler direction) {
        if (!this.points.containsKey(direction)) {
            this.calculate(direction);
        }
        return this.points.get(direction);
    }

    private void calculate(DirectionHandler direction) {
        Point3D[] points = new Point3D[this.copies * this.steps];
        this.points.put(direction, points);
        int k = 0;
        for (int i = 0; i < this.steps; ++i) {
            Point2D rot = this.trig[i][0];
            double t = this.domain * (double)i;
            double r = this.formula.compute(t, (double)i / (double)this.steps, rot.x, rot.y);
            for (int j = 0; j < this.copies; ++j) {
                Point2D copy = this.trig[i][j];
                Point3D p = new Point3D();
                direction.apply(p, r * copy.x, r * copy.y);
                p.x += this.xOff;
                p.y += this.yOff;
                p.z += this.zOff;
                points[k++] = p;
            }
        }
    }

    public double getT(int step) {
        return this.domain * (double)step;
    }
}

