/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.particle;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.particle.EffectData;
import com.sucy.skill.api.particle.EffectInstance;
import com.sucy.skill.api.particle.ParticleEffect;
import com.sucy.skill.api.particle.PolarSettings;
import com.sucy.skill.api.particle.direction.XZHandler;
import com.sucy.skill.api.particle.target.EffectTarget;
import com.sucy.skill.api.particle.target.EntityTarget;
import com.sucy.skill.task.EffectTask;
import com.sucy.skill.thread.MainThread;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mc.promcteam.engine.mccore.config.CommentedConfig;
import mc.promcteam.engine.mccore.config.parse.DataSection;
import org.bukkit.entity.LivingEntity;

public class EffectManager {
    private static Map<EffectTarget, EffectData> instances = new ConcurrentHashMap<EffectTarget, EffectData>();
    private static Map<String, ParticleEffect> effects = new HashMap<String, ParticleEffect>();
    private static Map<String, PolarSettings> formulas = new HashMap<String, PolarSettings>();

    public static void init() {
        CommentedConfig config = SkillAPI.getConfig("effects");
        config.saveDefaultConfig();
        DataSection data = config.getConfig();
        for (String key : data.keys()) {
            formulas.put(key, new PolarSettings(data.getSection(key)));
            if (!key.equals("one-circle")) continue;
            formulas.get(key).getPoints(XZHandler.instance);
        }
        MainThread.register(new EffectTask());
    }

    public static void cleanUp() {
        formulas.clear();
        effects.clear();
        instances.clear();
    }

    public static void register(ParticleEffect effect) {
        if (effect != null) {
            effects.put(effect.getName(), effect);
        }
    }

    public static void register(String key, PolarSettings formula) {
        if (formula != null) {
            formulas.put(key, formula);
        }
    }

    public static PolarSettings getFormula(String key) {
        return formulas.get(key);
    }

    public static ParticleEffect getEffect(String name) {
        return effects.get(name);
    }

    public static void clear(EffectTarget target) {
        instances.remove(target);
    }

    public static void clear(LivingEntity target) {
        instances.entrySet().removeIf(entry -> entry.getKey() instanceof EntityTarget && ((EntityTarget)entry.getKey()).getEntity() == target);
    }

    public static EffectData getEffectData(EffectTarget target) {
        return instances.get(target);
    }

    public static EffectInstance getEffect(EffectTarget target, String key) {
        if (!instances.containsKey(target)) {
            return null;
        }
        return instances.get(target).getEffect(key);
    }

    public static void runEffect(ParticleEffect effect, EffectTarget target, int ticks, int level) {
        if (!instances.containsKey(target)) {
            instances.put(target, new EffectData(target));
        }
        instances.get(target).runEffect(effect, ticks, level);
    }

    public static void tick() {
        Iterator<EffectData> iterator = instances.values().iterator();
        while (iterator.hasNext()) {
            EffectData data = iterator.next();
            if (data.isValid()) {
                data.tick();
                continue;
            }
            iterator.remove();
        }
    }
}

