/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.particle;

import com.sucy.skill.api.particle.EffectInstance;
import com.sucy.skill.api.particle.ParticleEffect;
import com.sucy.skill.api.particle.target.EffectTarget;
import java.util.HashMap;
import java.util.Iterator;

public class EffectData {
    private HashMap<String, EffectInstance> effects = new HashMap();
    private EffectTarget target;

    public EffectData(EffectTarget target) {
        this.target = target;
    }

    public boolean isEffectActive(String key) {
        return this.effects.containsKey(key);
    }

    public EffectInstance getEffect(String key) {
        return this.effects.get(key);
    }

    public boolean isValid() {
        return this.effects.size() > 0 && this.target.isValid();
    }

    public void runEffect(ParticleEffect effect, int ticks, int level) {
        EffectInstance instance = new EffectInstance(effect, this.target, level);
        instance.extend(ticks);
        this.effects.put(effect.getName(), instance);
    }

    public void cancel(String key) {
        this.effects.remove(key);
    }

    public void tick() {
        Iterator<EffectInstance> iterator = this.effects.values().iterator();
        while (iterator.hasNext()) {
            EffectInstance effect = iterator.next();
            if (effect.isValid()) {
                effect.tick();
                continue;
            }
            iterator.remove();
        }
    }
}

