/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.event;

import com.sucy.skill.api.enums.PointSource;
import com.sucy.skill.api.player.PlayerClass;
import com.sucy.skill.api.player.PlayerData;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class PlayerGainSkillPointsEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private PlayerClass playerClass;
    private boolean cancelled;
    private PointSource source;
    private double amount;

    public PlayerGainSkillPointsEvent(PlayerClass playerClass, double amount, PointSource source) {
        this.playerClass = playerClass;
        this.amount = amount;
        this.source = source;
        this.cancelled = false;
    }

    public PlayerData getPlayerData() {
        return this.playerClass.getPlayerData();
    }

    public PlayerClass getPlayerClass() {
        return this.playerClass;
    }

    public double getAmount() {
        return this.amount;
    }

    public PointSource getSource() {
        return this.source;
    }

    public void setAmount(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Points cannot be negative");
        }
        this.amount = amount;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

