/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.armorstand;

import com.sucy.skill.api.armorstand.ArmorStandInstance;
import java.util.HashMap;
import java.util.Iterator;
import org.bukkit.entity.LivingEntity;

public class ArmorStandData {
    private final HashMap<String, ArmorStandInstance> armorStands = new HashMap();
    private final LivingEntity target;

    public ArmorStandData(LivingEntity target) {
        this.target = target;
    }

    public boolean isValid() {
        return this.armorStands.size() > 0 && this.target.isValid();
    }

    public ArmorStandInstance getArmorStands(String key) {
        return this.armorStands.get(key);
    }

    public void register(ArmorStandInstance armorStand, String key) {
        ArmorStandInstance oldArmorStand = this.armorStands.put(key, armorStand);
        if (oldArmorStand != null) {
            oldArmorStand.remove();
        }
    }

    public void tick() {
        Iterator<ArmorStandInstance> iterator = this.armorStands.values().iterator();
        while (iterator.hasNext()) {
            ArmorStandInstance armorStand = iterator.next();
            if (armorStand.isValid()) {
                armorStand.tick();
                continue;
            }
            armorStand.remove();
            iterator.remove();
        }
    }

    public void remove() {
        this.armorStands.values().forEach(ArmorStandInstance::remove);
        this.armorStands.clear();
    }
}

