/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api;

import com.sucy.skill.api.DefaultCombatProtection;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;

public interface CombatProtection {
    public static boolean canAttack(LivingEntity attacker, LivingEntity target, boolean passiveAlly) {
        return CombatProtection.canAttack(attacker, target, passiveAlly, EntityDamageEvent.DamageCause.CUSTOM);
    }

    public static boolean canAttack(LivingEntity attacker, LivingEntity target, boolean passiveAlly, EntityDamageEvent.DamageCause cause) {
        OfflinePlayer owner;
        Tameable entity;
        if (attacker == target) {
            return false;
        }
        if (attacker instanceof Tameable && (entity = (Tameable)target).isTamed() && entity.getOwner() instanceof OfflinePlayer && (owner = (OfflinePlayer)entity.getOwner()).isOnline()) {
            attacker = owner.getPlayer();
        }
        if (target instanceof Tameable) {
            entity = (Tameable)target;
            if (entity.isTamed() && entity.getOwner() instanceof OfflinePlayer && (owner = (OfflinePlayer)entity.getOwner()).isOnline()) {
                return CombatProtection.canAttack(attacker, (LivingEntity)owner.getPlayer(), false);
            }
        } else if (passiveAlly && target instanceof Animals) {
            return false;
        }
        DefaultCombatProtection.FakeEntityDamageByEntityEvent event = new DefaultCombatProtection.FakeEntityDamageByEntityEvent((Entity)attacker, (Entity)target, cause, 1.0);
        Bukkit.getPluginManager().callEvent((Event)event);
        boolean attackable = !event.isExternallyCancelled();
        event.setCancelled(true);
        return attackable;
    }

    public boolean canAttack(Player var1, Player var2);

    public boolean canAttack(Player var1, LivingEntity var2);

    public boolean canAttack(LivingEntity var1, LivingEntity var2);

    public boolean canAttack(Player var1, Player var2, EntityDamageEvent.DamageCause var3);

    public boolean canAttack(Player var1, LivingEntity var2, EntityDamageEvent.DamageCause var3);

    public boolean canAttack(LivingEntity var1, LivingEntity var2, EntityDamageEvent.DamageCause var3);
}

