/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill;

import com.sucy.skill.DependencyRequirement;
import com.sucy.skill.api.armorstand.ArmorStandManager;
import com.sucy.skill.api.classes.RPGClass;
import com.sucy.skill.api.particle.EffectManager;
import com.sucy.skill.api.player.PlayerAccounts;
import com.sucy.skill.api.player.PlayerClass;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.player.PlayerSkill;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.data.PlayerStats;
import com.sucy.skill.data.Settings;
import com.sucy.skill.data.io.ConfigIO;
import com.sucy.skill.data.io.IOManager;
import com.sucy.skill.data.io.SQLIO;
import com.sucy.skill.dynamic.DynamicClass;
import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.exception.SkillAPINotEnabledException;
import com.sucy.skill.gui.tool.GUITool;
import com.sucy.skill.hook.PlaceholderAPIHook;
import com.sucy.skill.hook.PluginChecker;
import com.sucy.skill.hook.mimic.MimicHook;
import com.sucy.skill.listener.AddonListener;
import com.sucy.skill.listener.BarListener;
import com.sucy.skill.listener.BindListener;
import com.sucy.skill.listener.BuffListener;
import com.sucy.skill.listener.CastCombatListener;
import com.sucy.skill.listener.CastItemListener;
import com.sucy.skill.listener.CastListener;
import com.sucy.skill.listener.CastOffhandListener;
import com.sucy.skill.listener.ClickListener;
import com.sucy.skill.listener.CombatProtectionListener;
import com.sucy.skill.listener.ComboListener;
import com.sucy.skill.listener.DeathListener;
import com.sucy.skill.listener.ExperienceListener;
import com.sucy.skill.listener.ItemListener;
import com.sucy.skill.listener.KillListener;
import com.sucy.skill.listener.LingeringPotionListener;
import com.sucy.skill.listener.MainListener;
import com.sucy.skill.listener.MechanicListener;
import com.sucy.skill.listener.ProjectileListener;
import com.sucy.skill.listener.SkillAPIListener;
import com.sucy.skill.listener.StatusListener;
import com.sucy.skill.listener.ToolListener;
import com.sucy.skill.listener.attribute.AttributeListener;
import com.sucy.skill.listener.attribute.RPGAttributeListener;
import com.sucy.skill.manager.AttributeManager;
import com.sucy.skill.manager.ClassBoardManager;
import com.sucy.skill.manager.CmdManager;
import com.sucy.skill.manager.ComboManager;
import com.sucy.skill.manager.RegistrationManager;
import com.sucy.skill.manager.ResourceManager;
import com.sucy.skill.task.CooldownTask;
import com.sucy.skill.task.GUITask;
import com.sucy.skill.task.ManaTask;
import com.sucy.skill.task.SaveTask;
import com.sucy.skill.thread.MainThread;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mc.promcteam.engine.NexEngine;
import mc.promcteam.engine.mccore.config.CommentedConfig;
import mc.promcteam.engine.mccore.config.CommentedLanguageConfig;
import mc.promcteam.engine.mccore.util.VersionManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class SkillAPI
extends JavaPlugin {
    private static SkillAPI singleton;
    private final HashMap<String, Skill> skills = new HashMap();
    private final HashMap<String, RPGClass> classes = new HashMap();
    private final HashMap<String, PlayerAccounts> players = new HashMap();
    private final ArrayList<String> groups = new ArrayList();
    private final List<SkillAPIListener> listeners = new ArrayList<SkillAPIListener>();
    private CommentedLanguageConfig language;
    private Settings settings;
    private IOManager io;
    private CmdManager cmd;
    private ComboManager comboManager;
    private RegistrationManager registrationManager;
    private AttributeManager attributeManager;
    private MainThread mainThread;
    private BukkitTask manaTask;
    private boolean loaded = false;
    private boolean disabling = false;

    public SkillAPI() {
    }

    public SkillAPI(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file);
    }

    public static boolean isLoaded() {
        return singleton != null && SkillAPI.singleton.loaded;
    }

    public static SkillAPI inst() {
        if (singleton == null) {
            throw new SkillAPINotEnabledException("Cannot use SkillAPI methods before it is enabled - add it to your plugin.yml as a dependency");
        }
        return singleton;
    }

    public static Settings getSettings() {
        return SkillAPI.inst().settings;
    }

    public static CommentedLanguageConfig getLanguage() {
        return SkillAPI.inst().language;
    }

    public static ComboManager getComboManager() {
        return SkillAPI.inst().comboManager;
    }

    public static AttributeManager getAttributeManager() {
        return SkillAPI.inst().attributeManager;
    }

    public static Skill getSkill(String name) {
        if (name == null) {
            return null;
        }
        return SkillAPI.inst().skills.get(name.toLowerCase());
    }

    public static HashMap<String, Skill> getSkills() {
        return SkillAPI.inst().skills;
    }

    public static boolean isSkillRegistered(String name) {
        return SkillAPI.getSkill(name) != null;
    }

    public static boolean isSkillRegistered(PlayerSkill skill) {
        return SkillAPI.isSkillRegistered(skill.getData().getName());
    }

    public static boolean isSkillRegistered(Skill skill) {
        return SkillAPI.isSkillRegistered(skill.getName());
    }

    public static RPGClass getClass(String name) {
        if (name == null) {
            return null;
        }
        return SkillAPI.inst().classes.get(name.toLowerCase());
    }

    public static HashMap<String, RPGClass> getClasses() {
        return SkillAPI.inst().classes;
    }

    public static ArrayList<RPGClass> getBaseClasses(String group) {
        ArrayList<RPGClass> list = new ArrayList<RPGClass>();
        for (RPGClass c : SkillAPI.singleton.classes.values()) {
            if (c.hasParent() || !c.getGroup().equals(group)) continue;
            list.add(c);
        }
        return list;
    }

    public static boolean isClassRegistered(String name) {
        return SkillAPI.getClass(name) != null;
    }

    public static boolean isClassRegistered(PlayerClass playerClass) {
        return SkillAPI.isClassRegistered(playerClass.getData().getName());
    }

    public static boolean isClassRegistered(RPGClass rpgClass) {
        return SkillAPI.isClassRegistered(rpgClass.getName());
    }

    public static PlayerData getPlayerData(OfflinePlayer player) {
        if (player == null) {
            return null;
        }
        return SkillAPI.getPlayerAccountData(player).getActiveData();
    }

    public static PlayerAccounts loadPlayerData(OfflinePlayer player) {
        if (player == null) {
            return null;
        }
        String id = player.getUniqueId().toString().toLowerCase();
        if (SkillAPI.inst().players.containsKey(id)) {
            return SkillAPI.singleton.players.get(id);
        }
        return SkillAPI.doLoad(player);
    }

    private static PlayerAccounts doLoad(OfflinePlayer player) {
        PlayerAccounts data = SkillAPI.singleton.io.loadData(player);
        SkillAPI.singleton.players.put(player.getUniqueId().toString(), data);
        return data;
    }

    public static void initFakeData(OfflinePlayer player) {
        SkillAPI.inst().players.computeIfAbsent(player.getUniqueId().toString(), id -> new PlayerAccounts(player));
    }

    public static void reloadPlayerData(Player player) {
        SkillAPI.doLoad((OfflinePlayer)player);
    }

    public static void saveData() {
        SkillAPI.inst().io.saveAll();
    }

    public static boolean hasPlayerData(OfflinePlayer player) {
        return singleton != null && player != null && SkillAPI.singleton.players.containsKey(player.getUniqueId().toString().toLowerCase());
    }

    public static void unloadPlayerData(OfflinePlayer player) {
        SkillAPI.unloadPlayerData(player, false);
    }

    public static void unloadPlayerData(OfflinePlayer player, boolean skipSaving) {
        if (singleton == null || player == null || SkillAPI.singleton.disabling || !SkillAPI.singleton.players.containsKey(player.getUniqueId().toString().toLowerCase())) {
            return;
        }
        singleton.getServer().getScheduler().runTaskAsynchronously((Plugin)singleton, () -> {
            PlayerAccounts accounts = SkillAPI.getPlayerAccountData(player);
            if (!skipSaving) {
                SkillAPI.singleton.io.saveData(accounts);
            }
            SkillAPI.singleton.players.remove(player.getUniqueId().toString().toLowerCase());
        });
    }

    public static PlayerAccounts getPlayerAccountData(OfflinePlayer player) {
        if (player == null) {
            return null;
        }
        String id = player.getUniqueId().toString().toLowerCase();
        if (!SkillAPI.inst().players.containsKey(id)) {
            PlayerAccounts data = SkillAPI.loadPlayerData(player);
            SkillAPI.singleton.players.put(id, data);
            return data;
        }
        return SkillAPI.singleton.players.get(id);
    }

    public static HashMap<String, PlayerAccounts> getPlayerAccountData() {
        return SkillAPI.inst().players;
    }

    public static List<String> getGroups() {
        return SkillAPI.inst().groups;
    }

    public static BukkitTask schedule(BukkitRunnable runnable, int delay) {
        return runnable.runTaskLater((Plugin)SkillAPI.inst(), (long)delay);
    }

    public static BukkitTask schedule(Runnable runnable, int delay) {
        return Bukkit.getScheduler().runTaskLater((Plugin)singleton, runnable, (long)delay);
    }

    public static BukkitTask schedule(BukkitRunnable runnable, int delay, int period) {
        return runnable.runTaskTimer((Plugin)SkillAPI.inst(), (long)delay, (long)period);
    }

    public static void setMeta(Metadatable target, String key, Object value) {
        target.setMetadata(key, (MetadataValue)new FixedMetadataValue((Plugin)SkillAPI.inst(), value));
    }

    public static Object getMeta(Metadatable target, String key) {
        List meta = target.getMetadata(key);
        return meta == null || meta.size() == 0 ? null : ((MetadataValue)meta.get(0)).value();
    }

    public static int getMetaInt(Metadatable target, String key) {
        return ((MetadataValue)target.getMetadata(key).get(0)).asInt();
    }

    public static double getMetaDouble(Metadatable target, String key) {
        return ((MetadataValue)target.getMetadata(key).get(0)).asDouble();
    }

    public static void removeMeta(Metadatable target, String key) {
        target.removeMetadata(key, (Plugin)SkillAPI.inst());
    }

    public static CommentedConfig getConfig(String name) {
        return new CommentedConfig((JavaPlugin)singleton, name);
    }

    public static void reload() {
        SkillAPI inst = SkillAPI.inst();
        inst.onDisable();
        inst.onEnable();
    }

    public void onLoad() {
        MimicHook.init((Plugin)this);
    }

    public void onDisable() {
        if (!this.isEnabled()) {
            return;
        }
        if (singleton != this) {
            throw new IllegalStateException("This is not a valid, enabled SkillAPI copy!");
        }
        this.disabling = true;
        GUITool.cleanUp();
        EffectManager.cleanUp();
        ArmorStandManager.cleanUp();
        this.mainThread.disable();
        this.mainThread = null;
        if (this.manaTask != null) {
            this.manaTask.cancel();
            this.manaTask = null;
        }
        for (SkillAPIListener listener : this.listeners) {
            listener.cleanup();
        }
        this.listeners.clear();
        ClassBoardManager.clearAll();
        for (Player player : VersionManager.getOnlinePlayers()) {
            MainListener.unload(player);
        }
        this.io.saveAll();
        this.skills.clear();
        this.classes.clear();
        this.players.clear();
        HandlerList.unregisterAll((Plugin)this);
        this.cmd.clear();
        this.loaded = false;
        this.disabling = false;
        singleton = null;
    }

    public void onEnable() {
        if (singleton != null) {
            throw new IllegalStateException("Cannot enable SkillAPI twice!");
        }
        String coreVersion = NexEngine.getEngine().getDescription().getVersion();
        if (!DependencyRequirement.meetsVersion("1.0.4-R0.13-SNAPSHOT", coreVersion)) {
            this.getLogger().warning("Missing required ProMCCore version. " + coreVersion + " installed. 1.0.4-R0.13-SNAPSHOT required. Disabling.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        singleton = this;
        this.mainThread = new MainThread();
        EffectManager.init();
        ArmorStandManager.init();
        this.settings = new Settings(this);
        this.settings.reload();
        this.language = new CommentedLanguageConfig((JavaPlugin)this, "language");
        this.language.checkDefaults();
        this.language.trim();
        this.language.save();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceholderAPIHook(this).register();
            this.getLogger().info("ProSkillAPI hook into PlaceholderAPI: " + ChatColor.GREEN + "success.");
        }
        this.comboManager = new ComboManager();
        this.registrationManager = new RegistrationManager(this);
        this.cmd = new CmdManager(this);
        this.io = this.settings.isUseSql() ? new SQLIO(this) : new ConfigIO(this);
        PlayerStats.init();
        ClassBoardManager.registerText();
        if (this.settings.isAttributesEnabled()) {
            this.attributeManager = new AttributeManager(this);
        }
        this.registrationManager.initialize();
        this.settings.loadGroupSettings();
        this.listen(new BindListener(), true);
        this.listen(new BuffListener(), true);
        this.listen(new MainListener(), true);
        this.listen(new MechanicListener(), true);
        this.listen(new ProjectileListener(), true);
        this.listen(new StatusListener(), true);
        this.listen(new ToolListener(), true);
        this.listen(new KillListener(), true);
        this.listen(new AddonListener(), true);
        this.listen(new ClickListener(), true);
        this.listen(new BarListener(), this.settings.isSkillBarEnabled());
        this.listen(new ComboListener(), this.settings.isCombosEnabled());
        this.listen(new AttributeListener(), this.settings.isAttributesEnabled());
        this.listen(new ItemListener(), this.settings.isCheckLore() || this.settings.isCheckAttributes());
        this.listen(new CastListener(), this.settings.isUsingBars());
        this.listen(new CastOffhandListener(), this.settings.isCastEnabled() && VersionManager.isVersionAtLeast((int)VersionManager.V1_9_0));
        this.listen(new CastItemListener(), this.settings.isUsingWand());
        this.listen(new CastCombatListener(), this.settings.isUsingCombat());
        this.listen(new DeathListener(), !VersionManager.isVersionAtLeast((int)11000));
        this.listen(new CombatProtectionListener(), VersionManager.isVersionAtLeast((int)11000));
        this.listen(new LingeringPotionListener(), VersionManager.isVersionAtLeast((int)VersionManager.V1_9_0));
        this.listen(new ExperienceListener(), this.settings.isYieldsEnabled());
        this.listen(new PluginChecker(), true);
        this.listen(new RPGAttributeListener(), this.getServer().getPluginManager().isPluginEnabled("ProRPGItems"));
        if (this.settings.isManaEnabled()) {
            if (VersionManager.isVersionAtLeast((int)11400)) {
                this.manaTask = Bukkit.getScheduler().runTaskTimer((Plugin)this, (Runnable)new ManaTask(), (long)SkillAPI.getSettings().getGainFreq(), (long)SkillAPI.getSettings().getGainFreq());
            } else {
                MainThread.register(new ManaTask());
            }
        }
        if (this.settings.isSkillBarCooldowns()) {
            MainThread.register(new CooldownTask());
        }
        if (this.settings.isAutoSave()) {
            MainThread.register(new SaveTask(this));
        }
        MainThread.register(new GUITask(this));
        GUITool.init();
        this.players.putAll(this.io.loadAll());
        for (PlayerAccounts accounts : this.players.values()) {
            accounts.getActiveData().init(accounts.getPlayer());
        }
        for (SkillAPIListener listener : this.listeners) {
            listener.init();
        }
        if (Bukkit.getServer().getPluginManager().getPlugin("Quests") != null) {
            ResourceManager.copyQuestsModule();
        }
        this.loaded = true;
    }

    public void listen(SkillAPIListener listener, boolean enabled) {
        if (enabled) {
            Iterator<SkillAPIListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                SkillAPIListener listener1 = iterator.next();
                if (!listener.getClass().equals(listener1.getClass())) continue;
                HandlerList.unregisterAll((Listener)listener1);
                iterator.remove();
            }
            Bukkit.getPluginManager().registerEvents((Listener)listener, (Plugin)this);
            this.listeners.add(listener);
        }
    }

    public void addDynamicSkill(DynamicSkill skill) {
        if (!this.registrationManager.isAddingDynamicSkills()) {
            throw new IllegalStateException("Cannot add dynamic skills from outside SkillAPI");
        }
        this.skills.put(skill.getName().toLowerCase(), skill);
    }

    public void addSkill(Skill skill) {
        if ((skill = this.registrationManager.validate(skill)) != null) {
            this.skills.put(skill.getName().toLowerCase(), skill);
        }
    }

    public void addSkills(Skill ... skills) {
        for (Skill skill : skills) {
            this.addSkill(skill);
        }
    }

    public void addClass(RPGClass rpgClass) {
        if ((rpgClass = this.registrationManager.validate(rpgClass)) != null) {
            this.classes.put(rpgClass.getName().toLowerCase(), rpgClass);
            ClassBoardManager.registerClass(rpgClass);
            if (!this.groups.contains(rpgClass.getGroup())) {
                this.groups.add(rpgClass.getGroup());
            }
        }
    }

    public void addDynamicClass(DynamicClass rpgClass) {
        String key;
        if (rpgClass != null && !this.classes.containsKey(key = rpgClass.getName().toLowerCase())) {
            this.classes.put(key, rpgClass);
            ClassBoardManager.registerClass(rpgClass);
            if (!this.groups.contains(rpgClass.getGroup())) {
                this.groups.add(rpgClass.getGroup());
            }
        }
    }

    public void addClasses(RPGClass ... classes) {
        for (RPGClass rpgClass : classes) {
            this.addClass(rpgClass);
        }
    }
}

