/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.tree.basic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.classes.RPGClass;
import com.sucy.skill.api.exception.SkillTreeException;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.gui.tool.GUITool;
import com.sucy.skill.language.RPGFilter;
import com.sucy.skill.tree.SkillTree;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import mc.promcteam.engine.mccore.config.CustomFilter;
import mc.promcteam.engine.mccore.config.Filter;
import mc.promcteam.engine.mccore.config.FilterType;
import mc.promcteam.engine.mccore.items.InventoryManager;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public abstract class InventoryTree
extends SkillTree {
    protected static final Comparator<Skill> comparator = new Comparator<Skill>(){

        @Override
        public int compare(Skill skill1, Skill skill2) {
            return skill1.getSkillReq() != null && skill2.getSkillReq() == null ? 1 : (skill1.getSkillReq() == null && skill2.getSkillReq() != null ? -1 : (skill1.getLevelReq(0) > skill2.getLevelReq(0) ? 1 : (skill1.getLevelReq(0) < skill2.getLevelReq(0) ? -1 : (skill1.getCost(0) > skill2.getCost(0) ? 1 : (skill1.getCost(0) < skill2.getCost(0) ? -1 : skill1.getName().compareTo(skill2.getName()))))));
        }
    };
    private static final String INVENTORY_KEY = "SAPI_ST";
    protected final HashMap<Integer, Skill> skillSlots = new HashMap();
    protected int height;

    public InventoryTree(SkillAPI api, RPGClass tree) {
        super(api, tree);
    }

    public void show(Player player) {
        player.openInventory(this.getInventory(SkillAPI.getPlayerData((OfflinePlayer)player)));
    }

    public Inventory getInventory(PlayerData player) {
        GUITool.getSkillTree(this.tree);
        Inventory inv = InventoryManager.createInventory((String)INVENTORY_KEY, (int)this.height, (String)((String)SkillAPI.getLanguage().getMessage("GUI.skill-tree", true, FilterType.COLOR, new CustomFilter[]{RPGFilter.CLASS.setReplacement(this.tree.getName()), Filter.PLAYER.setReplacement(player.getPlayerName())}).get(0)));
        Player p = player.getPlayer();
        for (Map.Entry<Integer, Skill> entry : this.skillSlots.entrySet()) {
            if (!this.canShow(p, entry.getValue())) continue;
            inv.setItem(entry.getKey().intValue(), entry.getValue().getIndicator(player.getSkill(entry.getValue().getName()), false));
        }
        return inv;
    }

    public boolean checkClick(int slot) {
        return this.skillSlots.containsKey(slot);
    }

    public boolean isSkill(HumanEntity player, int slot) {
        return this.skillSlots.get(slot) != null && player != null && this.skillSlots.get(slot).isAllowed((Player)player);
    }

    public Skill getSkill(int slot) {
        return this.skillSlots.get(slot);
    }

    public HashMap<Integer, Skill> getSkillSlots() {
        return this.skillSlots;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public void arrange() throws SkillTreeException {
        super.arrange();
        if (this.height > 6) {
            throw new SkillTreeException("Error generating the skill tree: " + this.tree.getName() + " - too large of a tree!");
        }
    }

    public void update(PlayerData player) {
        InventoryView view = player.getPlayer().getOpenInventory();
        for (Map.Entry<Integer, Skill> skills : this.skillSlots.entrySet()) {
            view.setItem(skills.getKey().intValue(), skills.getValue().getIndicator(player.getSkill(skills.getValue().getName()), false));
        }
    }

    @Override
    public boolean hasSkill(Skill skill) {
        return this.skillSlots.containsValue(skill);
    }
}

