/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.tree.basic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.classes.RPGClass;
import com.sucy.skill.api.exception.SkillTreeException;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.tree.basic.InventoryTree;
import java.util.Collections;
import java.util.List;

public class BasicVerticalTree
extends InventoryTree {
    private int width;

    public BasicVerticalTree(SkillAPI api, RPGClass tree) {
        super(api, tree);
    }

    @Override
    public void arrange(List<Skill> skills) throws SkillTreeException {
        Skill skill;
        Collections.sort(skills, comparator);
        this.height = 0;
        int i = -1;
        while (++i < skills.size() && (skill = skills.get(i)).getSkillReq() == null) {
            this.skillSlots.put(i, skill);
            this.width = this.placeChildren(skills, skill, i + 9, 0);
        }
        this.height = Math.max(this.height, 1);
        if (this.width >= 9) {
            throw new SkillTreeException("Error generating the skill tree: " + this.tree.getName() + " - too large of a tree!");
        }
    }

    private int placeChildren(List<Skill> skills, Skill skill, int slot, int depth) throws SkillTreeException {
        if (depth + 1 > this.height) {
            this.height = depth + 1;
        }
        int width = 0;
        for (Skill s : skills) {
            if (s.getSkillReq() == null || !s.getSkillReq().equalsIgnoreCase(skill.getName())) continue;
            this.skillSlots.put(slot + width, s);
            width += this.placeChildren(skills, s, slot + width + 9, depth + 1);
        }
        return Math.max(width, 1);
    }
}

