/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.manager;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.SkillPlugin;
import com.sucy.skill.api.classes.RPGClass;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.dynamic.ComponentRegistry;
import com.sucy.skill.dynamic.DynamicClass;
import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.log.LogType;
import com.sucy.skill.log.Logger;
import com.sucy.skill.util.ConfigurationException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import mc.promcteam.engine.mccore.config.CommentedConfig;
import mc.promcteam.engine.mccore.config.parse.DataSection;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class RegistrationManager {
    private static final String SKILL_FOLDER = "dynamic" + File.separator + "skill";
    private static final String CLASS_FOLDER = "dynamic" + File.separator + "class";
    private static final String SKILL_DIR = SKILL_FOLDER + File.separator;
    private static final String CLASS_DIR = CLASS_FOLDER + File.separator;
    private final SkillAPI api;
    private final CommentedConfig skillConfig;
    private final CommentedConfig classConfig;
    private Mode mode = Mode.STARTUP;

    public RegistrationManager(SkillAPI api) {
        this.api = api;
        this.skillConfig = new CommentedConfig((JavaPlugin)api, "dynamic" + File.separator + "skills");
        this.classConfig = new CommentedConfig((JavaPlugin)api, "dynamic" + File.separator + "classes");
        new File(api.getDataFolder().getAbsolutePath() + File.separator + "dynamic" + File.separator + "skill").mkdirs();
        new File(api.getDataFolder().getAbsolutePath() + File.separator + "dynamic" + File.separator + "class").mkdirs();
    }

    public void initialize() {
        if (!this.skillConfig.getConfigFile().exists()) {
            this.skillConfig.save();
        }
        if (!this.classConfig.getConfigFile().exists()) {
            this.classConfig.save();
        }
        Logger.log(LogType.REGISTRATION, 1, "Loading components...");
        for (Plugin plugin : this.api.getServer().getPluginManager().getPlugins()) {
            if (!(plugin instanceof SkillPlugin)) continue;
            try {
                Logger.log(LogType.REGISTRATION, 2, " - " + plugin.getName());
                ((SkillPlugin)plugin).getTriggers().forEach(ComponentRegistry::register);
                ((SkillPlugin)plugin).getComponents().forEach(ComponentRegistry::register);
            }
            catch (Throwable t) {
                Logger.invalid("Plugin \"" + plugin.getName() + "\" failed to register skills. Error details:");
                t.printStackTrace();
            }
        }
        ComponentRegistry.save();
        Logger.log(LogType.REGISTRATION, 1, "Loading skills...");
        this.mode = Mode.SKILL;
        for (Plugin plugin : this.api.getServer().getPluginManager().getPlugins()) {
            if (!(plugin instanceof SkillPlugin)) continue;
            try {
                Logger.log(LogType.REGISTRATION, 2, " - " + plugin.getName());
                ((SkillPlugin)plugin).registerSkills(this.api);
            }
            catch (Throwable t) {
                Logger.invalid("Plugin \"" + plugin.getName() + "\" failed to register skills. Error details:");
                t.printStackTrace();
            }
        }
        this.mode = Mode.DYNAMIC;
        if (!this.skillConfig.getConfig().getBoolean("loaded", false)) {
            Logger.log(LogType.REGISTRATION, 1, "Loading dynamic skills from skills.yml...");
            this.skillConfig.getConfig().set("loaded", (Object)true);
            for (String key : this.skillConfig.getConfig().keys()) {
                if (!this.skillConfig.getConfig().isSection(key)) {
                    Logger.log(LogType.REGISTRATION, 3, "Skipping \"" + key + "\" because it isn't a configuration section");
                    continue;
                }
                try {
                    DynamicSkill skill = new DynamicSkill(key);
                    skill.load(this.skillConfig.getConfig().getSection(key));
                    if (!SkillAPI.isSkillRegistered(skill.getName())) {
                        this.api.addDynamicSkill(skill);
                        skill.registerEvents(this.api);
                        CommentedConfig sConfig = new CommentedConfig((JavaPlugin)this.api, SKILL_DIR + key);
                        sConfig.clear();
                        skill.save(sConfig.getConfig().createSection(key));
                        skill.save(this.skillConfig.getConfig().createSection(key));
                        sConfig.save();
                        Logger.log(LogType.REGISTRATION, 2, "Loaded the dynamic skill: " + key);
                        continue;
                    }
                    Logger.invalid("Duplicate skill detected: " + key);
                }
                catch (Exception ex) {
                    Logger.invalid("Failed to load skill: " + key + " - " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
        } else {
            Logger.log(LogType.REGISTRATION, 1, "skills.yml doesn't have any changes, skipping it");
        }
        Logger.log(LogType.REGISTRATION, 1, "Loading individual dynamic skill files...");
        File skillRoot = new File(this.api.getDataFolder().getPath() + File.separator + SKILL_FOLDER);
        if (skillRoot.exists()) {
            Path skillRootPath = skillRoot.toPath();
            try {
                Files.walk(skillRootPath, new FileVisitOption[0]).forEach(path -> {
                    String longName = this.getQualifiedFileName(skillRootPath, (Path)path);
                    if (longName == null) {
                        return;
                    }
                    String name = path.getFileName().toString().replace(".yml", "");
                    try {
                        CommentedConfig sConfig = new CommentedConfig((JavaPlugin)this.api, SKILL_DIR + longName);
                        DynamicSkill skill = new DynamicSkill(name);
                        DataSection section = this.getBaseSection(sConfig, name);
                        skill.load(section);
                        if (!SkillAPI.isSkillRegistered(skill.getName())) {
                            this.api.addDynamicSkill(skill);
                            skill.registerEvents(this.api);
                            sConfig.clear();
                            skill.save(sConfig.getConfig().createSection(name));
                            skill.save(this.skillConfig.getConfig().createSection(name));
                            sConfig.save();
                            Logger.log(LogType.REGISTRATION, 2, "Loaded the dynamic skill: " + name);
                        } else if (SkillAPI.getSkill(name) instanceof DynamicSkill) {
                            Logger.log(LogType.REGISTRATION, 3, name + " is already loaded, skipping it");
                        } else {
                            Logger.invalid("Duplicate skill detected: " + name);
                        }
                    }
                    catch (Exception ex) {
                        Logger.invalid("Failed to load skill: " + name + " - " + ex.getMessage());
                        if (ex instanceof NullPointerException) {
                            Logger.log("Please check that " + SKILL_DIR + name + ".yml exists and has proper contents");
                        }
                        ex.printStackTrace();
                    }
                });
            }
            catch (IOException ex) {
                Logger.invalid("Failed to read dynamic skills: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        Logger.log(LogType.REGISTRATION, 1, "Loading classes...");
        this.mode = Mode.CLASS;
        for (Plugin plugin : this.api.getServer().getPluginManager().getPlugins()) {
            if (!(plugin instanceof SkillPlugin)) continue;
            Logger.log(LogType.REGISTRATION, 2, " - " + plugin.getName());
            try {
                ((SkillPlugin)plugin).registerClasses(this.api);
            }
            catch (Throwable t) {
                Logger.invalid("Plugin \"" + plugin.getName() + "\" failed to register classes. Error details:");
                t.printStackTrace();
            }
        }
        if (!this.classConfig.getConfig().getBoolean("loaded", false)) {
            Logger.log(LogType.REGISTRATION, 1, "Loading dynamic classes from classes.yml...");
            this.classConfig.getConfig().set("loaded", (Object)true);
            for (String key : this.classConfig.getConfig().keys()) {
                if (key.equals("loaded")) continue;
                try {
                    DynamicClass tree = new DynamicClass(this.api, key);
                    tree.load(this.classConfig.getConfig().getSection(key));
                    if (!SkillAPI.isClassRegistered(tree.getName())) {
                        this.api.addDynamicClass(tree);
                        CommentedConfig cConfig = new CommentedConfig((JavaPlugin)this.api, CLASS_DIR + key);
                        cConfig.clear();
                        tree.save(cConfig.getConfig().createSection(key));
                        tree.save(this.classConfig.getConfig().createSection(key));
                        cConfig.save();
                        Logger.log(LogType.REGISTRATION, 2, "Loaded the dynamic class: " + key);
                        continue;
                    }
                    Logger.invalid("Duplicate class detected: " + key);
                }
                catch (Exception ex) {
                    Logger.invalid("Failed to load class \"" + key + "\"");
                    ex.printStackTrace();
                }
            }
        } else {
            Logger.log(LogType.REGISTRATION, 1, "classes.yml doesn't have any changes, skipping it");
        }
        Logger.log(LogType.REGISTRATION, 1, "Loading individual dynamic class files...");
        File classRoot = new File(this.api.getDataFolder().getPath() + File.separator + CLASS_FOLDER);
        if (classRoot.exists()) {
            Path classRootPath = classRoot.toPath();
            try {
                Files.walk(classRootPath, new FileVisitOption[0]).forEach(path -> {
                    String longName = this.getQualifiedFileName(classRootPath, (Path)path);
                    if (longName == null) {
                        return;
                    }
                    String name = path.getFileName().toString().replace(".yml", "");
                    try {
                        CommentedConfig cConfig = new CommentedConfig((JavaPlugin)this.api, CLASS_DIR + longName);
                        DynamicClass tree = new DynamicClass(this.api, name);
                        DataSection section = this.getBaseSection(cConfig, name);
                        tree.load(section);
                        if (!SkillAPI.isClassRegistered(tree.getName())) {
                            this.api.addDynamicClass(tree);
                            cConfig.clear();
                            tree.save(cConfig.getConfig().createSection(name));
                            tree.save(this.classConfig.getConfig().createSection(name));
                            cConfig.save();
                            Logger.log(LogType.REGISTRATION, 2, "Loaded the dynamic class: " + name);
                        } else if (SkillAPI.getClass(name) instanceof DynamicClass) {
                            Logger.log(LogType.REGISTRATION, 3, name + " is already loaded, skipping it");
                        } else {
                            Logger.invalid("Duplicate class detected: " + name);
                        }
                    }
                    catch (Exception ex) {
                        Logger.invalid("Failed to load class file: " + name + " - " + ex.getMessage());
                    }
                });
            }
            catch (IOException ex) {
                Logger.invalid("Failed to read dynamic classes: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        this.skillConfig.save();
        this.classConfig.save();
        this.mode = Mode.DONE;
        for (RPGClass c : SkillAPI.getClasses().values()) {
            c.arrange();
        }
        Logger.log(LogType.REGISTRATION, 0, "Registration complete");
        Logger.log(LogType.REGISTRATION, 0, " - " + SkillAPI.getSkills().size() + " skills");
        Logger.log(LogType.REGISTRATION, 0, " - " + SkillAPI.getClasses().size() + " classes");
    }

    private String getQualifiedFileName(Path root, Path path) {
        String longName = root.relativize(path).toString();
        if (!longName.endsWith(".yml")) {
            return null;
        }
        longName = longName.replace(".yml", "");
        return longName;
    }

    private DataSection getBaseSection(CommentedConfig config, String name) throws ConfigurationException {
        DataSection configSection = config.getConfig();
        String sectionName = name;
        if (name == null || name.isBlank() || !configSection.has(name)) {
            sectionName = (String)configSection.keys().stream().findFirst().orElseThrow(() -> new ConfigurationException(name + ".yml does not appear to contain any class data"));
        }
        return configSection.getSection(sectionName);
    }

    public Skill validate(Skill skill) {
        if (this.mode != Mode.SKILL) {
            throw new IllegalStateException("Skills cannot be added outside the provided SkillPlugin method");
        }
        if (skill == null) {
            throw new IllegalArgumentException("Cannot register a null skill");
        }
        if (SkillAPI.isSkillRegistered(skill.getName())) {
            Logger.invalid("Duplicate skill name: \"" + skill.getName() + "\" - skipping the duplicate");
        } else {
            CommentedConfig singleFile = new CommentedConfig((JavaPlugin)this.api, "skill" + File.separator + skill.getName());
            DataSection config = singleFile.getConfig();
            try {
                skill.softSave(config);
                skill.load(config);
                skill.save(config);
                singleFile.save();
                if (skill instanceof Listener) {
                    Bukkit.getServer().getPluginManager().registerEvents((Listener)skill, (Plugin)this.api);
                }
                return skill;
            }
            catch (Exception ex) {
                Logger.bug("Failed to save skill data to config for \"" + skill.getName() + "\" - skipping registration");
                ex.printStackTrace();
            }
        }
        return null;
    }

    public RPGClass validate(RPGClass rpgClass) {
        if (this.mode != Mode.CLASS) {
            throw new IllegalStateException("Classes cannot be added outside the provided SkillPlugin method");
        }
        if (rpgClass == null) {
            throw new IllegalArgumentException("Cannot register a null class");
        }
        if (SkillAPI.isClassRegistered(rpgClass.getName())) {
            Logger.invalid("Duplicate class name: \"" + rpgClass.getName() + "\" - skipping the duplicate");
        } else {
            CommentedConfig singleFile = new CommentedConfig((JavaPlugin)this.api, "class" + File.separator + rpgClass.getName());
            DataSection config = singleFile.getConfig();
            try {
                rpgClass.softSave(config);
                rpgClass.load(config);
                rpgClass.save(config);
                singleFile.save();
                return rpgClass;
            }
            catch (Exception ex) {
                Logger.bug("Failed to save class data to config for \"" + rpgClass.getName() + "\" - skipping registration");
                ex.printStackTrace();
            }
        }
        return null;
    }

    public boolean isAddingDynamicSkills() {
        return this.mode == Mode.DYNAMIC;
    }

    public static enum Mode {
        STARTUP,
        SKILL,
        CLASS,
        DYNAMIC,
        DONE;

    }
}

