/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.listener;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.enums.ExpSource;
import com.sucy.skill.api.event.PhysicalDamageEvent;
import com.sucy.skill.api.event.SkillDamageEvent;
import com.sucy.skill.api.event.TrueDamageEvent;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.util.BuffManager;
import com.sucy.skill.api.util.FlagManager;
import com.sucy.skill.listener.ListenerUtil;
import com.sucy.skill.listener.SkillAPIListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import mc.promcteam.engine.utils.Reflex;
import mc.promcteam.engine.utils.reflection.ReflectionUtil;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.metadata.Metadatable;

public class KillListener
extends SkillAPIListener {
    private static final String S_TYPE = "sType";
    private static final int SPAWNER = 0;
    private static final int EGG = 1;
    private Method handle;
    private Field killer;
    private Field damageTime;

    public KillListener() {
        try {
            Class living = ReflectionUtil.MINOR_VERSION >= 17 ? Reflex.getClass((String)"net.minecraft.world.entity.EntityLiving") : Reflex.getNMSClass((String)"EntityLiving");
            this.handle = Reflex.getCraftClass((String)"entity.CraftEntity").getDeclaredMethod("getHandle", new Class[0]);
            this.killer = ReflectionUtil.MINOR_VERSION == 17 ? living.getDeclaredField("bc") : (ReflectionUtil.MINOR_VERSION >= 18 ? living.getDeclaredField("bd") : living.getDeclaredField("killer"));
            this.damageTime = ReflectionUtil.MINOR_VERSION == 17 ? living.getDeclaredField("bd") : (ReflectionUtil.MINOR_VERSION >= 18 ? living.getDeclaredField("be") : living.getDeclaredField("lastDamageByPlayerTime"));
            this.damageTime.setAccessible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void giveExp(LivingEntity entity, Player killer, int exp) {
        if (!SkillAPI.getSettings().isWorldEnabled(entity.getWorld())) {
            return;
        }
        if (entity.hasMetadata(S_TYPE)) {
            int value = SkillAPI.getMetaInt((Metadatable)entity, S_TYPE);
            if (value == 0 && SkillAPI.getSettings().isBlockSpawner()) {
                return;
            }
            if (value == 1 && SkillAPI.getSettings().isBlockEgg()) {
                return;
            }
        }
        if (entity.hasMetadata("sapiSumDamage")) {
            return;
        }
        if (killer != null && killer.hasPermission("skillapi.exp")) {
            if (killer.getGameMode() == GameMode.CREATIVE && SkillAPI.getSettings().isBlockCreative()) {
                return;
            }
            PlayerData player = SkillAPI.getPlayerData((OfflinePlayer)killer);
            if (SkillAPI.getSettings().isUseOrbs()) {
                player.giveExp(exp, ExpSource.MOB);
            } else {
                String name = ListenerUtil.getName((Entity)entity);
                double yield = SkillAPI.getSettings().getYield(name);
                player.giveExp(yield, ExpSource.MOB);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onKill(EntityDeathEvent event) {
        FlagManager.clearFlags(event.getEntity());
        BuffManager.clearData(event.getEntity());
        KillListener.giveExp(event.getEntity(), event.getEntity().getKiller(), event.getDroppedExp());
    }

    @EventHandler
    public void onSpawn(CreatureSpawnEvent event) {
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER) {
            SkillAPI.setMeta((Metadatable)event.getEntity(), S_TYPE, 0);
        } else if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER_EGG) {
            SkillAPI.setMeta((Metadatable)event.getEntity(), S_TYPE, 1);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPhysical(PhysicalDamageEvent event) {
        if (event.getDamager() instanceof Player) {
            this.setKiller(event.getTarget(), (Player)event.getDamager());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSpell(SkillDamageEvent event) {
        if (event.getDamager() instanceof Player) {
            this.setKiller(event.getTarget(), (Player)event.getDamager());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTrue(TrueDamageEvent event) {
        if (event.getDamager() instanceof Player) {
            this.setKiller(event.getTarget(), (Player)event.getDamager());
        }
    }

    private void setKiller(LivingEntity entity, Player player) {
        try {
            Object hit = this.handle.invoke((Object)entity, new Object[0]);
            Object source = this.handle.invoke((Object)player, new Object[0]);
            this.killer.set(hit, source);
            this.damageTime.set(hit, 100);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

