/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.hook;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sucy.skill.SkillAPI;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;

public class WorldGuardHook {
    private static Method regionMethod;
    private static Class<?> vectorClass;
    private static Constructor<?> vectorConstructor;
    private static Method applicableRegionsMethod;

    public static List<String> getRegionIds(Location loc) {
        try {
            return WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)loc.getWorld())).getApplicableRegionsIDs(BlockVector3.at((double)loc.getX(), (double)loc.getY(), (double)loc.getZ()));
        }
        catch (NoClassDefFoundError ex) {
            try {
                WorldGuardPlugin plugin = (WorldGuardPlugin)SkillAPI.getPlugin(WorldGuardPlugin.class);
                return (List)WorldGuardHook.getApplicableRegionsMethod().invoke(WorldGuardHook.getRegionMethod().invoke((Object)plugin, loc.getWorld()), vectorConstructor.newInstance(loc.getX(), loc.getY(), loc.getZ()));
            }
            catch (Exception e) {
                e.printStackTrace();
                return ImmutableList.of();
            }
        }
    }

    private static Method getApplicableRegionsMethod() throws Exception {
        if (applicableRegionsMethod == null) {
            vectorClass = Class.forName("com.sk89q.worldedit.Vector");
            vectorConstructor = vectorClass.getConstructor(Double.TYPE, Double.TYPE, Double.TYPE);
            applicableRegionsMethod = RegionManager.class.getMethod("getApplicableRegionsIDs", vectorClass);
        }
        return applicableRegionsMethod;
    }

    private static Method getRegionMethod() throws Exception {
        if (regionMethod == null) {
            regionMethod = WorldGuardPlugin.class.getDeclaredMethod("getRegionManager", World.class);
        }
        return regionMethod;
    }
}

