/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.gui.tool;

import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.gui.tool.GUIData;
import com.sucy.skill.gui.tool.GUITool;
import com.sucy.skill.gui.tool.IconHolder;
import java.util.HashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public abstract class GUIHolder<T extends IconHolder>
implements InventoryHolder {
    protected HashMap<String, T> data = new HashMap();
    protected GUIData gui;
    protected PlayerData player;
    protected Inventory inventory;
    protected int page;

    public void set(GUIData gui, PlayerData player, Inventory inv, HashMap<String, T> data) {
        this.gui = gui;
        this.player = player;
        this.inventory = inv;
        this.data = data;
        this.onSetup();
    }

    public T get(int slot) {
        String identifier = this.gui.getPage(this.page).get(slot);
        return (T)(identifier == null ? null : (IconHolder)this.data.get(identifier));
    }

    public void next() {
        this.setPage((this.page + 1) % this.gui.getPages());
    }

    public void prev() {
        this.setPage((this.page + this.gui.getPages() - 1) % this.gui.getPages());
    }

    public void setPage(int page) {
        this.page = page;
        ItemStack[] contents = this.gui.getPage(page).instance(this.player, this.data);
        if (this.gui.getPages() > 1) {
            GUITool.addPageButtons(contents);
        }
        this.inventory.setContents(contents);
    }

    public void handleDrag(InventoryDragEvent event) {
        event.setCancelled(true);
    }

    public void handleClick(InventoryClickEvent event) {
        event.setCancelled(true);
        boolean top = event.getRawSlot() < event.getView().getTopInventory().getSize();
        T result = this.get(event.getSlot());
        if (top && result != null && result.isAllowed((Player)event.getWhoClicked())) {
            if (event.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD || event.getAction() == InventoryAction.HOTBAR_SWAP) {
                this.onHotBar(result, event.getSlot(), event.getHotbarButton());
            } else {
                this.onClick(result, event.getSlot(), event.isLeftClick(), event.isShiftClick());
            }
        } else if (top && this.gui.getPages() > 1) {
            if (this.gui.getSize() == 9) {
                if (event.getSlot() == 7) {
                    this.prev();
                }
                if (event.getSlot() == 8) {
                    this.next();
                }
            } else if (event.getSlot() == 8) {
                this.prev();
            } else if (event.getSlot() == 17) {
                this.next();
            }
        }
    }

    public void handleClose(InventoryCloseEvent event) {
        this.onClose((Player)event.getPlayer());
    }

    protected abstract void onClick(T var1, int var2, boolean var3, boolean var4);

    protected void onHotBar(T type, int from, int to) {
    }

    protected void onSetup() {
    }

    protected void onClose(Player player) {
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

