/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.gui.tool;

import com.google.common.base.Preconditions;
import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.gui.tool.GUIHolder;
import com.sucy.skill.gui.tool.GUIPage;
import com.sucy.skill.gui.tool.GUITool;
import com.sucy.skill.gui.tool.IconHolder;
import com.sucy.skill.tree.basic.InventoryTree;
import java.util.ArrayList;
import java.util.HashMap;
import mc.promcteam.engine.mccore.config.parse.DataSection;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class GUIData {
    private static final String ROWS = "rows";
    private static final String PAGES = "pages";
    private static final String SLOTS = "slots";
    private final ArrayList<GUIPage> pageMap = new ArrayList();
    private int rows = 3;
    private int pages = 1;
    private int nav = 0;

    GUIData() {
        this.pageMap.add(new GUIPage(this));
    }

    GUIData(InventoryTree skillTree) {
        this.rows = skillTree.getHeight();
        try {
            Preconditions.checkArgument((this.rows > 0 && this.rows <= 6 ? 1 : 0) != 0);
        }
        catch (IllegalArgumentException e) {
            SkillAPI.inst().getLogger().warning("Error loading GUI: Rows should be > 0 and <= 6. Rows: " + this.rows);
            throw e;
        }
        this.pageMap.add(new GUIPage(this, skillTree.getSkillSlots()));
    }

    GUIData(DataSection data) {
        if (data != null) {
            this.rows = data.getInt(ROWS, this.rows);
            try {
                Preconditions.checkArgument((this.rows > 0 && this.rows <= 6 ? 1 : 0) != 0);
            }
            catch (IllegalArgumentException e) {
                SkillAPI.inst().getLogger().warning("Error loading GUI: Rows should be > 0 and <= 6. Rows: " + this.rows);
                throw e;
            }
            this.pages = data.getInt(PAGES, this.pages);
            DataSection pages = data.getSection(SLOTS);
            if (pages != null) {
                for (String page : pages.keys()) {
                    if (!pages.isSection(page)) continue;
                    this.pageMap.add(new GUIPage(this, pages.getSection(page)));
                }
            }
        }
        while (this.pageMap.size() < this.pages) {
            this.pageMap.add(new GUIPage(this));
        }
    }

    public void show(GUIHolder handler, PlayerData player, String title, HashMap<String, ? extends IconHolder> data) {
        Inventory inv = Bukkit.getServer().createInventory((InventoryHolder)handler, this.rows * 9, title);
        ItemStack[] contents = this.pageMap.get(0).instance(player, data);
        if (this.pages > 1) {
            GUITool.addPageButtons(contents);
        }
        inv.setContents(contents);
        handler.set(this, player, inv, data);
        player.getPlayer().openInventory(inv);
    }

    public GUIPage getPage(int page) {
        return this.pageMap.get(page % this.pages);
    }

    public GUIPage getPage() {
        return this.pageMap.get(this.nav);
    }

    public int getSize() {
        return this.rows * 9;
    }

    public void init(ItemStack[] contents) {
        this.nav = 0;
        this.fill(contents);
    }

    public void load(ItemStack[] contents) {
        this.pageMap.get(this.nav).load(contents);
    }

    public void fill(ItemStack[] contents) {
        this.pageMap.get(this.nav).fill(contents);
    }

    public void next() {
        this.nav = (this.nav + 1) % this.pages;
    }

    public void prev() {
        this.nav = (this.nav + this.pages - 1) % this.pages;
    }

    public int getPages() {
        return this.pages;
    }

    public void addPage() {
        this.pageMap.add(new GUIPage(this));
        ++this.pages;
        ++this.nav;
        if (this.pages == 2) {
            for (GUIPage page : this.pageMap) {
                page.clearRight();
            }
        }
    }

    public void removePage() {
        this.pageMap.remove(this.nav);
        --this.pages;
        this.nav = Math.min(this.nav, this.pages - 1);
        if (this.pages == 0) {
            this.addPage();
        }
    }

    public void resize(int rows) {
        this.rows = Math.max(Math.min(rows, 6), 1);
    }

    public void shrink() {
        if (this.rows > 1) {
            --this.rows;
        }
        for (GUIPage page : this.pageMap) {
            page.remove(this.getSize(), this.getSize() + 9);
        }
    }

    public void grow() {
        if (this.rows < 6) {
            ++this.rows;
        }
    }

    public boolean isValid() {
        for (GUIPage page : this.pageMap) {
            if (!page.isValid()) continue;
            return true;
        }
        return false;
    }

    public boolean has(String item) {
        for (GUIPage page : this.pageMap) {
            if (page.getIndex(item) == -1) continue;
            return true;
        }
        return false;
    }

    public void save(DataSection data) {
        data.set(ROWS, (Object)this.rows);
        data.set(PAGES, (Object)this.pages);
        DataSection slots = data.createSection(SLOTS);
        int i = 0;
        for (GUIPage page : this.pageMap) {
            page.save(slots.createSection("" + ++i));
        }
    }
}

