/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.target;

import com.sucy.skill.api.target.TargetHelper;
import com.sucy.skill.cast.ConePreview;
import com.sucy.skill.cast.PreviewSettings;
import com.sucy.skill.dynamic.target.TargetComponent;
import java.util.List;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ConeTarget
extends TargetComponent {
    private static final String ANGLE = "angle";
    private static final String RANGE = "range";
    private ConePreview preview;

    @Override
    void playPreview(Player caster, int level, LivingEntity target, int step) {
        double arc = this.parseValues((LivingEntity)caster, ANGLE, level, 90.0) * Math.PI / 180.0;
        double radius = this.parseValues((LivingEntity)caster, RANGE, level, 3.0);
        if (this.preview == null || this.preview.getArc() != arc || this.preview.getRadius() != radius) {
            this.preview = new ConePreview(arc, radius);
        }
        this.preview.playParticles(caster, PreviewSettings.particle, target.getLocation(), step);
    }

    @Override
    List<LivingEntity> getTargets(LivingEntity caster, int level, List<LivingEntity> targets) {
        double range = this.parseValues(caster, RANGE, level, 3.0);
        double angle = this.parseValues(caster, ANGLE, level, 90.0);
        return this.determineTargets(caster, level, targets, t -> TargetHelper.getConeTargets(t, angle, range));
    }

    @Override
    public String getKey() {
        return "cone";
    }
}

