/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;

public class WarpLocMechanic
extends MechanicComponent {
    private static final String WORLD = "world";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String Z = "z";
    private static final String YAW = "yaw";
    private static final String PITCH = "pitch";

    @Override
    public String getKey() {
        return "warp location";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        World w;
        if (targets.size() == 0) {
            return false;
        }
        String world = this.settings.getString(WORLD, "current");
        if (world.equalsIgnoreCase("current")) {
            world = caster.getWorld().getName();
        }
        if ((w = Bukkit.getWorld((String)world)) == null) {
            return false;
        }
        double x = this.settings.getDouble(X, 0.0);
        double y = this.settings.getDouble(Y, 0.0);
        double z = this.settings.getDouble(Z, 0.0);
        float yaw = (float)this.settings.getDouble(YAW, 0.0);
        float pitch = (float)this.settings.getDouble(PITCH, 0.0);
        Location loc = new Location(w, x, y, z, yaw, pitch);
        for (LivingEntity target : targets) {
            target.teleport(loc);
        }
        return targets.size() > 0;
    }
}

