/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.HashMap;
import java.util.List;
import org.bukkit.entity.LivingEntity;

public class ValueHealthMechanic
extends MechanicComponent {
    private static final String KEY = "key";
    private static final String TYPE = "type";

    @Override
    public String getKey() {
        return "value health";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        String key = this.settings.getString(KEY);
        String type = this.settings.getString(TYPE, "current").toLowerCase();
        HashMap<String, Object> data = DynamicSkill.getCastData(caster);
        LivingEntity target = targets.get(0);
        switch (type) {
            case "max": {
                data.put(key, target.getMaxHealth());
                break;
            }
            case "percent": {
                data.put(key, target.getHealth() / target.getMaxHealth());
                break;
            }
            case "missing": {
                data.put(key, target.getMaxHealth() - target.getHealth());
                break;
            }
            default: {
                data.put(key, target.getHealth());
            }
        }
        return true;
    }
}

