/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.List;
import mc.promcteam.engine.mccore.util.VersionManager;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class DurabilityMechanic
extends MechanicComponent {
    private static final String AMOUNT = "amount";
    private static final String OFFHAND = "offhand";

    @Override
    public String getKey() {
        return "durability";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (!(caster instanceof Player)) {
            return false;
        }
        Player player = (Player)caster;
        boolean offhand = this.settings.getBool(OFFHAND, false);
        short amount = (short)(this.parseValues(caster, AMOUNT, level, 1.0) * (double)targets.size());
        ItemStack item = offhand && VersionManager.isVersionAtLeast((int)VersionManager.V1_9_0) ? player.getInventory().getItemInOffHand() : player.getInventory().getItemInHand();
        if (item == null || item.getType().getMaxDurability() == 0) {
            return false;
        }
        int durability = item.getType().getMaxDurability() - item.getDurability();
        if (durability <= -amount) {
            if (offhand && VersionManager.isVersionAtLeast((int)VersionManager.V1_9_0)) {
                player.getInventory().setItemInOffHand(null);
            } else {
                player.getInventory().setItemInMainHand(null);
            }
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
        }
        item.setDurability((short)(item.getDurability() - amount));
        return true;
    }
}

