/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.condition;

import com.sucy.skill.dynamic.condition.ConditionComponent;
import com.sucy.skill.hook.VaultHook;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class MoneyCondition
extends ConditionComponent {
    private static final String TYPE = "type";
    private static final String MIN_VALUE = "min-value";
    private static final String MAX_VALUE = "max-value";

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        if (!VaultHook.isEconomyValid() || !(target instanceof Player)) {
            return false;
        }
        CompareType type = CompareType.BETWEEN;
        try {
            type = CompareType.valueOf(this.settings.getString(TYPE, "between").toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        double balance = VaultHook.getBalance((Player)target);
        boolean result = false;
        switch (type) {
            case MIN: {
                result = balance >= this.parseValues(caster, MIN_VALUE, level, 0.0);
                break;
            }
            case MAX: {
                result = balance <= this.parseValues(caster, MAX_VALUE, level, 0.0);
                break;
            }
            case BETWEEN: {
                result = balance >= this.parseValues(caster, MIN_VALUE, level, 0.0) && balance <= this.parseValues(caster, MAX_VALUE, level, 0.0);
            }
        }
        return result;
    }

    @Override
    public String getKey() {
        return "money";
    }

    private static enum CompareType {
        MIN,
        MAX,
        BETWEEN;

    }
}

