/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.condition;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.player.PlayerSkill;
import com.sucy.skill.dynamic.condition.ConditionComponent;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ManaCondition
extends ConditionComponent {
    private static final String TYPE = "type";
    private static final String MIN = "min-value";
    private static final String MAX = "max-value";

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        double value;
        if (!(target instanceof Player)) {
            return false;
        }
        String type = this.settings.getString(TYPE).toLowerCase();
        double min = this.parseValues(caster, MIN, level, 0.0);
        double max = this.parseValues(caster, MAX, level, 99.0);
        PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)((Player)target));
        PlayerSkill skill = this.getSkillData(caster);
        double mana = data.getMana();
        switch (type) {
            case "difference percent": {
                value = (mana - skill.getPlayerData().getMana()) * 100.0 / skill.getPlayerData().getMana();
                break;
            }
            case "difference": {
                value = mana - skill.getPlayerData().getMana();
                break;
            }
            case "percent": {
                value = mana * 100.0 / data.getMaxMana();
                break;
            }
            default: {
                value = mana;
            }
        }
        return value >= min && value <= max;
    }

    @Override
    public String getKey() {
        return "mana";
    }
}

