/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.condition;

import com.sucy.skill.dynamic.condition.ConditionComponent;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class FoodCondition
extends ConditionComponent {
    private static final String TYPE = "type";
    private static final String MIN = "min-value";
    private static final String MAX = "max-value";

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        double value;
        if (!(target instanceof Player)) {
            return false;
        }
        String type = this.settings.getString(TYPE).toLowerCase();
        double min = this.parseValues(caster, MIN, level, 0.0);
        double max = this.parseValues(caster, MAX, level, 999.0);
        switch (type) {
            case "difference percent": {
                value = (((Player)target).getFoodLevel() - ((Player)caster).getFoodLevel()) * 100 / ((Player)caster).getFoodLevel();
                break;
            }
            case "difference": {
                value = ((Player)target).getFoodLevel() - ((Player)caster).getFoodLevel();
                break;
            }
            case "percent": {
                value = ((Player)target).getFoodLevel() * 100 / 20;
                break;
            }
            default: {
                value = ((Player)target).getFoodLevel();
            }
        }
        return value >= min && value <= max;
    }

    @Override
    public String getKey() {
        return "food";
    }
}

